/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.fastpath.util;

import com.ibm.ws.persistence.fastpath.util.FastPathStatistics;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.QueryMetaData;

public class FastPathStatisticsImpl
implements FastPathStatistics {
    private static final Localizer _loc = Localizer.forPackage(FastPathStatisticsImpl.class);
    private final Map<ClassMapping, Count> _find = new HashMap<ClassMapping, Count>();
    private final Map<FieldMapping, Count> _load = new HashMap<FieldMapping, Count>();
    private final Map<QueryMetaData, Count> _query = new HashMap<QueryMetaData, Count>();
    private final boolean _collect;
    private int _loadCount = 0;
    private int _findCount = 0;
    private int _queryCount = 0;

    public FastPathStatisticsImpl(boolean collect) {
        this._collect = collect;
    }

    public void findHit(ClassMapping cm) {
        if (!this._collect || cm == null) {
            return;
        }
        Count c = this._find.get(cm);
        if (c == null) {
            c = new Count(cm);
            this._find.put(cm, c);
        }
        c.inc();
        ++this._findCount;
    }

    public void loadHit(FieldMapping fm) {
        if (!this._collect || fm == null) {
            return;
        }
        Count c = this._load.get(fm);
        if (c == null) {
            c = new Count(fm);
            this._load.put(fm, c);
        }
        c.inc();
        ++this._loadCount;
    }

    public void queryHit(QueryMetaData qmd) {
        if (!this._collect || qmd == null) {
            return;
        }
        Count c = this._query.get(qmd);
        if (c == null) {
            c = new Count(qmd);
            this._query.put(qmd, c);
        }
        c.inc();
        ++this._queryCount;
    }

    @Override
    public int getFindHitCountByType(ClassMapping cm) {
        if (!this._collect || cm == null) {
            return -1;
        }
        Count c = this._find.get(cm);
        return c == null ? -1 : c.get();
    }

    @Override
    public int getFindHitCount() {
        if (!this._collect) {
            return -1;
        }
        return this._findCount;
    }

    @Override
    public int getLoadHitCount() {
        if (!this._collect) {
            return -1;
        }
        return this._loadCount;
    }

    @Override
    public int getLoadHitCountByType(FieldMapping fm) {
        if (!this._collect || fm == null) {
            return -1;
        }
        Count c = this._load.get(fm);
        return c == null ? -1 : c.get();
    }

    @Override
    public int getQueryHitCount() {
        if (!this._collect) {
            return -1;
        }
        return this._queryCount;
    }

    @Override
    public int getQueryHitCountByType(QueryMetaData qmd) {
        if (!this._collect || qmd == null) {
            return -1;
        }
        Count c = this._query.get(qmd);
        return c == null ? -1 : c.get();
    }

    @Override
    public void dump(OutputStream out) {
        this.dump(new PrintStream(out));
    }

    @Override
    public void dump(PrintStream out) {
        if (!this._collect) {
            out.println(_loc.get("fastpathstatistics-not-enabled").getMessage());
            return;
        }
        out.println("******");
        out.println("******");
        out.println("******");
        out.println(_loc.get("fastpathstatistics-dumping").getMessage());
        Object[] counts = this._find.values().toArray(new Count[0]);
        Arrays.sort(counts);
        out.println();
        out.println(_loc.get("fastpathstatistics-find").getMessage());
        for (Object c : counts) {
            out.println(c);
        }
        counts = this._load.values().toArray(new Count[0]);
        Arrays.sort(counts);
        out.println();
        out.println(_loc.get("fastpathstatistics-load").getMessage());
        for (Object c : counts) {
            out.println(c);
        }
        counts = this._query.values().toArray(new Count[0]);
        Arrays.sort(counts);
        out.println();
        out.println(_loc.get("fastpathstatistics-query").getMessage());
        for (Count c : this._query.values()) {
            out.println(c);
        }
        out.println();
        out.println("******");
        out.println("******");
        out.println("******");
    }

    @Override
    public void reset() {
        this._findCount = 0;
        this._loadCount = 0;
        this._queryCount = 0;
        for (Count c : this._find.values()) {
            c.reset();
        }
        for (Count c : this._load.values()) {
            c.reset();
        }
        for (Count c : this._query.values()) {
            c.reset();
        }
    }

    private final class Count
    implements Comparable<Count> {
        private final Object _identifier;
        int _hitCount = 0;

        Count(Object identifier) {
            this._identifier = identifier;
        }

        final void inc() {
            ++this._hitCount;
        }

        final int get() {
            return this._hitCount;
        }

        final void reset() {
            this._hitCount = 0;
        }

        @Override
        public int compareTo(Count c) {
            return Integer.valueOf(c._hitCount).compareTo(this._hitCount);
        }

        public String toString() {
            return this._identifier + " => " + this._hitCount;
        }
    }
}

