/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.conf;

import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.fastpath.FastPathManagerFactoryImpl;
import com.ibm.ws.persistence.jdbc.conf.WsJpaAccessIntentValue;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCFetchConfigurationImpl;
import com.ibm.ws.persistence.kernel.conf.WsJpaTaskNameManagerImpl;
import com.ibm.ws.persistence.kernel.conf.WsJpaTasksFactory;
import com.ibm.ws.persistence.objectcache.ObjectCacheManager;
import com.ibm.ws.persistence.objectcache.ObjectCacheManagerImpl;
import java.lang.reflect.Method;
import java.util.Properties;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringValue;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.util.ImplHelper;

public class WsJpaJDBCConfigurationImpl
extends JDBCConfigurationImpl
implements WsJpaJDBCConfiguration {
    private static final long serialVersionUID = -8725393658319487217L;
    public StringValue collectionId = this.addString("jdbc.CollectionId");
    public StringValue pureQueryMode = this.addString("wsjpa.jdbc.PureQueryMode");
    private boolean _runPDQ;
    private Properties _pdqProperties;
    private static Method newPdqPessimisticLockManager;
    public PluginValue accessIntentPlugin;
    boolean _accessIntentInitialized = false;
    public ObjectValue objectCacheManagerPlugin;
    boolean _objectCacheInitialized = false;
    public ObjectValue fastPathManagerPlugin;
    private WsJpaTaskNameManagerImpl taskNameManager;

    public WsJpaJDBCConfigurationImpl() {
        this(true);
    }

    public WsJpaJDBCConfigurationImpl(boolean loadGlobals) {
        this(true, loadGlobals);
    }

    public WsJpaJDBCConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(false, false);
        this.pureQueryMode.set("Compatibility");
        this.accessIntentPlugin = new WsJpaAccessIntentValue();
        this.addValue((Value)this.accessIntentPlugin);
        String[] aliases = new String[]{"default", null, "true", ObjectCacheManagerImpl.class.getName()};
        this.objectCacheManagerPlugin = this.addPlugin("ObjectCache", true);
        this.objectCacheManagerPlugin.setAliases(aliases);
        this.objectCacheManagerPlugin.setDefault(aliases[0]);
        this.objectCacheManagerPlugin.setString(aliases[0]);
        this.objectCacheManagerPlugin.setAliasListComprehensive(true);
        aliases = new String[]{"default", null, "false", null, "true", FastPathManagerFactoryImpl.class.getName()};
        this.fastPathManagerPlugin = this.addPlugin("FastPath", true);
        this.fastPathManagerPlugin.setAliases(aliases);
        this.fastPathManagerPlugin.setDefault(aliases[0]);
        this.fastPathManagerPlugin.setString(aliases[0]);
        this.fastPathManagerPlugin.setAliasListComprehensive(true);
        this.taskNameManager = new WsJpaTaskNameManagerImpl(this);
        if (derivations) {
            ProductDerivations.beforeConfigurationLoad((Configuration)this);
        }
        if (loadGlobals) {
            this.loadGlobals();
        }
    }

    public LockManager newLockManagerInstance() {
        if (!this._runPDQ) {
            return super.newLockManagerInstance();
        }
        LockManager rtnValue = null;
        if (this.getLockManager().equals("pessimistic")) {
            try {
                rtnValue = (LockManager)newPdqPessimisticLockManager.invoke(null, (Object[])null);
            }
            catch (Exception exception) {}
        } else {
            rtnValue = (LockManager)this.lockManagerPlugin.instantiate(LockManager.class, (Configuration)this, false);
        }
        return rtnValue;
    }

    public boolean runPDQ() {
        return this._runPDQ;
    }

    public void setRunPDQ(boolean newValue) {
        this._runPDQ = newValue;
    }

    public void setCollectionId(String id) {
        this.collectionId.setString(id);
    }

    public String getCollectionId() {
        return this.collectionId.getString();
    }

    @Override
    public void setPdqProperties(Properties pdqProperties) {
        this._pdqProperties = pdqProperties;
    }

    @Override
    public Properties getPdqProperties() {
        return this._pdqProperties;
    }

    public String getPureQueryMode() {
        return this.pureQueryMode.getString();
    }

    public void setUsePureQuery(String pdqMode) {
        this.pureQueryMode.setString(pdqMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WsJpaTasksFactory getTasksFactory() {
        if (!this._accessIntentInitialized) {
            WsJpaJDBCConfigurationImpl wsJpaJDBCConfigurationImpl = this;
            synchronized (wsJpaJDBCConfigurationImpl) {
                if (!this._accessIntentInitialized && this.accessIntentPlugin.get() == null) {
                    this.accessIntentPlugin.instantiate(WsJpaTasksFactory.class, (Configuration)this);
                }
                this._accessIntentInitialized = true;
            }
        }
        return (WsJpaTasksFactory)this.accessIntentPlugin.get();
    }

    @Override
    public JDBCFetchConfiguration getAccessIntentFetchConfiguration(JDBCFetchConfiguration fetch, String entityClassName) {
        WsJpaTasksFactory.IsolationLockValue newValue;
        WsJpaTasksFactory taskFactory = this.getTasksFactory();
        if (taskFactory == null) {
            return fetch;
        }
        String taskName = this.taskNameManager.getTSRTaskName();
        if (taskName != null && (newValue = taskFactory.getTasksEntities(taskName, entityClassName)) != null) {
            int newIsolation = newValue.getIsolationLevel();
            int newReadLock = newValue.getReadLock();
            if (!((WsJpaJDBCFetchConfigurationImpl)((Object)fetch)).isCreateForAccessIntent()) {
                WsJpaJDBCFetchConfigurationImpl wsFetch = (WsJpaJDBCFetchConfigurationImpl)((Object)fetch.clone());
                wsFetch.setCreateForAccessIntent();
                fetch = wsFetch;
            }
            if (newIsolation != -1 && fetch.getIsolation() != newIsolation) {
                fetch.setIsolation(newIsolation);
            }
            if (newReadLock != -1 && fetch.getReadLockLevel() != newReadLock) {
                fetch.setReadLockLevel(newReadLock);
            }
        }
        return fetch;
    }

    public void setObjectCache(String objectCache) {
        this.objectCacheManagerPlugin.setString(objectCache);
    }

    @Override
    public ObjectCacheManager getObjectCacheManagerInstance(BrokerFactory bf, boolean start) {
        ObjectCacheManager ocm = (ObjectCacheManager)this.objectCacheManagerPlugin.get();
        if (this._objectCacheInitialized) {
            return ocm;
        }
        if (ocm == null) {
            ocm = (ObjectCacheManager)this.objectCacheManagerPlugin.instantiate(ObjectCacheManager.class, (Configuration)this);
            if (ocm == null) {
                this._objectCacheInitialized = true;
                return null;
            }
            ocm.initialize((OpenJPAConfiguration)this, bf);
        }
        if (ocm != null && start) {
            ocm.startSchedulerAndLoader();
            this._objectCacheInitialized = true;
        }
        return ocm;
    }

    @Override
    public ObjectCacheManager getObjectCacheManagerInstance(BrokerFactory bf) {
        return this.getObjectCacheManagerInstance(bf, true);
    }

    @Override
    public synchronized FastPathManagerFactory getFastPathManagerFactoryInstance() {
        FastPathManagerFactory fpm = (FastPathManagerFactory)this.fastPathManagerPlugin.get();
        if (fpm == null && (fpm = (FastPathManagerFactory)this.fastPathManagerPlugin.instantiate(FastPathManagerFactory.class, (Configuration)this)) != null) {
            fpm.initialize((OpenJPAConfiguration)this);
        }
        return (FastPathManagerFactory)this.fastPathManagerPlugin.get();
    }

    protected void preClose() {
        super.preClose();
        ImplHelper.close((Object)this.objectCacheManagerPlugin.get());
    }

    public String toString() {
        return "WsJpaJDBCConfigurationImpl@" + Integer.toHexString(System.identityHashCode(this)) + ": PDQ " + (this._runPDQ ? "enabled" : "disabled") + ": AccessIntent Task=" + this.accessIntentPlugin.getString();
    }

    static {
        try {
            Class<?> helper = Class.forName("com.ibm.ws.persistence.pdq.conf.PDQConfigurationHelper", false, Thread.currentThread().getContextClassLoader());
            newPdqPessimisticLockManager = helper.getMethod("newPdqPessimisticLockManager", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

