/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.kernel.PreparedStatementManagerImpl;
import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.openjpa.jdbc.kernel.BatchingConstraintUpdateManager;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.util.Localizer;

public class ConstraintUpdateManager
extends BatchingConstraintUpdateManager {
    private static final Localizer _loc = Localizer.forPackage(ConstraintUpdateManager.class);

    protected PreparedStatementManager newPreparedStatementManager(JDBCStore store, Connection conn) {
        int batchLimit = this.dict.getBatchLimit();
        return new PreparedStatementManagerImpl(store, conn, batchLimit);
    }

    protected void flush(Collection deleteUpdates, Collection nodes, PreparedStatementManager psMgr) {
        this.flush(deleteUpdates, psMgr);
        if (deleteUpdates.size() > 0) {
            this.updateDBGenVersion(deleteUpdates, nodes);
        }
        Iterator itr = nodes.iterator();
        while (itr.hasNext()) {
            psMgr.flush((RowImpl)itr.next());
        }
    }

    protected void updateDBGenVersion(Collection deleteUpdates, Collection nodes) {
        RowImpl row;
        HashMap<OpenJPAStateManager, RowImpl> smMap = new HashMap<OpenJPAStateManager, RowImpl>();
        for (Object obj : deleteUpdates) {
            row = (RowImpl)obj;
            smMap.put(row.getPrimaryKey(), row);
        }
        for (Object obj : nodes) {
            VersionStrategy strategy;
            row = (RowImpl)obj;
            StateManagerImpl s = (StateManagerImpl)row.getPrimaryKey();
            if (smMap.get(s) == null || (strategy = ((ClassMapping)s.getMetaData()).getVersion().getStrategy()) == null || !ColumnVersionStrategy.isVersionStrategyColumn(strategy)) continue;
            Object[] vals = row.getVals();
            int whereVersionIdx = -1;
            int versionIdx = -1;
            ClassMapping meta = (ClassMapping)s.getMetaData();
            Column[] cols = row.getColumns();
            Version version = meta.getVersion();
            Column[] vcols = version.getColumns();
            if (vcols == null || vcols.length <= 0) continue;
            Column verCol = vcols[0];
            versionIdx = verCol.getIndex();
            whereVersionIdx = versionIdx + cols.length;
            vals[whereVersionIdx] = s.getVersion();
        }
    }
}

