/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.kernel.ConstraintUpdateManager;
import com.ibm.ws.persistence.jdbc.kernel.DB2BatchHelper;
import com.ibm.ws.persistence.jdbc.kernel.DB2BatchHelperImpl;
import com.ibm.ws.persistence.jdbc.kernel.HeteroPreparedStatementManagerImpl;
import com.ibm.ws.persistence.jdbc.kernel.WASDB2BatchHelperImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManager;
import org.apache.openjpa.lib.jdbc.DelegatingStatement;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public final class HeteroConstraintUpdateManager
extends ConstraintUpdateManager {
    private static final Localizer _loc = Localizer.forPackage(HeteroConstraintUpdateManager.class);
    private static final String DB2_STATEMENT_STR = "com.ibm.db2.jcc.DB2Statement";
    private static final String DB2_WAS_STATEMENT_STR = "com.ibm.ws.jdbc.jcc.DB2Statement";
    private static final Class<?> DB2_STATEMENT_CLS;
    private static final Class<?> DB2_WAS_STATEMENT_CLS;
    private static final String LICENCE_STR = "com.ibm.pdq.runtime.license.License";
    private static final String IS_LICENCED_METHOD = "isLicensed";
    private DB2BatchHelper _helper = null;
    private boolean _supportsHetero = false;

    public void endConfiguration() {
        super.endConfiguration();
        Log log = this.conf.getLog("openjpa.Runtime");
        this._supportsHetero = HeteroConstraintUpdateManager.checkLicense(log);
        if (!this._supportsHetero) {
            log.warn((Object)_loc.get("enablement-problem"));
        }
    }

    @Override
    protected PreparedStatementManager newPreparedStatementManager(JDBCStore store, Connection conn) {
        int batchLimit = this.dict.getBatchLimit();
        if (!this._supportsHetero) {
            return super.newPreparedStatementManager(store, conn);
        }
        if (this._helper == null) {
            if (!this.setHelper(store)) {
                this._supportsHetero = false;
            }
            if (this._helper == null) {
                return super.newPreparedStatementManager(store, conn);
            }
            return new HeteroPreparedStatementManagerImpl(store, conn, batchLimit, this._helper);
        }
        return new HeteroPreparedStatementManagerImpl(store, conn, batchLimit, this._helper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setHelper(JDBCStore store) {
        Log log = store.getConfiguration().getLog("openjpa.Runtime");
        Connection conn = null;
        try {
            conn = store.getConnection();
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                if (stmt instanceof DelegatingStatement) {
                    stmt = ((DelegatingStatement)stmt).getInnermostDelegate();
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            Class<?> stmtCls = stmt.getClass();
            if (DB2_STATEMENT_CLS != null && DB2_STATEMENT_CLS.isAssignableFrom(stmtCls)) {
                this._helper = new DB2BatchHelperImpl();
                boolean bl = true;
                return bl;
            }
            if (DB2_WAS_STATEMENT_CLS != null && DB2_WAS_STATEMENT_CLS.isAssignableFrom(stmtCls)) {
                this._helper = new WASDB2BatchHelperImpl();
            }
        }
        catch (Exception e) {
            log.trace((Object)"HeteroContstrainUpdateManager encountered unexpected exception ", (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("HeteroContstrainUpdateManager setting " + this._helper + " for DB2BatchHelper. db2_cls= " + DB2_STATEMENT_CLS + " was_cls=" + DB2_WAS_STATEMENT_CLS));
        }
        return this._helper != null;
    }

    private static boolean checkLicense(Log logger) {
        block11: {
            Class cls = null;
            try {
                ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
                cls = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)LICENCE_STR, (boolean)true, (ClassLoader)loader));
            }
            catch (Exception cnfe) {
                if (logger != null && logger.isTraceEnabled()) {
                    logger.trace((Object)"Didn't find license for pdq. #001");
                }
                return false;
            }
            if (cls == null && logger != null && logger.isTraceEnabled()) {
                logger.trace((Object)"Didn't find license for pdq. #002");
            }
            try {
                Boolean isLicensed = null;
                Method method = cls.getMethod(IS_LICENCED_METHOD, new Class[0]);
                if (method != null) {
                    isLicensed = (Boolean)method.invoke(null, new Object[0]);
                    if (logger != null && logger.isTraceEnabled()) {
                        logger.trace((Object)("isLicensed -> " + isLicensed));
                    }
                } else if (logger != null && logger.isTraceEnabled()) {
                    logger.trace((Object)"Couldn't find -> isLicensed");
                }
                if (isLicensed != null) {
                    return isLicensed;
                }
            }
            catch (Exception e) {
                if (logger == null || !logger.isTraceEnabled()) break block11;
                logger.trace((Object)"Caught an exception while checking for entitlement. ", (Throwable)e);
            }
        }
        return false;
    }

    static {
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(HeteroConstraintUpdateManager.class));
        Class cls = null;
        try {
            cls = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)DB2_STATEMENT_STR, (boolean)false, (ClassLoader)loader));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DB2_STATEMENT_CLS = cls;
        try {
            cls = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)DB2_WAS_STATEMENT_STR, (boolean)false, (ClassLoader)loader));
        }
        catch (Exception exception) {
            // empty catch block
        }
        DB2_WAS_STATEMENT_CLS = cls;
    }
}

