/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.kernel.DB2BatchHelper;
import com.ibm.ws.persistence.jdbc.kernel.PreparedStatementManagerImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.lib.jdbc.DelegatingPreparedStatement;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OptimisticException;

public class HeteroPreparedStatementManagerImpl
extends PreparedStatementManagerImpl {
    private static final Localizer _loc = Localizer.forPackage(HeteroPreparedStatementManagerImpl.class);
    private final DB2BatchHelper _helper;

    public HeteroPreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit, DB2BatchHelper helper) {
        super(store, conn, batchLimit);
        this._helper = helper;
    }

    protected void batchOrExecuteRow(RowImpl row) throws SQLException {
        this.getBatchedRows().add(row);
    }

    protected void flushBatch() throws SQLException {
        List batchedRows = this.getBatchedRows();
        if (batchedRows == null) {
            return;
        }
        int batchSize = batchedRows.size();
        ArrayList<Statement> stmtList = new ArrayList<Statement>();
        Statement stmt = null;
        try {
            stmt = this.createStatement();
            int count = 0;
            int batchedRowsBaseIndex = 0;
            String currentSQL = null;
            PreparedStatement ps = null;
            for (RowImpl curr : batchedRows) {
                if (count >= this.getBatchLimit() && this.getBatchLimit() != -1) {
                    int[][] rtn = this.executeBatch(stmt, stmtList);
                    this.checkUpdateCount(rtn, batchedRowsBaseIndex, stmt);
                    batchedRowsBaseIndex += this.getBatchLimit();
                    stmt.clearBatch();
                    stmtList.clear();
                    currentSQL = null;
                    count = 0;
                }
                String sql = curr.getSQL(this._dict);
                if (currentSQL == null || !currentSQL.equals(sql)) {
                    ps = this.prepareStatement(sql);
                    stmtList.add(this.unwrap(ps));
                    currentSQL = sql;
                }
                if (ps != null) {
                    curr.flush(ps, this._dict, this._store);
                }
                this.addBatch(ps, curr, count);
                ++count;
            }
            int[][] rtn = this.executeBatch(stmt, stmtList);
            this.checkUpdateCount(rtn, batchedRowsBaseIndex, stmt);
        }
        catch (SQLException se) {
            SQLException sqex = se.getNextException();
            if (sqex == null) {
                sqex = se;
            }
            if (se instanceof ReportingSQLException) {
                int index = ((ReportingSQLException)se).getIndexOfFirstFailedObject();
                if (batchSize == 1) {
                    index = 0;
                }
                if (index < 0) {
                    throw SQLExceptions.getStore((SQLException)se, (Object)stmt, (DBDictionary)this._dict);
                }
                if (this.getBatchedRows().size() == 0) {
                    if (this._log.isTraceEnabled()) {
                        this._log.trace((Object)"No batched rows found. The failed object may not be reliable");
                    }
                    throw SQLExceptions.getStore((SQLException)se, (Object)stmt, (DBDictionary)this._dict);
                }
                throw SQLExceptions.getStore((SQLException)se, (Object)((RowImpl)this.getBatchedRows().get(index)).getFailedObject(), (DBDictionary)this._dict);
            }
            throw SQLExceptions.getStore((SQLException)sqex, (Object)stmt, (DBDictionary)this._dict);
        }
        finally {
            batchedRows.clear();
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sqex) {
                    throw SQLExceptions.getStore((SQLException)sqex, (Object)stmt, (DBDictionary)this._dict);
                }
            }
        }
    }

    protected int[][] executeBatch(Statement stmt, List<Statement> stmts) throws SQLException {
        return this._helper.executeBatch(stmt, stmts);
    }

    private void checkUpdateCount(int[][] count, int batchedRowsBaseIndex, Statement s) throws SQLException {
        int cnt = 0;
        int currRow = batchedRowsBaseIndex;
        Object failed = null;
        List batchedRows = this.getBatchedRows();
        for (int i = 0; i < count.length; ++i) {
            for (int j = 0; j < count[i].length; ++j) {
                cnt = count[i][j];
                RowImpl row = (RowImpl)batchedRows.get(currRow);
                failed = row.getFailedObject();
                switch (cnt) {
                    case -3: {
                        if (failed != null || row.getAction() == 0) {
                            this._exceptions.add(new OptimisticException(failed));
                            break;
                        }
                        if (row.getAction() != 1) break;
                        throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count[i][j]), (Object)row.getSQL(this._dict)).getMessage());
                    }
                    case -2: {
                        if (!this._log.isTraceEnabled()) break;
                        this._log.trace((Object)_loc.get("batch_update_info", (Object)String.valueOf(cnt), (Object)row.getSQL(this._dict)).getMessage());
                        break;
                    }
                    case 0: {
                        this.logSQLWarnings(s);
                        if (failed != null) {
                            this._exceptions.add(new OptimisticException(failed));
                            break;
                        }
                        if (row.getAction() != 1) break;
                        throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(cnt), (Object)row.getSQL(this._dict)).getMessage());
                    }
                }
                ++currRow;
            }
        }
    }

    private Statement createStatement() throws SQLException {
        Statement s = this._conn.createStatement();
        return s;
    }

    private PreparedStatement unwrap(PreparedStatement ps) throws SQLException {
        if (ps instanceof DelegatingPreparedStatement) {
            ps = ((DelegatingPreparedStatement)ps).getInnermostDelegate();
        }
        return ps;
    }
}

