/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.BatchingPreparedStatementManagerImpl;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OptimisticException;

public class PreparedStatementManagerImpl
extends BatchingPreparedStatementManagerImpl {
    private static final Localizer _loc = Localizer.forPackage(PreparedStatementManagerImpl.class);

    public PreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit) {
        super(store, conn, batchLimit);
    }

    protected void flushAndUpdate(RowImpl row) throws SQLException {
        Column[] verCols = this.getVersionStrategyColumns(row);
        if (verCols == null) {
            super.flushAndUpdate(row);
            return;
        }
        String sql = this.getSQL(row, verCols);
        PreparedStatement stmnt = this.prepareStatement(sql);
        if (stmnt != null) {
            row.flush(stmnt, this._dict, this._store);
        }
        try {
            int count = this.executeSQL(stmnt, sql, row, verCols);
            if (count != 1) {
                Object failed = row.getFailedObject();
                if (failed != null) {
                    this._exceptions.add(new OptimisticException(failed));
                } else if (row.getAction() == 1) {
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count), (Object)sql).getMessage());
                }
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore((SQLException)se, (Object)row.getFailedObject(), (DBDictionary)this._dict);
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected String[] getAllAutoAssignColNames(RowImpl row, Column[] autoAssign, Object[] verCol) {
        int i;
        String[] names = null;
        String[] autoAssignColNames = this.getAutoAssignColNames(autoAssign, row);
        int startIdx = 0;
        if (autoAssignColNames != null) {
            names = new String[autoAssignColNames.length + verCol.length];
            for (i = 0; i < autoAssignColNames.length; ++i) {
                names[i] = autoAssignColNames[i];
                startIdx = autoAssign.length;
            }
        } else {
            names = new String[verCol.length];
        }
        for (i = 0; i < verCol.length; ++i) {
            names[startIdx + i] = ((Column)verCol[i]).getName();
        }
        return names;
    }

    protected String getSQL(RowImpl row, Column[] verCols) throws SQLException {
        String sql = row.getSQL(this._dict);
        sql = this.adjustRid(sql, verCols, row);
        if (this.useSelectFromFinalTable(verCols, row)) {
            Column[] autoAssign = this.getAutoAssignColumns(row);
            String[] allAutoAssignColNames = this.getAllAutoAssignColNames(row, autoAssign, verCols);
            StringBuilder sb = new StringBuilder(200);
            sb.append("SELECT ");
            for (int i = 0; i < allAutoAssignColNames.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(allAutoAssignColNames[i]);
            }
            sb.append(" FROM FINAL TABLE (").append(sql).append(")");
            sql = sb.toString();
        }
        return sql;
    }

    private boolean useSelectFromFinalTable(Column[] verCols, RowImpl row) throws SQLException {
        ClassMapping clm;
        VersionStrategy strat;
        OpenJPAStateManager osm = row.getPrimaryKey();
        if (osm != null && (strat = (clm = (ClassMapping)osm.getMetaData()).getVersion().getStrategy()) instanceof ColumnVersionStrategy) {
            ((ColumnVersionStrategy)strat).setTokenVersionType(this._store);
        }
        return this._dict.supportsSelectFromFinalTable && verCols.length == 1 && verCols[0].getJavaType() != 6 && row.getAction() != 2;
    }

    private String adjustRid(String sql, Column[] verCols, RowImpl row) {
        if (row.getAction() == 1) {
            return sql;
        }
        OpenJPAStateManager sm = row.getPrimaryKey();
        if (!(sm instanceof WsJpaStateManagerImpl)) {
            return sql;
        }
        if (!(this._dict instanceof DB2Dictionary)) {
            return sql;
        }
        if (((WsJpaStateManagerImpl)sm).getRid() != null) {
            return sql;
        }
        for (int i = 0; i < verCols.length; ++i) {
            String ridExpr = ((DB2Dictionary)this._dict).getRIDExpr(verCols[i].getTableIdentifier().getName());
            if (sql.indexOf(ridExpr) == -1) continue;
            sql = sql.replace(" AND " + ridExpr + " = ?", " ");
        }
        return sql;
    }

    protected int executeSQL(PreparedStatement stmnt, String sql, RowImpl row, Column[] verCols) throws SQLException {
        int count = 0;
        Column[] autoAssign = this.getAutoAssignColumns(row);
        String[] autoAssignColNames = this.getAutoAssignColNames(autoAssign, row);
        if (this.useSelectFromFinalTable(verCols, row)) {
            ArrayList versionVals;
            ArrayList autoAssignVals;
            ResultSet rs = this.executeQuery(stmnt, sql, row);
            count = this.processResults(rs, autoAssignVals = new ArrayList(), versionVals = new ArrayList(), autoAssignColNames, verCols);
            if (count == 1) {
                if (autoAssignColNames != null) {
                    this.setObjectId(autoAssignVals, autoAssign, autoAssignColNames, row);
                }
                this.setVersion(versionVals, row, verCols);
            }
        } else {
            count = this.executeUpdate(stmnt, sql, row);
            if (count == 1) {
                if (autoAssignColNames != null) {
                    this.setObjectId(null, autoAssign, autoAssignColNames, row);
                }
                this.setVersion(row);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int processResults(ResultSet rs, List autoAssignVals, List versionVals, String[] autoAssignColNames, Column[] verCols) throws SQLException {
        try {
            if (rs.next()) {
                int i;
                if (autoAssignColNames != null) {
                    for (i = 0; i < autoAssignColNames.length; ++i) {
                        autoAssignVals.add(rs.getObject(autoAssignColNames[i]));
                    }
                }
                for (i = 0; i < verCols.length; ++i) {
                    versionVals.add(rs.getObject(verCols[i].getName()));
                }
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            rs.close();
        }
    }

    protected Column[] getVersionStrategyColumns(RowImpl row) {
        OpenJPAStateManager sm = row.getPrimaryKey();
        if (sm == null) {
            return null;
        }
        VersionStrategy strategy = ((ClassMapping)sm.getMetaData()).getVersion().getStrategy();
        if (strategy == null || !ColumnVersionStrategy.isVersionStrategyColumn(strategy)) {
            return null;
        }
        ClassMapping meta = (ClassMapping)sm.getMetaData();
        Version version = meta.getVersion();
        Column[] vcols = version.getColumns();
        if (vcols == null || vcols.length == 0) {
            return null;
        }
        Table rowTbl = row.getTable();
        ArrayList<Column> vcolList = new ArrayList<Column>();
        for (int i = 0; i < vcols.length; ++i) {
            Table vTbl = vcols[i].getTable();
            if (rowTbl != vTbl) continue;
            vcolList.add(vcols[i]);
        }
        if (vcolList.size() == 0) {
            return null;
        }
        return vcolList.toArray(new Column[0]);
    }

    protected ResultSet executeQuery(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        return stmnt.executeQuery();
    }

    protected void setVersion(List vals, RowImpl row, Object[] cols) throws SQLException {
        OpenJPAStateManager sm = row.getPrimaryKey();
        if (sm == null) {
            return;
        }
        Column[] verCols = ((ClassMapping)sm.getMetaData()).getVersion().getColumns();
        Object dbVersion = null;
        if (cols.length > 1) {
            dbVersion = new Object[cols.length];
        }
        for (int i = 0; i < cols.length; ++i) {
            Object db = vals.get(i);
            if (cols.length == 1) {
                dbVersion = db;
                continue;
            }
            dbVersion[i] = db;
        }
        if (verCols.length == 1) {
            sm.setVersion(dbVersion);
        } else {
            Object[] ver = (Object[])sm.getVersion();
            if (ver == null) {
                ver = new Object[verCols.length];
                sm.setVersion((Object)ver);
            }
            for (int i = 0; i < cols.length; ++i) {
                int idx = this.getVersionIndex((Column)cols[i], verCols);
                ver[idx] = cols.length > 1 ? dbVersion[i] : dbVersion;
            }
        }
    }

    protected void setVersion(RowImpl row) throws SQLException {
        block3: {
            Log log = this._store.getConfiguration().getLog("openjpa.jdbc.SQL");
            OpenJPAStateManager sm = row.getPrimaryKey();
            if (sm == null) {
                return;
            }
            VersionStrategy strategy = ((ClassMapping)sm.getMetaData()).getVersion().getStrategy();
            try {
                strategy.checkVersion(sm, this._store, true);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block3;
                log.error((Object)_loc.get("generated-version-field-exception"), (Throwable)e);
            }
        }
    }

    private int getVersionIndex(Column rowVerCol, Column[] verCols) {
        for (int i = 0; i < verCols.length; ++i) {
            if (rowVerCol != verCols[i]) continue;
            return i;
        }
        return -1;
    }

    public JDBCStore getStore() {
        return this._store;
    }
}

