/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCStoreManager;
import com.ibm.ws.persistence.objectcache.ObjectCacheManagerImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.Bootstrap;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaJDBCBrokerFactory
extends JDBCBrokerFactory {
    private static final long serialVersionUID = 1257416402258781723L;
    private static Class helper;
    private static Method configPdq;
    private static Method newPdqStoreManager;
    private static final Localizer _loc;
    private WsJpaJDBCConfiguration _conf;

    public WsJpaJDBCBrokerFactory(JDBCConfiguration conf) {
        super(conf);
        if (conf instanceof WsJpaJDBCConfiguration) {
            this._conf = (WsJpaJDBCConfiguration)conf;
        }
        Log log = this.getLog();
        boolean runPDQ = false;
        Class<?> cls = null;
        try {
            cls = Class.forName("com.ibm.pdq.runtime.Data", false, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        }
        catch (Exception e) {
            if (log != null && log.isTraceEnabled()) {
                log.trace((Object)_loc.get("no-pdq-jar"));
            }
            ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(false);
        }
        if (cls != null) {
            if (log != null && log.isTraceEnabled()) {
                if (helper == null) {
                    log.trace((Object)_loc.get("null-pdqconfig-helper"));
                }
                if (configPdq == null) {
                    log.trace((Object)_loc.get("null-configPdq-method"));
                }
                if (newPdqStoreManager == null) {
                    log.trace((Object)_loc.get("null-pdq-newstore-method"));
                }
                if (cls != null && helper != null && configPdq != null) {
                    log.trace((Object)_loc.get("pdq-jar-loaded", (Object)cls.getName()));
                }
            }
            try {
                if (configPdq != null) {
                    runPDQ = (Boolean)configPdq.invoke(null, new Object[]{this});
                }
                ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(runPDQ);
            }
            catch (Exception e) {
                if (log != null && log.isTraceEnabled()) {
                    String dict = conf.getDBDictionary();
                    log.trace((Object)("DBDictionary: " + dict));
                    log.trace((Object)_loc.get("pdq-exception", (Object[])e.getStackTrace()));
                }
                ((WsJpaJDBCConfigurationImpl)conf).setRunPDQ(true);
            }
        }
    }

    public static WsJpaJDBCBrokerFactory newInstance(ConfigurationProvider cp) {
        WsJpaJDBCConfigurationImpl conf = new WsJpaJDBCConfigurationImpl();
        cp.setInto((Configuration)conf);
        return new WsJpaJDBCBrokerFactory(conf);
    }

    public static WsJpaJDBCBrokerFactory getInstance(ConfigurationProvider cp, ClassLoader loader) {
        Map props = cp.getProperties();
        Object key = WsJpaJDBCBrokerFactory.toPoolKey((Map)props);
        WsJpaJDBCBrokerFactory factory = (WsJpaJDBCBrokerFactory)WsJpaJDBCBrokerFactory.getPooledFactoryForKey((Object)key);
        if (factory != null) {
            return factory;
        }
        factory = (WsJpaJDBCBrokerFactory)Bootstrap.newBrokerFactory((ConfigurationProvider)cp, (ClassLoader)loader);
        WsJpaJDBCBrokerFactory.pool((Object)key, (AbstractBrokerFactory)factory);
        return factory;
    }

    protected DelegatingStoreManager createDelegatingStoreManager() {
        return super.createDelegatingStoreManager();
    }

    protected StoreManager newStoreManager() {
        WsJpaJDBCConfigurationImpl conf = (WsJpaJDBCConfigurationImpl)this.getConfiguration();
        if (conf.runPDQ()) {
            try {
                StoreManager mgr = (StoreManager)newPdqStoreManager.invoke(null, conf);
                conf.setRunPDQ(mgr != null);
                if (mgr != null) {
                    return mgr;
                }
            }
            catch (Exception e) {
                conf.setRunPDQ(false);
            }
        }
        return new WsJpaJDBCStoreManager();
    }

    public void postCreationCallback() {
        super.postCreationCallback();
        OpenJPAConfiguration conf = this.getConfiguration();
        if (conf instanceof WsJpaJDBCConfiguration) {
            WsJpaJDBCConfiguration wconf = (WsJpaJDBCConfiguration)conf;
            FastPathManagerFactory fpmf = wconf.getFastPathManagerFactoryInstance();
            ObjectCacheManagerImpl objectCacheManagerImpl = (ObjectCacheManagerImpl)wconf.getObjectCacheManagerInstance((BrokerFactory)this, false);
        }
    }

    private final Log getLog() {
        return this._conf.getLog("openjpa.Runtime");
    }

    static {
        _loc = Localizer.forPackage(WsJpaJDBCBrokerFactory.class);
        try {
            helper = Class.forName("com.ibm.ws.persistence.pdq.conf.PDQConfigurationHelper");
            configPdq = helper.getMethod("configurePdqPlugins", WsJpaJDBCBrokerFactory.class);
            newPdqStoreManager = helper.getMethod("newPdqStoreManager", JDBCConfiguration.class);
        }
        catch (Exception e) {
            System.err.println(_loc.get("pdqconfig-helper-exception", (Object[])e.getStackTrace()));
        }
    }
}

