/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.fastpath.PrepareStatementListener;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCFetchConfigurationImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.BitSet;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StoreContext;

public class WsJpaJDBCStoreManager
extends JDBCStoreManager {
    PrepareStatementListener _listener;
    boolean _fpEnabled = false;

    public void setPrepareStatementListener(PrepareStatementListener list) {
        Broker broker = (Broker)this.getContext();
        if (this._listener != null) {
            broker.removeTransactionListener((Object)this._listener);
        }
        if (list != null) {
            broker.addTransactionListener((Object)list);
        }
        this._listener = list;
    }

    public void setContext(StoreContext ctx, JDBCConfiguration conf) {
        super.setContext(ctx, conf);
        FastPathManagerFactory fpmf = ((WsJpaJDBCConfiguration)conf).getFastPathManagerFactoryInstance();
        if (fpmf != null) {
            this._fpEnabled = true;
        }
    }

    public FetchConfiguration newFetchConfiguration() {
        return new WsJpaJDBCFetchConfigurationImpl();
    }

    private final JDBCFetchConfiguration getAccessIntentFetchConfig(ClassMapping mapping, JDBCFetchConfiguration fetch) {
        return ((WsJpaJDBCConfiguration)this.getConfiguration()).getAccessIntentFetchConfiguration(fetch, mapping.getDescribedType().getName());
    }

    public boolean select(Select sel, ClassMapping mapping, int subs, OpenJPAStateManager sm, BitSet fields, JDBCFetchConfiguration fetch, int eager, boolean ident, boolean outer) {
        if (sm != null && sm.getContext().isActive()) {
            fetch = this.getAccessIntentFetchConfig(mapping, fetch);
        }
        return super.select(sel, mapping, subs, sm, fields, fetch, eager, ident, outer);
    }

    public Object load(ClassMapping mapping, JDBCFetchConfiguration fetch, BitSet exclude, Result result) throws SQLException {
        return super.load(mapping, fetch, exclude, result);
    }

    public boolean load(OpenJPAStateManager sm, BitSet fields, FetchConfiguration fetch, int lockLevel, Object context) {
        if (sm != null && sm.getContext().isActive()) {
            fetch = this.getAccessIntentFetchConfig((ClassMapping)sm.getMetaData(), (JDBCFetchConfiguration)fetch);
        }
        return super.load(sm, fields, fetch, lockLevel, context);
    }

    public boolean initialize(OpenJPAStateManager sm, PCState state, FetchConfiguration fetch, Object context) {
        if (sm != null && sm.getContext().isActive()) {
            fetch = this.getAccessIntentFetchConfig((ClassMapping)sm.getMetaData(), (JDBCFetchConfiguration)fetch);
        }
        return super.initialize(sm, state, fetch, context);
    }

    protected Class getType(Result res, ClassMapping mapping) {
        return super.getType(res, mapping);
    }

    protected JDBCStoreManager.RefCountConnection connectInternal() throws SQLException {
        if (this._fpEnabled) {
            return new PrepareStatementListeningConnection(this.getDataSource().getConnection());
        }
        return super.connectInternal();
    }

    class PrepareStatementListeningConnection
    extends JDBCStoreManager.RefCountConnection {
        public PrepareStatementListeningConnection(Connection conn) {
            super((JDBCStoreManager)WsJpaJDBCStoreManager.this, conn);
        }

        protected Statement createStatement(boolean wrap) throws SQLException {
            return super.createStatement(wrap);
        }

        protected Statement createStatement(int rsType, int rsConcur, boolean wrap) throws SQLException {
            return super.createStatement(rsType, rsConcur, wrap);
        }

        protected PreparedStatement prepareStatement(String str, boolean wrap) throws SQLException {
            PreparedStatement res = super.prepareStatement(str, wrap);
            if (WsJpaJDBCStoreManager.this._listener != null) {
                WsJpaJDBCStoreManager.this._listener.prepareStatement(str, res);
            }
            return res;
        }

        protected PreparedStatement prepareStatement(String str, int rsType, int rsConcur, boolean wrap) throws SQLException {
            PreparedStatement res = super.prepareStatement(str, rsType, rsConcur, wrap);
            if (WsJpaJDBCStoreManager.this._listener != null) {
                WsJpaJDBCStoreManager.this._listener.prepareStatement(str, res);
            }
            return res;
        }
    }
}

