/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.meta.strats;

import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.OpenJPAStateManager;

public abstract class ColumnVersionStrategy
extends org.apache.openjpa.jdbc.meta.strats.ColumnVersionStrategy {
    private static final long serialVersionUID = -1444747401541132000L;
    public static final String ROW_CHANGE_TIMESTAMP = "row-change-timestamp";
    public static final String ROW_CHANGE_LONG = "row-change-long";
    public static final String RID_COL_NAME = "RID";
    public String RIDExpr = null;
    private Column[] verCols = null;
    private boolean setTokenVersionType = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenVersionType(JDBCStore store) throws SQLException {
        if (this.verCols == null) {
            this.getVersionColumns(store.getDBDictionary());
        }
        if (!this.setTokenVersionType && this.verCols != null && this.getAlias().equals(ROW_CHANGE_LONG)) {
            Connection conn = null;
            try {
                conn = store.getConnection();
                Column[] dbCols = null;
                dbCols = store.getDBDictionary().getColumns(conn.getMetaData(), DBIdentifier.newCatalog((String)conn.getCatalog()), this.verCols[0].getSchemaIdentifier(), this.verCols[0].getTableIdentifier(), this.verCols[0].getIdentifier(), conn);
                for (int i = 0; i < dbCols.length; ++i) {
                    if (this.verCols[0].getType() == dbCols[i].getType()) continue;
                    this.verCols[0].setType(dbCols[i].getType());
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        this.setTokenVersionType = true;
    }

    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (!ColumnVersionStrategy.isVersionStrategyColumn((VersionStrategy)this)) {
            this.setTokenVersionType(store);
            Column[] cols = this.vers.getColumns();
            ColumnIO io = this.vers.getColumnIO();
            Object initial = this.nextVersion(null);
            Row row = rm.getRow(this.vers.getClassMapping().getTable(), 1, sm, true);
            for (int i = 0; i < cols.length; ++i) {
                if (!io.isInsertable(i, initial == null)) continue;
                row.setObject(cols[i], initial);
            }
            Object nextVersion = initial;
            sm.setNextVersion(nextVersion);
        }
    }

    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        Object nextVersion = null;
        this.setTokenVersionType(store);
        Column[] cols = this.vers.getColumns();
        if (cols == null || cols.length == 0 || !sm.isDirty() && !sm.isVersionUpdateRequired()) {
            return;
        }
        Object[] curVersion = sm.getVersion();
        if (!ColumnVersionStrategy.isVersionStrategyColumn((VersionStrategy)this)) {
            nextVersion = this.nextVersion(curVersion);
        }
        boolean isMutiVersionColumns = cols.length > 1;
        Row row = null;
        if (!isMutiVersionColumns) {
            row = rm.getRow(this.vers.getClassMapping().getTable(), 0, sm, true);
            row.setFailedObject(sm.getManagedInstance());
        }
        for (int i = 0; i < cols.length; ++i) {
            ForeignKey[] fks;
            if (curVersion != null && sm.isVersionCheckRequired()) {
                Object[] curColVersion = curVersion;
                if (isMutiVersionColumns) {
                    curColVersion = ((Object[])curVersion)[i];
                    row = rm.getRow(cols[i].getTable(), 0, sm, true);
                    row.setFailedObject(sm.getManagedInstance());
                }
                if (cols.length == 1 && ColumnVersionStrategy.isVersionStrategyColumn(cols[0].getVersionStrategy())) {
                    Object rid = ((WsJpaStateManagerImpl)sm).getRid();
                    Object[] verRid = curColVersion;
                    if (rid != null) {
                        verRid = new Object[]{curColVersion, rid};
                    }
                    row.whereObject(cols[i], (Object)verRid);
                } else {
                    row.whereObject(cols[i], (Object)curColVersion);
                }
            }
            if (!this.vers.getColumnIO().isUpdatable(i, nextVersion == null)) continue;
            if (!ColumnVersionStrategy.isVersionStrategyColumn((VersionStrategy)this)) {
                row.setObject(cols[i], nextVersion);
                continue;
            }
            if (row.isValid()) continue;
            boolean isSecondaryColumn = this.isSecondaryColumn(cols[i], sm);
            if (!isMutiVersionColumns || !isSecondaryColumn) {
                row.setPrimaryKey(((ClassMapping)sm.getMetaData()).getColumnIO(), sm);
                continue;
            }
            if (!isSecondaryColumn) continue;
            for (ForeignKey fk : fks = cols[i].getTable().getForeignKeys()) {
                row.whereForeignKey(fk, sm);
                row.setForeignKey(fk, sm);
            }
        }
        if (nextVersion != null) {
            sm.setNextVersion(nextVersion);
        }
    }

    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.setTokenVersionType(store);
        Column[] cols = this.vers.getColumns();
        if (cols.length != 1 || !ColumnVersionStrategy.isVersionStrategyColumn(cols[0].getVersionStrategy())) {
            super.delete(sm, store, rm);
            return;
        }
        Object[] curVersion = sm.getVersion();
        Object rid = ((WsJpaStateManagerImpl)sm).getRid();
        Object[] verRid = curVersion;
        if (rid != null) {
            verRid = new Object[]{curVersion, rid};
        }
        Row row = rm.getRow(cols[0].getTable(), 2, sm, true);
        row.setFailedObject(sm.getManagedInstance());
        if (curVersion != null) {
            row.whereObject(cols[0], (Object)verRid);
            if (this.isSecondaryColumn(cols[0], sm)) {
                ForeignKey[] fks;
                for (ForeignKey fk : fks = cols[0].getTable().getForeignKeys()) {
                    row.whereForeignKey(fk, sm);
                }
            }
        }
    }

    boolean isSecondaryColumn(Column col, OpenJPAStateManager sm) {
        for (ClassMapping mapping = (ClassMapping)sm.getMetaData(); mapping != null; mapping = mapping.getPCSuperclassMapping()) {
            if (mapping.getTable() != col.getTable()) continue;
            return false;
        }
        return true;
    }

    public static boolean isVersionStrategyColumn(VersionStrategy strategy) {
        if (strategy == null) {
            return false;
        }
        return ROW_CHANGE_TIMESTAMP.equals(strategy.getAlias()) || ROW_CHANGE_LONG.equals(strategy.getAlias());
    }

    public Object load(OpenJPAStateManager sm, JDBCStore store, Result res) throws SQLException {
        return this.load(sm, store, res, null);
    }

    public Object load(OpenJPAStateManager sm, JDBCStore store, Result res, Joins joins) throws SQLException {
        this.setTokenVersionType(store);
        Column[] cols = this.getVersionColumns(store.getDBDictionary());
        if (!res.contains(cols[0], joins)) {
            return null;
        }
        Object version = null;
        Object rid = null;
        Object cur = null;
        for (int i = 0; i < cols.length; ++i) {
            cur = res.getObject(cols[i], null, joins);
            if (this.containsRidValue(cols[i])) {
                rid = cur;
                continue;
            }
            version = cur;
        }
        sm.setVersion(version);
        ((WsJpaStateManagerImpl)sm).setRid(rid);
        return version;
    }

    private boolean containsRidValue(Column col) {
        return col.getName().equals(this.RIDExpr);
    }

    public boolean select(Select sel, ClassMapping mapping) {
        DBDictionary dict = sel.getConfiguration().getDBDictionaryInstance();
        sel.select(this.getVersionColumns(dict));
        return true;
    }

    public Column[] getVersionColumns(DBDictionary dict) {
        if (this.verCols == null) {
            Column[] cols = this.vers.getColumns();
            Table tbl = cols[0].getTable();
            if (this.RIDExpr == null) {
                if (dict instanceof DB2Dictionary && ((DB2Dictionary)dict).ridSyntax != null) {
                    this.RIDExpr = dict.getValidColumnName(RID_COL_NAME, tbl);
                    Column rid = new Column(this.RIDExpr, tbl);
                    rid.setJavaType(((DB2Dictionary)dict).getRidSQLType());
                    rid.setVersionStrategy(cols[0].getVersionStrategy());
                    this.verCols = new Column[]{cols[0], rid};
                } else {
                    this.verCols = new Column[]{cols[0]};
                }
            } else {
                this.verCols = new Column[]{cols[0]};
            }
        }
        return this.verCols;
    }
}

