/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.identifier.DBVersionIdentifier;
import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class DB2Dictionary
extends org.apache.openjpa.jdbc.sql.DB2Dictionary {
    private static final Localizer _loc = Localizer.forPackage(DB2Dictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;
    public String ridSyntax = null;
    public int _defaultBatchLimit = 100;

    public DB2Dictionary() {
        super.setBatchLimit(this._defaultBatchLimit);
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.db2ServerType == 3 && this.maj >= 9 || this.db2ServerType == 4 && this.maj >= 9 && this.min >= 5) {
            this.versionColumnTableSyntax = "NOT NULL GENERATED BY DEFAULT FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP";
            this.ridSyntax = "RID";
            if (this.db2ServerType == 4) {
                this.versionColumnTableSyntax = "TIMESTAMP " + this.versionColumnTableSyntax;
                this.ridSyntax = "RID_BIT";
            }
            this.versionColumnTimestampSyntax = "ROW CHANGE TIMESTAMP FOR";
            this.versionColumnIntegerSyntax = "ROW CHANGE TOKEN FOR";
            this.supportsSelectFromFinalTable = true;
        }
    }

    public String getTypeName(Column col) {
        if (!StringUtils.isEmpty((String)col.getTypeName())) {
            return this.appendSize(col, col.getTypeName());
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        if (col.getVersionStrategy() != null && ColumnVersionStrategy.isVersionStrategyColumn(col.getVersionStrategy()) && this.supportsDBVersionStrategy(col)) {
            return this.appendSize(col, this.versionColumnTableSyntax);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if (this.versionColumnTableSyntax != null) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", (Object)col.getVersionStrategy().getAlias(), (Object)col.getFullName(), (Object)this.platform));
    }

    public DBVersionIdentifier getVersionColumn(Column column, DBIdentifier tableAlias) {
        return this.getVersionColumn(column, tableAlias, true);
    }

    public DBVersionIdentifier getVersionColumn(Column column, DBIdentifier tableAlias, boolean where) {
        String columnName = this.getVersionColumn(column, tableAlias.getName(), where);
        return new DBVersionIdentifier(columnName, DBIdentifier.DBIdentifierType.CONSTANT);
    }

    public String getVersionColumn(Column column, String tableAlias, boolean where) {
        StringBuffer versionColumn = new StringBuffer();
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy())) {
            if (this.versionColumnIntegerSyntax != null && "row-change-long".equals(column.getVersionStrategy().getAlias()) && column.getType() == 93) {
                versionColumn.append(this.versionColumnIntegerSyntax).append(" ").append(this.getTableDesignator(column, tableAlias));
            } else {
                if (!where) {
                    versionColumn.append(tableAlias).append(".");
                }
                versionColumn.append(column.toString());
            }
            if (where && this.ridSyntax != null) {
                versionColumn.append("= ? AND ").append(this.getRIDExpr(this.getTableDesignator(column, tableAlias)));
            }
        } else {
            if (!where) {
                versionColumn.append(tableAlias).append(".");
            }
            versionColumn.append(column.toString());
        }
        return versionColumn.toString();
    }

    private String getTableDesignator(Column column, String tableName) {
        if (column.getTableIdentifier().toString().equals(tableName) && column.getSchemaIdentifier().getName() != null) {
            tableName = column.getSchemaIdentifier().getName() + "." + tableName;
        }
        return tableName;
    }

    public String getRIDExpr(String table) {
        if (this.ridSyntax == null) {
            return "";
        }
        return this.ridSyntax + "(" + table + ")";
    }

    public void setTypedForRIDExpr(PreparedStatement stmnt, int idx, Object val, int type) throws SQLException {
        switch (type) {
            case 1: {
                stmnt.setBytes(idx, (byte[])val);
                break;
            }
            case 6: {
                this.setLong(stmnt, idx, ((Number)val).longValue(), null);
                break;
            }
        }
    }

    public boolean verifyProductVersion(String productName, String productVersion) {
        return productName.equalsIgnoreCase(this.databaseProductName) && productVersion.equalsIgnoreCase(this.databaseProductVersion);
    }

    public boolean validateDBSpecificBatchProcess(boolean disableBatch, RowImpl row, Column[] autoAssign, OpenJPAStateManager sm, ClassMapping cmd) {
        VersionStrategy strategy;
        boolean rtnValue = disableBatch;
        if (!disableBatch && sm != null && (strategy = cmd.getVersion().getStrategy()) != null && ColumnVersionStrategy.isVersionStrategyColumn(strategy)) {
            rtnValue = true;
        }
        return rtnValue;
    }

    public void setDefaultBatchLimit(int limit) {
        super.setBatchLimit(limit);
    }

    public String getProductName() {
        return this.databaseProductName;
    }

    public String getProductVersion() {
        return this.databaseProductVersion;
    }

    public void setTyped(PreparedStatement stmnt, int idx, Object val, Column col, int type, JDBCStore store) throws SQLException {
        VersionStrategy verStrat = col.getVersionStrategy();
        if (ColumnVersionStrategy.isVersionStrategyColumn(verStrat) && val != null && val instanceof Object[]) {
            Object verVal = ((Object[])val)[0];
            super.setTyped(stmnt, idx, verVal, col, type, store);
            Object ridVal = ((Object[])val)[1];
            int ridType = this.setRIDExprVal(ridVal);
            this.setTypedForRIDExpr(stmnt, ++idx, ridVal, ridType);
            return;
        }
        super.setTyped(stmnt, idx, val, col, type, store);
    }

    public int setRIDExprVal(Object obj) {
        if (obj instanceof Long) {
            return 6;
        }
        return 1;
    }

    public int getRidSQLType() {
        if (this.db2ServerType == 4) {
            return 1004;
        }
        return 6;
    }
}

