/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class OracleDictionary
extends org.apache.openjpa.jdbc.sql.OracleDictionary {
    private static final Localizer _loc = Localizer.forPackage(OracleDictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;
    public boolean checkVersionStrategy = false;
    public int _defaultBatchLimit = 100;

    public OracleDictionary() {
        super.setBatchLimit(this._defaultBatchLimit);
    }

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
    }

    public String[] getCreateTableSQL(Table table) {
        String[] create = super.getCreateTableSQL(table);
        if (this.versionColumnTableSyntax != null) {
            create[0] = create[0].concat(this.versionColumnTableSyntax);
        }
        if (!this.useTriggersForAutoAssign) {
            return create;
        }
        Column[] cols = table.getColumns();
        ArrayList<String> seqs = null;
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String seq;
            if (!cols[i].isAutoAssigned()) continue;
            if (seqs == null) {
                seqs = new ArrayList<String>(4);
            }
            if ((seq = this.autoAssignSequenceName) == null) {
                seq = this.openjpa3GeneratedKeyNames ? super.getOpenJPA3GeneratedKeySequenceName(cols[i]) : this.getGeneratedKeySequenceName(cols[i]);
                seqs.add("CREATE SEQUENCE " + seq + " START WITH 1");
            }
            String trig = this.openjpa3GeneratedKeyNames ? super.getOpenJPA3GeneratedKeyTriggerName(cols[i]) : this.getGeneratedKeyTriggerName(cols[i]);
            seqs.add("CREATE OR REPLACE TRIGGER " + trig + " BEFORE INSERT ON " + table.getName() + " FOR EACH ROW BEGIN SELECT " + seq + ".nextval INTO " + ":new." + cols[i].getName() + " FROM DUAL; " + "END " + trig + ";");
        }
        if (seqs == null) {
            return create;
        }
        String[] sql = new String[create.length + seqs.size()];
        System.arraycopy(create, 0, sql, 0, create.length);
        for (int i = 0; i < seqs.size(); ++i) {
            sql[create.length + i] = (String)seqs.get(i);
        }
        return sql;
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if (this.versionColumnTableSyntax != null) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", (Object)col.getVersionStrategy().getAlias(), (Object)col.getFullName(), (Object)this.platform));
    }

    public String getVersionColumn(Column column, String tableAlias) {
        StringBuffer versionColumn = new StringBuffer();
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy()) && this.versionColumnTableSyntax != null) {
            if ("row-change-timestamp".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnTimestampSyntax).append(tableAlias).append(".").append(this.versionColumnIntegerSyntax).append(")").toString();
            }
            if ("row-change-long".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(tableAlias).append(".").append(this.versionColumnIntegerSyntax).toString();
            }
        }
        return versionColumn.append(tableAlias).append(".").append(column.getName()).toString();
    }

    public void setDefaultBatchLimit(int limit) {
        super.setBatchLimit(limit);
    }
}

