/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class SQLServerDictionary
extends org.apache.openjpa.jdbc.sql.SQLServerDictionary {
    private static final Localizer _loc = Localizer.forPackage(SQLServerDictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        this.versionColumnTableSyntax = "rowversion";
        this.versionColumnIntegerSyntax = "CAST(";
    }

    public String getTypeName(Column col) {
        if (!StringUtils.isEmpty((String)col.getTypeName())) {
            return this.appendSize(col, col.getTypeName());
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        if (col.getVersionStrategy() != null && ColumnVersionStrategy.isVersionStrategyColumn(col.getVersionStrategy()) && this.supportsDBVersionStrategy(col)) {
            return this.appendSize(col, this.versionColumnTableSyntax);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if ("row-change-long".equals(col.getVersionStrategy().getAlias())) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", (Object)col.getVersionStrategy().getAlias(), (Object)col.getFullName(), (Object)this.platform));
    }

    public String getVersionColumn(Column column, String tableAlias) {
        StringBuffer versionColumn = new StringBuffer();
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy()) && this.versionColumnTableSyntax != null && this.supportsDBVersionStrategy(column)) {
            versionColumn.append(this.versionColumnIntegerSyntax).append(tableAlias).append(".").append(column.getName()).append(" AS bigint)");
            return versionColumn.toString();
        }
        return versionColumn.append(tableAlias).append(".").append(column.getName()).toString();
    }
}

