/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SelectImpl;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.kernel.exps.Value;

public class SelectImpl
extends org.apache.openjpa.jdbc.sql.SelectImpl {
    public SelectImpl(JDBCConfiguration conf) {
        super(conf);
    }

    public List getSelectAliases() {
        return this._selects.getAliases(false, this._outer != null);
    }

    public List getIdentifierAliases() {
        return this._selects.getAliases(true, this._outer != null);
    }

    protected Result execute(StoreContext ctx, JDBCStore store, JDBCFetchConfiguration fetch, int lockLevel) throws SQLException {
        List selects = this.getSelects();
        for (Object obj : selects) {
            VersionStrategy verStrat;
            if (!(obj instanceof Column) || (verStrat = ((Column)obj).getVersionStrategy()) == null || !verStrat.getAlias().equals("row-change-long")) continue;
            ((ColumnVersionStrategy)verStrat).setTokenVersionType(store);
        }
        return super.execute(ctx, store, fetch, lockLevel);
    }

    protected Selects newSelects() {
        return new Selects();
    }

    public int select(Column[] cols, Joins joins) {
        for (int i = 0; i < cols.length; ++i) {
            String alias = this.getColumnAlias(cols[i], joins);
            ((Selects)this._selects).setAliasColumns(alias, cols[i]);
        }
        return super.select(cols, joins);
    }

    private static class Selects
    extends SelectImpl.Selects {
        private Map<Object, Column> _aliasColumn = new HashMap<Object, Column>();

        private Selects() {
        }

        public void setAliasColumns(Object alias, Column col) {
            this._aliasColumn.put(alias, col);
        }

        public List getAliases(final boolean ident, final boolean inner) {
            if (this._ids == null) {
                return Collections.EMPTY_LIST;
            }
            return new AbstractList(){

                @Override
                public int size() {
                    return ident && Selects.this._idents != null ? Selects.this._idents.size() : Selects.this._ids.size();
                }

                private boolean isRid(Column col) {
                    VersionStrategy strat = col.getVersionStrategy();
                    if (!(strat instanceof ColumnVersionStrategy)) {
                        return false;
                    }
                    return ColumnVersionStrategy.isVersionStrategyColumn(strat) && col.getName().equals(((ColumnVersionStrategy)strat).RIDExpr);
                }

                private boolean isRowChangeTokenStrategyColumn(Column col) {
                    VersionStrategy strat = col.getVersionStrategy();
                    if (!(strat instanceof ColumnVersionStrategy)) {
                        return false;
                    }
                    return "row-change-long".equals(strat.getAlias());
                }

                private Object getRid(String alias) {
                    return ((DB2Dictionary)Selects.this._dict).getRIDExpr(alias.split("\\.", 0)[0]);
                }

                private Object getRowChangeSyntax(Column col, String alias) {
                    return ((DB2Dictionary)Selects.this._dict).getVersionColumn(col, alias.split("\\.", 0)[0], false);
                }

                @Override
                public Object get(int i) {
                    Object id = ident && Selects.this._idents != null ? Selects.this._idents.get(i) : Selects.this._ids.get(i);
                    Object alias = Selects.this._aliases.get(id);
                    Column col = (Column)Selects.this._aliasColumn.get(alias);
                    if (col != null && Selects.this._dict instanceof DB2Dictionary) {
                        if (this.isRid(col)) {
                            return this.getRid((String)alias);
                        }
                        if (this.isRowChangeTokenStrategyColumn(col) && col.getType() == 93) {
                            return this.getRowChangeSyntax(col, (String)alias);
                        }
                    }
                    if (id instanceof Column) {
                        Column idCol = (Column)id;
                        VersionStrategy strat = idCol.getVersionStrategy();
                        if (this.isRid(idCol)) {
                            return this.getRid((String)alias);
                        }
                        if (ColumnVersionStrategy.isVersionStrategyColumn(strat) && Selects.this._dict instanceof DB2Dictionary) {
                            alias = this.getRowChangeSyntax(idCol, (String)alias);
                        } else if (idCol.isXML()) {
                            alias = alias + ((Selects)Selects.this)._dict.getStringVal;
                        }
                    }
                    String as = null;
                    if (inner) {
                        if (alias instanceof String) {
                            as = ((String)alias).replace('.', '_');
                        }
                    } else if (Selects.this._selectAs != null) {
                        as = (String)Selects.this._selectAs.get(id);
                    } else if (id instanceof Value) {
                        as = ((Value)id).getAlias();
                    }
                    if (as != null) {
                        if (ident && Selects.this._idents != null) {
                            return as;
                        }
                        alias = alias instanceof SQLBuffer ? new SQLBuffer((SQLBuffer)alias).append(" AS ").append(as) : alias + " AS " + as;
                    }
                    return alias;
                }
            };
        }
    }
}

