/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.kernel;

import com.ibm.ws.persistence.fastpath.FastPathManager;
import com.ibm.ws.persistence.fastpath.FastPathManagerFactory;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import com.ibm.ws.persistence.objectcache.ObjectCache;
import com.ibm.ws.persistence.objectcache.ObjectCacheManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.FindCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAId;

public class WsJpaBrokerImpl
extends BrokerImpl {
    private static final long serialVersionUID = 2491212973382881349L;
    private transient ObjectCache _oc;
    private transient FastPathManager _fpMgr;
    public boolean checkCacheForLazyFields = false;
    private transient Boolean _usePDQOptimization = null;

    protected Collection getTransactionalStates() {
        Collection col = super.getTransactionalStates();
        if (this.usePDQOpt().equals(Boolean.FALSE)) {
            return col;
        }
        for (StateManagerImpl s : col) {
            boolean isDirty;
            int i;
            if (!this.isUpdate(s)) continue;
            BitSet dirty = s.getDirty();
            ClassMetaData meta = s.getMetaData();
            int size = meta.getFields().length;
            boolean updateAllEager = false;
            ArrayList<Integer> toUpdateFields = new ArrayList<Integer>();
            HashMap dirtyTables = new HashMap();
            for (i = 0; i < size; ++i) {
                isDirty = dirty.get(i);
                if (!isDirty) continue;
                FieldMapping fm = (FieldMapping)meta.getField(i);
                ValueMapping val = (ValueMapping)fm.getValue();
                Column[] cols = val.getColumns();
                this.getDirtyTables(dirtyTables, cols);
            }
            for (i = 0; i < size; ++i) {
                isDirty = dirty.get(i);
                FieldMetaData fmd = meta.getField(i);
                boolean isEager = fmd.isInDefaultFetchGroup();
                if (isDirty && isEager) {
                    updateAllEager = true;
                    continue;
                }
                if (!isEager || fmd.isPrimaryKey() || fmd.isVersion() || !this.isInDirtyTable(fmd, dirtyTables)) continue;
                toUpdateFields.add(fmd.getIndex());
            }
            if (!updateAllEager) continue;
            for (i = 0; i < toUpdateFields.size(); ++i) {
                int idx = (Integer)toUpdateFields.get(i);
                s.dirty(idx);
                Object val = s.fetchField(idx, false);
                s.storeField(idx, val);
            }
        }
        return col;
    }

    private void getDirtyTables(Map dirtyTables, Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            Table tbl = cols[i].getTable();
            dirtyTables.put(tbl, tbl);
        }
    }

    private boolean isInDirtyTable(FieldMetaData fm, Map tablesInvolved) {
        ValueMapping val = (ValueMapping)fm.getValue();
        Column[] cols = val.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            Table tbl = cols[i].getTable();
            if (tablesInvolved.get(tbl) == null) continue;
            return true;
        }
        return false;
    }

    private boolean isUpdate(StateManagerImpl sm) {
        if (sm.getPCState() == PCState.PNEW && !sm.isFlushed()) {
            return false;
        }
        if (sm.getPCState() == PCState.PNEWFLUSHEDDELETED || sm.getPCState() == PCState.PDELETED) {
            return false;
        }
        return ImplHelper.getUpdateFields((OpenJPAStateManager)sm) != null;
    }

    public StateManagerImpl newStateManagerImpl(Object oid, ClassMetaData meta) {
        return new WsJpaStateManagerImpl(oid, meta, this, this._fpMgr);
    }

    public boolean isPDQUpdateManager(String updateManager) {
        return updateManager.indexOf("com.ibm.ws.persistence.pdq") != -1 && (updateManager.indexOf("PDQConstraintUpdateManager") != -1 || updateManager.indexOf("StaticOperationOrderUpdateManager") != -1 || updateManager.indexOf("StaticConstraintUpdateManager") != -1);
    }

    public Object find(Object oid, FetchConfiguration fetch, BitSet exclude, Object edata, int flags) {
        Object res = null;
        if (this._oc == null) {
            return super.find(oid, fetch, exclude, edata, flags);
        }
        res = this._oc.find(oid);
        if (res != null) {
            return res;
        }
        res = super.find(oid, fetch, exclude, edata, flags);
        this.objectCacheStore(res);
        return res;
    }

    public Object find(Object oid, boolean validate, FindCallbacks call) {
        Object res = null;
        if (oid instanceof OpenJPAId && this._fpMgr != null && this._fpMgr.isFastPathEligibleAndNotCurrentlyGenerating(((OpenJPAId)oid).getType())) {
            OpenJPAId ojid = (OpenJPAId)oid;
            res = this.findCached(oid, call);
            if (res != null) {
                return res;
            }
            res = this._fpMgr.find(ojid, validate, call);
            if (this._oc != null && res != null) {
                this.objectCacheStore(res);
            }
            return res;
        }
        if (this._oc == null) {
            return super.find(oid, validate, call);
        }
        res = this._oc.find(oid);
        if (res != null) {
            return res;
        }
        res = super.find(oid, validate, call);
        this.objectCacheStore(res);
        return res;
    }

    public Object[] findAll(Collection oids, boolean validate, FindCallbacks call) {
        if (this._oc == null) {
            return super.findAll(oids, validate, call);
        }
        ArrayList<Object> found = new ArrayList<Object>();
        ArrayList missing = new ArrayList();
        for (Object oid : oids) {
            Object o = this._oc.find(call.processArgument(oid));
            if (o != null) {
                found.add(o);
                continue;
            }
            missing.add(oid);
        }
        if (missing.size() > 0) {
            Object[] res = super.findAll(missing, validate, call);
            if (res != null) {
                for (Object o : res) {
                    this.objectCacheStore(o);
                }
            }
            found.addAll(Arrays.asList(res));
        }
        return found.toArray();
    }

    protected StateManagerImpl initialize(StateManagerImpl sm, boolean load, FetchConfiguration fc, Object edata) {
        StateManagerImpl smi = super.initialize(sm, load, fc, edata);
        if (!this.checkCacheForLazyFields || smi == null) {
            return smi;
        }
        this.checkCacheForLazyFields(sm);
        return smi;
    }

    public void checkCacheForLazyFields(StateManagerImpl smi) {
        Object[] intermediates = ((WsJpaStateManagerImpl)smi).getIntermediateFieldData();
        if (intermediates != null && intermediates.length > 0) {
            int count = 0;
            ClassMetaData cmd = smi.getMetaData();
            for (FieldMetaData fmd : cmd.getFields()) {
                int index = fmd.getIndex();
                int extraFieldIndex = cmd.getExtraFieldDataIndex(index);
                if (extraFieldIndex < 0) continue;
                Object oid = intermediates[extraFieldIndex];
                if (oid != null) {
                    Object cached;
                    Object object = cached = oid != null ? this.findCached(oid, null) : null;
                    if (cached != null) {
                        smi.store(index, cached);
                    }
                }
                if (count++ == intermediates.length) break;
            }
        }
    }

    public void initialize(AbstractBrokerFactory factory, DelegatingStoreManager sm, boolean managed, int connMode, boolean fromDeserialization) {
        super.initialize(factory, sm, managed, connMode, fromDeserialization);
        OpenJPAConfiguration conf = factory.getConfiguration();
        if (conf instanceof WsJpaJDBCConfiguration) {
            FastPathManagerFactory fpm;
            ObjectCacheManager ocm = ((WsJpaJDBCConfiguration)conf).getObjectCacheManagerInstance((BrokerFactory)factory);
            if (ocm != null) {
                this._oc = ocm.getCache();
            }
            if ((fpm = ((WsJpaJDBCConfiguration)conf).getFastPathManagerFactoryInstance()) != null) {
                this._fpMgr = fpm.createFastManagerInstance(this);
            }
        }
    }

    public void initialize(AbstractBrokerFactory factory, DelegatingStoreManager sm, boolean managed, int connMode, boolean fromDeserialization, boolean fromWriteBehindCallback) {
        super.initialize(factory, sm, managed, connMode, fromDeserialization, fromWriteBehindCallback);
        OpenJPAConfiguration conf = factory.getConfiguration();
        if (conf instanceof WsJpaJDBCConfiguration) {
            FastPathManagerFactory fpm;
            ObjectCacheManager ocm = ((WsJpaJDBCConfiguration)conf).getObjectCacheManagerInstance((BrokerFactory)factory);
            if (ocm != null) {
                this._oc = ocm.getCache();
            }
            if ((fpm = ((WsJpaJDBCConfiguration)conf).getFastPathManagerFactoryInstance()) != null) {
                this._fpMgr = fpm.createFastManagerInstance(this);
            }
        }
    }

    public boolean isCached(List<Object> oids) {
        if (this._oc != null && this._oc.containsAll(oids)) {
            return true;
        }
        return super.isCached(oids);
    }

    private boolean objectCacheStore(Object object) {
        if (this._oc != null && object != null) {
            PersistenceCapable pc = (PersistenceCapable)object;
            this._oc.store((OpenJPAStateManager)pc.pcGetStateManager());
            return true;
        }
        return false;
    }

    public Object findCached(Object oid, FindCallbacks call, boolean checkObjectCache) {
        Object res;
        if (checkObjectCache && this._oc != null && (res = this._oc.find(oid)) != null) {
            return res;
        }
        return super.findCached(oid, call);
    }

    public Object findCached(Object oid, FindCallbacks call) {
        return this.findCached(oid, call, true);
    }

    public ObjectCache getObjectCache() {
        return this._oc;
    }

    public void setObjectCache(ObjectCache oc) {
        this._oc = oc;
        if (oc == null) {
            BrokerFactory factory = this.getBrokerFactory();
            this.getLifecycleEventManager().removeListener((Object)((WsJpaJDBCConfiguration)factory.getConfiguration()).getObjectCacheManagerInstance(factory));
        }
    }

    public FastPathManager getFastPathManager() {
        return this._fpMgr;
    }

    public void setFastPathManager(FastPathManager fpm) {
        this._fpMgr = fpm;
    }

    public boolean getCheckCacheForLazyFields() {
        return this.checkCacheForLazyFields;
    }

    private Boolean usePDQOpt() {
        if (this._usePDQOptimization == null) {
            if (this.getConfiguration() instanceof JDBCConfigurationImpl) {
                JDBCConfiguration conf = (JDBCConfiguration)this.getConfiguration();
                String updateManager = conf.getUpdateManager();
                String dict = conf.getDBDictionary();
                this._usePDQOptimization = this.isPDQUpdateManager(updateManager) && !dict.contains("informix") ? Boolean.TRUE : Boolean.FALSE;
            } else {
                this._usePDQOptimization = Boolean.FALSE;
            }
        }
        return this._usePDQOptimization;
    }
}

