/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.kernel.conf;

import com.ibm.websphere.persistence.WsJpaTaskNameManager;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.naming.InitialContext;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaTaskNameManagerImpl
implements WsJpaTaskNameManager {
    private static final Localizer _loc = Localizer.forPackage(WsJpaTaskNameManagerImpl.class);
    private WsJpaJDBCConfiguration config = null;
    private static TaskState state = TaskState.Uninitialized;
    private static Object uowSyncRegistry = null;
    private static Method getResourceMethod = null;
    private static Method putResourceMethod = null;

    public WsJpaTaskNameManagerImpl() {
    }

    public WsJpaTaskNameManagerImpl(WsJpaJDBCConfiguration configuration) {
        this.config = configuration;
    }

    private Log getLog() {
        Log rtnLog = null;
        if (this.config != null) {
            rtnLog = this.config.getLog("openjpa.Runtime");
        }
        return rtnLog;
    }

    private final boolean isUowSRAvailable() {
        if (state == TaskState.Uninitialized) {
            Log log = this.getLog();
            try {
                InitialContext ic = new InitialContext();
                uowSyncRegistry = ic.lookup("java:comp/websphere/UOWSynchronizationRegistry");
                Class<?> uowSr = Class.forName("com.ibm.websphere.uow.UOWSynchronizationRegistry");
                getResourceMethod = uowSr.getMethod("getResource", Object.class);
                AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)getResourceMethod, (boolean)true));
                putResourceMethod = uowSr.getMethod("putResource", Object.class, Object.class);
                AccessController.doPrivileged(J2DoPrivHelper.setAccessibleAction((AccessibleObject)putResourceMethod, (boolean)true));
                if (log != null && log.isInfoEnabled()) {
                    log.info((Object)_loc.get("access-intent-task-initialzed"));
                }
                state = TaskState.Available;
            }
            catch (Throwable e) {
                if (log != null && log.isTraceEnabled()) {
                    log.trace((Object)_loc.get("unable-to-obtain-uow-sync-registry", (Object)e.getMessage()));
                }
                state = TaskState.Unavailable;
            }
        }
        return state == TaskState.Available;
    }

    @Override
    public String getTSRTaskName() {
        String taskName;
        block5: {
            taskName = null;
            if (this.isUowSRAvailable()) {
                Log log = this.getLog();
                try {
                    Object taskObject = getResourceMethod.invoke(uowSyncRegistry, "com.ibm.websphere.profile");
                    if (taskObject instanceof String) {
                        taskName = (String)taskObject;
                        if (log != null && log.isTraceEnabled()) {
                            log.trace((Object)_loc.get("get-taskname", (Object)taskName));
                        }
                    }
                }
                catch (Throwable e) {
                    if (log == null || !log.isTraceEnabled()) break block5;
                    log.trace((Object)_loc.get("cant-get-taskname"));
                }
            }
        }
        return taskName;
    }

    @Override
    public boolean setTSRTaskName(String taskName) {
        boolean rtnValue;
        block4: {
            rtnValue = false;
            if (this.isUowSRAvailable()) {
                Log log = this.getLog();
                try {
                    putResourceMethod.invoke(uowSyncRegistry, "com.ibm.websphere.profile", taskName);
                    if (log != null && log.isTraceEnabled()) {
                        log.trace((Object)_loc.get("put-taskname", (Object)taskName));
                    }
                    rtnValue = true;
                }
                catch (Throwable e) {
                    if (log == null || !log.isTraceEnabled()) break block4;
                    log.trace((Object)_loc.get("cant-put-taskname", (Object)taskName));
                }
            }
        }
        return rtnValue;
    }

    private static enum TaskState {
        Uninitialized,
        Available,
        Unavailable;

    }
}

