/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.kernel.conf;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.openjpa.lib.util.Localizer;

public class WsJpaTasksFactory {
    private static Localizer _loc;
    static final Object[][] IsolationValues;
    static final Object[][] readLockValues;
    private String tasksValue;
    private String tasksValueLC;
    private int maxIndex;
    private int start;
    private int end;
    private ListOrderedMap tasksList = new ListOrderedMap();

    public String getTasks() {
        return this.tasksValue;
    }

    public void setTasks(String tasks) {
        this.tasksValue = this.removeWhiteSpaces(tasks);
        this.tasksValueLC = this.tasksValue.toLowerCase(Locale.ENGLISH);
        this.start = 0;
        this.end = 0;
        this.maxIndex = this.tasksValue.length();
        try {
            this.parse();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(_loc.get("incorrect-tasks-syntax", (Object)e.getMessage()).getMessage());
        }
    }

    public IsolationLockValue getTasksEntities(String tasksName, String entityClassName) {
        for (Pattern taskRE : this.tasksList.keySet()) {
            if (!taskRE.matcher(tasksName).matches()) continue;
            OrderedMap entitiesList = (OrderedMap)this.tasksList.get((Object)taskRE);
            for (Pattern entityRE : entitiesList.keySet()) {
                if (!entityRE.matcher(entityClassName).matches()) continue;
                return (IsolationLockValue)entitiesList.get((Object)entityRE);
            }
        }
        return null;
    }

    private final String removeWhiteSpaces(String str) {
        StringBuilder strb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char thisChar = str.charAt(i);
            if (Character.isWhitespace(thisChar)) continue;
            strb.append(thisChar);
        }
        return strb.toString();
    }

    private final void skipSpaces() {
        while (this.start < this.maxIndex && Character.isSpaceChar(this.tasksValue.charAt(this.start))) {
            ++this.start;
        }
        this.end = this.start;
    }

    private final boolean more() {
        return this.end < this.maxIndex;
    }

    private boolean getCharToken(char token, boolean optional) throws Exception {
        boolean tokenFound = false;
        if (this.more() && this.tasksValue.charAt(this.start) == token) {
            this.end = ++this.start;
            tokenFound = true;
        } else if (!optional) {
            throw new Exception(_loc.get("char-token-expected", (Object)Character.valueOf(token), (Object)this.start, (Object)this.addErrorPoint(this.start)).getMessage());
        }
        return tokenFound;
    }

    private void parse() throws Exception {
        boolean expectingTaskName = true;
        while (expectingTaskName && this.getTask()) {
            this.skipSpaces();
            expectingTaskName = this.getCharToken(',', true);
        }
        if (this.more()) {
            throw new Exception(_loc.get("comma-taskname-expected", (Object)this.start, (Object)this.addErrorPoint(this.start)).getMessage());
        }
    }

    private boolean getTask() throws Exception {
        this.skipSpaces();
        String taskName = this.getFullyPackageQualiferName("<taskName>", true);
        if (taskName != null) {
            String entityName;
            this.skipSpaces();
            this.getCharToken('{', false);
            this.skipSpaces();
            ListOrderedMap entities = new ListOrderedMap();
            boolean expectingTaskName = true;
            while (expectingTaskName && (entityName = this.getFullyPackageQualiferName("<entity>", false)) != null) {
                this.skipSpaces();
                this.getCharToken('(', false);
                this.skipSpaces();
                IsolationLockValue value = this.getIsolationLockValues();
                entities.put((Object)Pattern.compile(this.convertToRegEx(entityName)), (Object)value);
                this.skipSpaces();
                this.getCharToken(')', false);
                this.skipSpaces();
                expectingTaskName = this.getCharToken(',', true);
            }
            this.skipSpaces();
            this.getCharToken('}', false);
            this.tasksList.put((Object)Pattern.compile(this.convertToRegEx(taskName)), (Object)entities);
        }
        return taskName != null;
    }

    private final String convertToRegEx(String name) {
        String rtnStr = '^' + name.replaceAll("\\.", "\\\\.").replaceAll("\\?", ".").replaceAll("\\*", ".*") + '$';
        return rtnStr;
    }

    private String getFullyPackageQualiferName(String type, boolean optional) throws Exception {
        String nameReturned = null;
        this.skipSpaces();
        int nameStart = this.start;
        if (this.getWildCardIdentifier(type, optional) != null) {
            while (this.getCharToken('.', true)) {
                this.getWildCardIdentifier(type, false);
            }
            nameReturned = this.tasksValue.substring(nameStart, this.end);
        }
        return nameReturned;
    }

    private String getWildCardIdentifier(String type, boolean optional) throws Exception {
        String idReturned = null;
        this.end = this.start;
        if (this.more() && (Character.isJavaIdentifierStart(this.tasksValue.charAt(this.end)) || this.isWildCardChar())) {
            ++this.end;
            while (this.more() && (Character.isJavaIdentifierPart(this.tasksValue.charAt(this.end)) || this.isWildCardChar())) {
                ++this.end;
            }
            idReturned = this.tasksValue.substring(this.start, this.end);
            this.start = this.end;
        } else if (!optional) {
            throw new Exception(_loc.get("id-expected", (Object)type, (Object)this.start, (Object)this.addErrorPoint(this.start)).getMessage());
        }
        return idReturned;
    }

    private final boolean isWildCardChar() {
        char next = this.tasksValue.charAt(this.end);
        return next == '?' || next == '*';
    }

    private IsolationLockValue getIsolationLockValues() throws Exception {
        this.skipSpaces();
        int valueStart = this.start;
        int readLock = this.getNameValue("readlock", readLockValues, true);
        int isolationLevel = -1;
        if (readLock != -1) {
            this.skipSpaces();
            if (this.getCharToken(',', true)) {
                isolationLevel = this.getNameValue("isolation", IsolationValues, false);
            }
        } else {
            isolationLevel = this.getNameValue("isolation", IsolationValues, false);
            this.skipSpaces();
            if (this.getCharToken(',', true)) {
                readLock = this.getNameValue("readlock", readLockValues, false);
            }
        }
        if (readLock == 20 && isolationLevel != -1 && isolationLevel != 4 && isolationLevel != 8) {
            throw new Exception(_loc.get("conflicting-isolation-readlock", (Object)valueStart, (Object)this.addErrorPoint(this.start)).getMessage());
        }
        return new IsolationLockValue(isolationLevel, readLock);
    }

    private int getNameValue(String name, Object[][] values, boolean optional) throws Exception {
        int value = -1;
        this.skipSpaces();
        if (this.tasksValueLC.startsWith(name, this.start)) {
            this.start += name.length();
            this.end = this.start;
            this.skipSpaces();
            this.getCharToken('=', false);
            this.skipSpaces();
            for (int i = 0; i < values.length - 1; ++i) {
                String matching = (String)values[i][0];
                if (!this.tasksValueLC.startsWith(matching, this.start)) continue;
                this.start += matching.length();
                this.end = this.start;
                value = (Integer)values[i][1];
                break;
            }
            if (value == -1 && !optional) {
                throw new Exception(_loc.get("no-match-found", new Object[]{values[values.length - 1][0], name, this.start, this.addErrorPoint(this.start)}).getMessage());
            }
        } else if (!optional) {
            throw new Exception(_loc.get("isolation-readlock-expected", (Object)this.start, (Object)this.addErrorPoint(this.start)).getMessage());
        }
        return value;
    }

    private String addErrorPoint(int index) {
        return this.tasksValue.substring(0, index) + "^Error^" + this.tasksValue.substring(index);
    }

    public String toString() {
        return "{Tasks='" + this.tasksValue + "'}=\n{" + this.tasksList + '}';
    }

    static {
        int j;
        _loc = Localizer.forPackage(WsJpaTasksFactory.class);
        IsolationValues = new Object[][]{{"read-uncommitted", 1}, {"read-committed", 2}, {"repeatable-read", 4}, {"serializable", 8}, {"reserved", Integer.MAX_VALUE}};
        readLockValues = new Object[][]{{"read", 10}, {"write", 20}, {"reserved", Integer.MAX_VALUE}};
        String valueSeparator = " or ";
        int last = IsolationValues.length - 1;
        StringBuilder expecting = new StringBuilder();
        for (j = 0; j < last; ++j) {
            expecting.append(valueSeparator).append("'").append((String)IsolationValues[j][0]).append("'");
        }
        WsJpaTasksFactory.IsolationValues[last][0] = expecting.substring(valueSeparator.length());
        last = readLockValues.length - 1;
        expecting = new StringBuilder();
        for (j = 0; j < last; ++j) {
            expecting.append(valueSeparator).append("'").append((String)readLockValues[j][0]).append("'");
        }
        WsJpaTasksFactory.readLockValues[last][0] = expecting.substring(valueSeparator.length());
    }

    public class IsolationLockValue {
        int isolationLevel;
        int readLock;

        IsolationLockValue(int isolation, int lock) {
            this.isolationLevel = isolation;
            this.readLock = lock;
        }

        private String toValueString(int value, Object[][] values) {
            String rtnVal = "";
            for (Object[] entry : values) {
                if (value != (Integer)entry[1]) continue;
                rtnVal = (String)entry[0];
                break;
            }
            return rtnVal;
        }

        public String toString() {
            return "{isolation=" + this.toValueString(this.isolationLevel, IsolationValues) + ":readLock=" + this.toValueString(this.readLock, readLockValues) + '}';
        }

        public int getIsolationLevel() {
            return this.isolationLevel;
        }

        public int getReadLock() {
            return this.readLock;
        }
    }
}

