/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.objectcache;

import com.ibm.ws.persistence.jdbc.kernel.ReadOnlyDetachedStateManager;
import com.ibm.ws.persistence.objectcache.ObjectCache;
import com.ibm.ws.persistence.objectcache.ReadOnlyQueryResultsCache;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.CacheMap;
import org.apache.openjpa.util.OpenJPAId;

public class ObjectCacheImpl
implements ObjectCache {
    private static final Localizer _loc = Localizer.forPackage(ObjectCacheImpl.class);
    private Set<String> _types;
    private Map<ClassMetaData, Boolean> _cacheable = new ConcurrentHashMap<ClassMetaData, Boolean>();
    private CacheMap _cache;
    private Configuration _conf = null;
    private int _cacheSize;
    private boolean _autoSize = false;
    private ReadOnlyQueryResultsCache _qc;

    public ObjectCacheImpl(Set<String> types, int cacheSize, Configuration conf, boolean auto, ReadOnlyQueryResultsCache qc) {
        this._types = types;
        this._cache = new CacheMap(false, auto ? -1 : cacheSize, 500, 0.75f, 16){

            protected void cacheMapOverflowRemoved(Object key, Object value) {
                ObjectCacheImpl.this.clearQc();
                super.cacheMapOverflowRemoved(key, value);
            }
        };
        this._conf = conf;
        this._cacheSize = cacheSize;
        this._autoSize = auto;
        this._qc = qc;
    }

    protected ObjectCacheImpl(Set<String> types, int cacheSize, Configuration conf, boolean auto) {
        this(types, cacheSize, conf, auto, null);
    }

    ObjectCacheImpl(ObjectCacheImpl other) {
        this._types = other._types;
        this._cacheable = other._cacheable;
        this._cache = new CacheMap(false, other._cacheSize, 500, 0.75f, 16);
        this._conf = other._conf;
        this._cacheSize = other._cacheSize;
        this._qc = other._qc;
        this.clearQc();
    }

    public void clear() {
        this.clearQc();
        this._cache.clear();
    }

    @Override
    public void evict() {
        this.clear();
    }

    @Override
    public boolean evict(Object oid) {
        boolean res;
        boolean bl = res = this._cache.remove(oid = this.getObjectId(oid)) != null;
        if (res) {
            this.clearQc();
        }
        return res;
    }

    @Override
    public boolean contains(Object oid) {
        oid = this.getObjectId(oid);
        return this._cache.containsKey(oid);
    }

    @Override
    public boolean containsAll(List<Object> oid) {
        for (Object o : oid) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<String> getTypes() {
        return this._types;
    }

    @Override
    public boolean isCacheable(ClassMetaData cmd) {
        Boolean res = this._cacheable.get(cmd);
        if (res != null) {
            return res;
        }
        if (!this._types.contains(cmd.getDescribedType().getName())) {
            this._cacheable.put(cmd, Boolean.FALSE);
            return false;
        }
        this._cacheable.put(cmd, Boolean.TRUE);
        return true;
    }

    @Override
    public boolean load(OpenJPAStateManager sm) {
        PersistenceCapable pc = (PersistenceCapable)this._cache.get(sm.getObjectId());
        if (pc != null) {
            if (sm instanceof StateManagerImpl) {
                StateManagerImpl smi = (StateManagerImpl)sm;
                smi.setPc(pc);
                return true;
            }
            this.logUnexpectedSM(sm);
        }
        return false;
    }

    @Override
    public Object load(OpenJPAId id) {
        return this._cache.get((Object)id);
    }

    @Override
    public boolean store(OpenJPAStateManager sm) {
        return this.storeInternal(sm, sm.getLoaded(), false);
    }

    @Override
    public Object find(Object oid) {
        return this._cache.get(oid);
    }

    boolean storeInternal(OpenJPAStateManager sm, BitSet loaded, boolean force) {
        if (this.isCacheable(sm.getMetaData())) {
            PersistenceCapable pc = sm.getPersistenceCapable();
            if (sm instanceof StateManagerImpl) {
                ReadOnlyDetachedStateManager ro = new ReadOnlyDetachedStateManager(pc, sm, loaded, false, false);
                StateManagerImpl smi = (StateManagerImpl)sm;
                this._cache.put(smi.getObjectId(), (Object)pc);
                pc.pcReplaceStateManager((StateManager)ro);
                return true;
            }
            this.logUnexpectedSM(sm);
        }
        if (force) {
            throw new PersistenceException(_loc.get("objectcache-loader-error", (Object)sm.getPersistenceCapable()).getMessage());
        }
        return false;
    }

    void setCacheMap(CacheMap cache) {
        this.clearQc();
        this._cache = cache;
    }

    CacheMap getCacheMap() {
        return this._cache;
    }

    private Object getObjectId(Object o) {
        if (o instanceof PersistenceCapable) {
            StateManager sm = ((PersistenceCapable)o).pcGetStateManager();
            if (sm != null) {
                o = sm.fetchObjectId();
            }
            if (o != null) {
                return o;
            }
        }
        return o;
    }

    private final void logUnexpectedSM(OpenJPAStateManager sm) {
        Log log = this.getLog();
        if (log != null && log.isTraceEnabled()) {
            log.trace((Object)String.format("Unexpected StateManager used to load from ObjectCache. Expected: %s  found: %s", StateManagerImpl.class.getCanonicalName(), sm.getClass().getCanonicalName()));
        }
    }

    private final Log getLog() {
        return this._conf.getLog("openjpa.Runtime");
    }

    private void clearQc() {
        if (this._qc != null) {
            this._qc.clear();
        }
    }
}

