/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.objectcache;

import com.ibm.ws.persistence.EntityManagerImpl;
import com.ibm.ws.persistence.kernel.WsJpaBrokerImpl;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import com.ibm.ws.persistence.objectcache.ObjectCacheImpl;
import com.ibm.ws.persistence.objectcache.ObjectCacheLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.kernel.DetachedStateManager;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;

class ObjectCacheLoaderImpl
implements ObjectCacheLoader {
    private static final Localizer _loc = Localizer.forPackage(ObjectCacheLoaderImpl.class);
    private static final boolean smartRebuild = Boolean.valueOf((String)AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction((String)"openjpa.SmartRebuild", (String)"false")));
    private EntityManagerFactory _emf;
    private long _lastRun;
    private Log _log;
    private Set<String> _types;
    private Map<ClassMetaData, FieldMetaData[]> _mappedByCache = new HashMap<ClassMetaData, FieldMetaData[]>();

    ObjectCacheLoaderImpl(EntityManagerFactory emf, ObjectCacheImpl cache, OpenJPAConfiguration conf, Set<String> types) {
        this._emf = emf;
        this._types = types;
        this._log = conf.getLog("openjpa.Runtime");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        if (this._log.isInfoEnabled()) {
            String since = (this._lastRun == 0L ? -1.0 : (double)(System.currentTimeMillis() - this._lastRun) / 1000.0) + "";
            this._log.info((Object)_loc.get("objectcache-loader-start", new Object[]{this._types.toString(), since}));
            this._lastRun = System.currentTimeMillis();
        }
        EntityManagerImpl cachingEmi = (EntityManagerImpl)this._emf.createEntityManager();
        try {
            EntityManagerImpl noCacheEm = (EntityManagerImpl)this._emf.createEntityManager();
            try {
                WsJpaBrokerImpl noCacheBroker = (WsJpaBrokerImpl)noCacheEm.getBroker();
                noCacheBroker.setObjectCache(null);
                WsJpaBrokerImpl cachingBrokerImpl = (WsJpaBrokerImpl)cachingEmi.getBroker();
                ObjectCacheImpl oldCache = (ObjectCacheImpl)cachingBrokerImpl.getObjectCache();
                ObjectCacheImpl clone = new ObjectCacheImpl(oldCache);
                cachingBrokerImpl.setObjectCache(clone);
                for (String type : this._types) {
                    long start = System.currentTimeMillis();
                    String query = "SELECT p FROM " + type + " p";
                    List res = noCacheEm.createQuery(query).getResultList();
                    if (!this._log.isTraceEnabled()) continue;
                    this._log.trace((Object)(ObjectCacheLoaderImpl.class + ".run() - executed query: [" + query + "] results returned: [" + res.size() + "], time: [" + (double)(System.currentTimeMillis() - start) / 1000.0 + " seconds]."));
                }
                Collection managedObjects = noCacheEm.getManagedObjects();
                if (smartRebuild) {
                    this.smartRebuild(managedObjects, noCacheBroker);
                }
                int stored = 0;
                for (PersistenceCapable pc : managedObjects) {
                    OpenJPAStateManager sm = (OpenJPAStateManager)pc.pcGetStateManager();
                    if (!(sm instanceof DetachedStateManager)) {
                        clone.storeInternal(sm, sm.getLoaded(), true);
                        ++stored;
                        continue;
                    }
                    if (!this._log.isTraceEnabled()) continue;
                    this._log.trace((Object)(ObjectCacheLoaderImpl.class + ".run() - encountered an unexpected StateManager. [" + sm + "]"));
                }
                oldCache.setCacheMap(clone.getCacheMap());
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)_loc.get("objectcache-loader-success", new Object[]{stored, (double)(System.currentTimeMillis() - this._lastRun) / 1000.0}));
                }
            }
            finally {
                if (noCacheEm.isOpen()) {
                    noCacheEm.close();
                }
            }
        }
        finally {
            if (cachingEmi.isOpen()) {
                cachingEmi.close();
            }
        }
    }

    private void smartRebuild(Collection<PersistenceCapable> managedObjects, WsJpaBrokerImpl noCacheBroker) {
        for (PersistenceCapable pc : managedObjects) {
            WsJpaStateManagerImpl sm = (WsJpaStateManagerImpl)pc.pcGetStateManager();
            Object[] intermediateOids = sm.getIntermediateFieldData();
            if (intermediateOids == null) continue;
            ClassMetaData cmd = sm.getMetaData();
            for (FieldMetaData fmd : cmd.getFields()) {
                PersistenceCapable cached;
                Object oid;
                int extraFieldIndex = cmd.getExtraFieldDataIndex(fmd.getIndex());
                if (extraFieldIndex < 0 || (oid = intermediateOids[extraFieldIndex]) == null) continue;
                PersistenceCapable persistenceCapable = cached = oid != null ? (PersistenceCapable)noCacheBroker.findCached(oid, null) : null;
                if (cached == null) continue;
                sm.store(fmd.getIndex(), cached);
                this.processNonOwner((WsJpaStateManagerImpl)cached.pcGetStateManager(), pc);
            }
        }
    }

    private void processNonOwner(WsJpaStateManagerImpl nonOwnerSm, PersistenceCapable owner) {
        BitSet loaded = nonOwnerSm.getLoaded();
        for (FieldMetaData fmd : this.getMappedBy(nonOwnerSm.getMetaData())) {
            FieldMetaData mappedByFmd = fmd.getMappedByMetaData();
            int index = fmd.getIndex();
            PersistenceCapable o = (PersistenceCapable)((StateManagerImpl)owner.pcGetStateManager()).fetch(mappedByFmd.getIndex());
            try {
                if (!o.pcGetStateManager().fetchObjectId().equals(nonOwnerSm.fetchObjectId())) continue;
                if (fmd.isElementCollection() || fmd.getAssociationType() == 2) {
                    Collection<PersistenceCapable> collection = null;
                    if (loaded.get(index)) {
                        collection = (Collection)nonOwnerSm.fetchObject(index);
                    } else {
                        collection = new ArrayList();
                        nonOwnerSm.store(index, collection);
                    }
                    collection.add(owner);
                    continue;
                }
                nonOwnerSm.store(index, owner);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private FieldMetaData[] getMappedBy(ClassMetaData cmd) {
        FieldMetaData[] res = this._mappedByCache.get(cmd);
        if (res != null) {
            return res;
        }
        ArrayList<FieldMetaData> tres = new ArrayList<FieldMetaData>();
        for (FieldMetaData fmd : cmd.getFields()) {
            FieldMetaData mappedByFmd = fmd.getMappedByMetaData();
            if (mappedByFmd == null) continue;
            tres.add(fmd);
        }
        res = tres.toArray(new FieldMetaData[0]);
        this._mappedByCache.put(cmd, res);
        return res;
    }
}

