/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.objectcache;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.objectcache.ObjectCache;
import com.ibm.ws.persistence.objectcache.ObjectCacheImpl;
import com.ibm.ws.persistence.objectcache.ObjectCacheLoader;
import com.ibm.ws.persistence.objectcache.ObjectCacheLoaderImpl;
import com.ibm.ws.persistence.objectcache.ObjectCacheManager;
import com.ibm.ws.persistence.objectcache.ReadOnlyQueryResultsCache;
import com.ibm.ws.persistence.objectcache.ReadOnlyQueryResultsCacheImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.datacache.ClearableScheduler;
import org.apache.openjpa.datacache.DataCacheManagerImpl;
import org.apache.openjpa.event.AttachListener;
import org.apache.openjpa.event.DeleteListener;
import org.apache.openjpa.event.LifecycleEvent;
import org.apache.openjpa.event.PersistListener;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.util.Clearable;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.JPAFacadeHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactory;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.UserException;
import serp.util.Strings;

public class ObjectCacheManagerImpl
implements AttachListener,
Configurable,
ObjectCacheManager,
PersistListener,
DeleteListener,
Closeable {
    private static final Localizer _loc = Localizer.forPackage(ObjectCacheManagerImpl.class);
    private ObjectCache _cache;
    private WsJpaJDBCConfiguration _conf;
    private String _evictionSchedule;
    private String _size = "-1";
    private Set<String> _types;
    private ObjectCacheLoader _loader;
    private ClearableScheduler _scheduler;
    private boolean _autoSize = false;
    private boolean _validate = true;
    private boolean _started = false;
    private ReadOnlyQueryResultsCache _qc;
    private Set<String> _qcQueries = new HashSet<String>();
    private int _qcSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSchedulerAndLoader() {
        if (this._started) {
            return;
        }
        ObjectCacheManagerImpl objectCacheManagerImpl = this;
        synchronized (objectCacheManagerImpl) {
            if (this._started) {
                return;
            }
            if (this._evictionSchedule != null) {
                this._scheduler = new ClearableScheduler((OpenJPAConfiguration)this._conf);
                ObjectCache clearable = this._cache;
                if (this._autoSize) {
                    clearable = new Clearable(){

                        public void clear() {
                            ObjectCacheManagerImpl.this._loader.load();
                        }
                    };
                }
                this._scheduler.scheduleEviction((Clearable)clearable, this._evictionSchedule);
            }
            this.initOneTimeLoader(this._loader);
            this._started = true;
        }
    }

    @Override
    public synchronized void initialize(OpenJPAConfiguration conf, BrokerFactory bf) {
        DataCacheManagerImpl dcm = null;
        if (conf.getDataCacheManagerInstance().getSystemDataCache() != null) {
            dcm = (DataCacheManagerImpl)conf.getDataCacheManagerInstance();
        }
        int size = this.parseSize(this._size);
        this._autoSize = this.parseAuto(this._size);
        Class[] types = ObjectCacheManagerImpl.loadTypes(this._types);
        this.configureQC((WsJpaJDBCConfiguration)conf, types, this._qcSize, this._qcQueries, (EntityManagerFactory)JPAFacadeHelper.toEntityManagerFactory((BrokerFactory)bf));
        this._cache = new ObjectCacheImpl(this._types, size, (Configuration)this._conf, this._autoSize, this._qc);
        if (this._autoSize) {
            if (bf == null) {
                throw new InternalException(_loc.get("objectcache-invalid-state"));
            }
            OpenJPAEntityManagerFactory emf = JPAFacadeHelper.toEntityManagerFactory((BrokerFactory)bf);
            this._loader = new ObjectCacheLoaderImpl((EntityManagerFactory)emf, (ObjectCacheImpl)this._cache, conf, this._types);
        }
        ObjectCacheManagerImpl.validateTypes(conf.getMetaDataRepositoryInstance(), dcm, types, this._autoSize);
        if (this._validate) {
            bf.addLifecycleListener((Object)this, types);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean configureQC(WsJpaJDBCConfiguration conf, Class<?>[] ocTypes, int qcSize, Set<String> qcQueries, EntityManagerFactory emf) {
        if (qcQueries == null || qcQueries.size() == 0 || qcQueries.isEmpty()) {
            return false;
        }
        try {
            List<Class<?>> typesList = Arrays.asList(ocTypes);
            MetaDataRepository repo = conf.getMetaDataRepositoryInstance();
            HashSet<QueryMetaData> qcQmd = new HashSet<QueryMetaData>();
            for (String query : qcQueries) {
                if (query != null && query.isEmpty()) continue;
                QueryMetaData qmd = repo.getQueryMetaData(null, query, null, false);
                if (qmd == null) {
                    throw new PersistenceException(_loc.get("objectcache-named-query-not-found", new Object[]{query}).getMessage());
                }
                if (!qmd.getLanguage().equals("javax.persistence.JPQL")) {
                    throw new PersistenceException(_loc.get("objectcache-named-native-query", new Object[]{query}).getMessage());
                }
                qcQmd.add(qmd);
            }
            this._qc = new ReadOnlyQueryResultsCacheImpl(qcSize, conf, qcQmd);
            boolean bl = true;
            return bl;
        }
        finally {
            boolean bl = true;
        }
    }

    private void initOneTimeLoader(final ObjectCacheLoader loader) {
        if (loader != null) {
            Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                @Override
                public Thread run() {
                    return new Thread("Loader thread"){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(10000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            loader.load();
                        }
                    };
                }
            });
            t.start();
        }
    }

    @Override
    public ObjectCache getCache() {
        return this._cache;
    }

    @Override
    public ReadOnlyQueryResultsCache getQueryCache() {
        return this._qc;
    }

    public ObjectCacheLoader getObjectCacheLoader() {
        return this._loader;
    }

    public void close() throws Exception {
        if (this._scheduler != null) {
            this._scheduler.stop();
        }
        this._cache.clear();
    }

    public void setConfiguration(Configuration conf) {
        this._conf = (WsJpaJDBCConfiguration)conf;
    }

    public void startConfiguration() {
    }

    public void endConfiguration() {
    }

    public void setTypes(String t) {
        this._types = StringUtils.isEmpty((String)t) ? null : new LinkedHashSet<String>(Arrays.asList(Strings.split((String)t, (String)";", (int)0)));
    }

    public void setMaxSize(String size) {
        this._size = size;
    }

    public void setEvictionSchedule(String s) {
        this._evictionSchedule = s;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public boolean getValidate() {
        return this._validate;
    }

    public void setNamedQueries(String queries) {
        if (queries != null) {
            this._qcQueries.addAll(Arrays.asList(queries.split(",")));
        }
    }

    public void setQuerySize(int qcSize) {
        this._qcSize = qcSize;
    }

    public void afterAttach(LifecycleEvent event) {
    }

    public void beforeAttach(LifecycleEvent event) {
        throw new UnsupportedOperationException(_loc.get("readonly-merge").getMessage());
    }

    public void afterDelete(LifecycleEvent event) {
    }

    public void beforeDelete(LifecycleEvent event) {
        throw new UnsupportedOperationException(_loc.get("readonly-delete").getMessage());
    }

    public void afterPersist(LifecycleEvent event) {
    }

    public void beforePersist(LifecycleEvent event) {
        throw new UnsupportedOperationException(_loc.get("readonly-persist").getMessage());
    }

    public static Class<?>[] loadTypes(Set<String> types) {
        MultiClassLoader multi = (MultiClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newMultiClassLoaderAction());
        multi.addClassLoader((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
        multi.addClassLoader((ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(MetaDataRepository.class)));
        Class[] res = new Class[types.size()];
        int i = 0;
        try {
            for (String type : types) {
                res[i] = (Class)AccessController.doPrivileged(J2DoPrivHelper.getForNameAction((String)type, (boolean)true, (ClassLoader)multi));
                ++i;
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return res;
    }

    public static boolean validateTypes(MetaDataRepository repo, DataCacheManagerImpl dcm, Class<?>[] types, boolean autoSize) {
        if (types == null || types.length == 0) {
            throw new GeneralException(_loc.get("objectcache-no-types").getMessage());
        }
        if (autoSize) {
            return true;
        }
        HashMap typeMap = new HashMap();
        for (Class<?> cls : types) {
            typeMap.put(cls, repo.getMetaData(cls, null, true));
        }
        for (ClassMetaData cmd : typeMap.values()) {
            FieldMetaData[] fields;
            if (dcm != null && dcm.isCachable(cmd)) {
                throw new GeneralException(_loc.get("objectcache-datacache-duplicate-types", (Object)cmd.getDescribedType().getName()).getMessage());
            }
            Class[] subclasses = cmd.getPCSubclasses();
            Class superclass = cmd.getPCSuperclass();
            if (subclasses != null && subclasses.length > 0 || superclass != null) {
                throw new GeneralException(_loc.get("objectcache-invalid-type", (Object)cmd.getDescribedType().getName()).getMessage());
            }
            for (FieldMetaData f : fields = cmd.getFields()) {
                ClassMetaData c;
                if (f.getAssociationType() != 0) {
                    throw new GeneralException(_loc.get("objectcache-invalid-field", (Object)(cmd.getDescribedType().getName() + "." + f.getName())).getMessage());
                }
                if (f.isEmbeddedPC()) {
                    throw new GeneralException(_loc.get("objectcache-invalid-field", (Object)(cmd.getDescribedType().getName() + "." + f.getName())).getMessage());
                }
                if (f.isElementCollection()) {
                    throw new GeneralException(_loc.get("objectcache-invalid-field", (Object)(cmd.getDescribedType().getName() + "." + f.getName())).getMessage());
                }
                if (!f.isPrimaryKey() || (c = repo.getCachedMetaData(f.getDeclaredType())) == null || !c.isEmbeddable()) continue;
                throw new GeneralException(_loc.get("objectcache-invalid-field", (Object)(cmd.getDescribedType().getName() + "." + f.getName())).getMessage());
            }
            fields = cmd.getPrimaryKeyFields();
            if (fields != null && fields.length <= 1) continue;
            throw new GeneralException(_loc.get("objectcache-invalid-type", (Object)cmd.getDescribedType().getName()).getMessage());
        }
        return true;
    }

    boolean isAutoSized() {
        return this._autoSize;
    }

    private int parseSize(String _size) {
        try {
            int res = Integer.parseInt(_size);
            if (res <= 0) {
                throw new UserException(_loc.get("objectcache-invalid-size").getMessage());
            }
            return res;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MIN_VALUE;
        }
    }

    private boolean parseAuto(String auto) {
        return auto != null && auto.trim().equalsIgnoreCase("auto");
    }
}

