/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.objectcache;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.objectcache.ReadOnlyQueryResultsCache;
import java.util.Set;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Clearable;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.util.CacheMap;

public class ReadOnlyQueryResultsCacheImpl
implements Clearable,
Closeable,
ReadOnlyQueryResultsCache {
    private static final Localizer _loc = Localizer.forPackage(ReadOnlyQueryResultsCache.class);
    private int _size = 1000;
    private WsJpaJDBCConfiguration _conf = null;
    private Log _log;
    CacheMap _cache = null;
    final Set<QueryMetaData> _queries;

    public ReadOnlyQueryResultsCacheImpl(int size, WsJpaJDBCConfiguration conf, Set<QueryMetaData> queries) {
        this._queries = queries;
        this._size = size;
        this._conf = conf;
        this._log = this._conf.getLog("openjpa.DataCache");
        this.cleanMap();
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)(ReadOnlyQueryResultsCacheImpl.class.getName() + " is enabeld for the following queries " + queries.toString()));
        }
    }

    @Override
    public Object get(Object key) {
        return this._cache.get(key);
    }

    @Override
    public void put(Object key, Object value) {
        this._cache.put(key, value);
    }

    @Override
    public boolean isCachable(QueryMetaData qmd) {
        return this._queries.contains(qmd);
    }

    public void clear() {
        this.cleanMap();
    }

    public void close() throws Exception {
        this._cache = null;
    }

    public CacheMap getBackingMap() {
        return this._cache;
    }

    private void cleanMap() {
        this._cache = new CacheMap();
        this._cache.setCacheSize(this._size);
    }
}

