/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.conf;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.jdbc.kernel.WsJpaJDBCBrokerFactory;
import com.ibm.ws.persistence.pdq.kernel.PDQConstraintUpdateManager;
import com.ibm.ws.persistence.pdq.kernel.PDQPessimisticLockManager;
import com.ibm.ws.persistence.pdq.kernel.PDQStoreManager;
import com.ibm.ws.persistence.pdq.kernel.PDQTableJDBCSeq;
import com.ibm.ws.persistence.pdq.meta.PDQMappingRepository;
import com.ibm.ws.persistence.pdq.sql.DB2Dictionary;
import com.ibm.ws.persistence.pdq.sql.PDQSQLFactoryImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.openjpa.conf.MetaDataRepositoryValue;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.InformixDictionary;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.conf.ObjectValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.concurrent.ConcurrentHashMap;

public final class PDQConfigurationHelper {
    static final String pdqExecutionMode = "pdq.executionMode";
    static final String staticExecutionMode = "STATIC";
    static final String dynamicExecutionMode = "DYNAMIC";
    private static final Localizer _loc = Localizer.forPackage(PDQConfigurationHelper.class);
    private static ConcurrentHashMap PDQXmlMap = new ConcurrentHashMap();

    private static boolean findPDQXml(WsJpaJDBCBrokerFactory factory) {
        String puName = factory.getConfiguration().getId();
        String puNameXml = "META-INF/" + puName + ".pdqxml";
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        Enumeration urls = null;
        boolean foundPDQXml = false;
        try {
            urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)puNameXml));
            if (urls.hasMoreElements()) {
                foundPDQXml = true;
            }
            PDQXmlMap.put((Object)puName, (Object)foundPDQXml);
        }
        catch (Exception pae) {
            PDQXmlMap.put((Object)puName, (Object)foundPDQXml);
        }
        Log log = ((WsJpaJDBCConfigurationImpl)factory.getConfiguration()).getLog("openjpa.Runtime");
        if (log.isTraceEnabled()) {
            if (foundPDQXml) {
                log.trace((Object)_loc.get("found-pdq-xml", new Object[]{puNameXml}));
            } else {
                log.trace((Object)_loc.get("no-pdq-xml", new Object[]{puNameXml}));
            }
        }
        return foundPDQXml;
    }

    public static boolean foundPDQXml(String puName) {
        Boolean found = (Boolean)PDQXmlMap.get((Object)puName);
        if (found != null) {
            return found;
        }
        return false;
    }

    public static boolean configurePdqPlugins(WsJpaJDBCBrokerFactory factory) {
        WsJpaJDBCConfigurationImpl config = (WsJpaJDBCConfigurationImpl)factory.getConfiguration();
        Log log = config.getLog("openjpa.Runtime");
        DBDictionary dict = config.getDBDictionaryInstance();
        if (log.isTraceEnabled()) {
            log.trace((Object)("DBDictionary in use: " + dict.getClass().getName()));
        }
        String pureQueryMode = null;
        DataSource ds = null;
        Class<?> wsCallHelper = null;
        try {
            wsCallHelper = Class.forName("com.ibm.websphere.rsadapter.WSCallHelper", false, (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction()));
            if (wsCallHelper != null && (ds = config.createConnectionFactory().getInnermostDelegate()) != null) {
                Method jdbcCall;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("DataSource: " + ds));
                }
                if ((jdbcCall = wsCallHelper.getMethod("jdbcCall", Class.class, Object.class, String.class, Object[].class, Class[].class)) != null) {
                    String pdqProperties = (String)jdbcCall.invoke(wsCallHelper, null, ds, "getPdqProperties", null, null);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("pdqProperties: " + pdqProperties));
                    }
                    if (pdqProperties != null) {
                        log.trace((Object)"pdqProperties are configured on the data source.  PureQuery mode is set to Dynamic by default.");
                        pureQueryMode = "Dynamic";
                    }
                }
            }
        }
        catch (Throwable jdbcCall) {
            // empty catch block
        }
        if (pureQueryMode == null) {
            String URL2 = config.getConnectionURL();
            if (URL2 == null) {
                URL2 = config.getConnection2URL();
            }
            if (URL2 == null) {
                URL2 = config.getConnectionProperties();
            }
            if (URL2 != null && URL2.indexOf("pdqProperties") != -1) {
                log.trace((Object)"pdqProperties are configured on the connection URL.  PureQuery mode is set to Dynamic by default.");
                pureQueryMode = "Dynamic";
            }
            if (log.isTraceEnabled()) {
                if (URL2 != null && URL2.indexOf("Password") != -1) {
                    URL2 = URL2.substring(0, URL2.indexOf("Password"));
                }
                log.trace((Object)("Connection Url: [" + URL2 + "]"));
            }
        }
        boolean foundPDQXml = false;
        if (pureQueryMode == null) {
            pureQueryMode = config.getPureQueryMode();
            foundPDQXml = PDQConfigurationHelper.findPDQXml(factory);
        }
        boolean useJDBC = false;
        boolean usePDQDynamic = false;
        boolean isCompatible = false;
        if (pureQueryMode.equalsIgnoreCase("JDBC")) {
            useJDBC = true;
        } else if (pureQueryMode.equalsIgnoreCase("Dynamic")) {
            usePDQDynamic = true;
        } else {
            isCompatible = true;
        }
        if (dict.platform.indexOf("DB2") != -1) {
            if (isCompatible) {
                if (foundPDQXml) {
                    PDQConfigurationHelper.setPdqProperties(config, staticExecutionMode);
                } else {
                    useJDBC = true;
                }
            } else if (usePDQDynamic) {
                PDQConfigurationHelper.setPdqProperties(config, dynamicExecutionMode);
            }
            if (!useJDBC) {
                PluginValue dbdictionaryPlugin = config.dbdictionaryPlugin;
                dbdictionaryPlugin.setAlias("db2", DB2Dictionary.class.getCanonicalName());
                dbdictionaryPlugin.setClassName(DB2Dictionary.class.getCanonicalName());
            }
        } else if (dict.platform.indexOf("Informix") != -1) {
            boolean useJCC = ((InformixDictionary)dict).useJCC();
            if (!useJCC) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)_loc.get("no-dynamic-pdq-for-non-jcc"));
                }
                useJDBC = true;
            } else if (usePDQDynamic) {
                PDQConfigurationHelper.setPdqProperties(config, dynamicExecutionMode);
                PluginValue dbdictionaryPlugin = config.dbdictionaryPlugin;
                dbdictionaryPlugin.setAlias("informix", com.ibm.ws.persistence.pdq.sql.InformixDictionary.class.getCanonicalName());
                dbdictionaryPlugin.setClassName(com.ibm.ws.persistence.pdq.sql.InformixDictionary.class.getCanonicalName());
            } else if (isCompatible) {
                useJDBC = true;
            }
        } else {
            useJDBC = true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("DB platform:" + dict.platform + " PureQueryMode:" + pureQueryMode + " useJDBC:" + useJDBC));
        }
        if (!useJDBC) {
            config.setUpdateManager(PDQConstraintUpdateManager.class.getCanonicalName());
            config.setSQLFactory(PDQSQLFactoryImpl.class.getCanonicalName());
            MetaDataRepositoryValue metaRepositoryPlugin = config.metaRepositoryPlugin;
            metaRepositoryPlugin.setAlias("default", PDQMappingRepository.class.getCanonicalName());
            config.setMetaDataRepository(PDQMappingRepository.class.getCanonicalName());
            ObjectValue seqPlugin = config.seqPlugin;
            seqPlugin.setAlias("default", PDQTableJDBCSeq.class.getCanonicalName());
            config.setSequence(PDQTableJDBCSeq.class.getCanonicalName());
        }
        return !useJDBC;
    }

    private static void setPdqProperties(WsJpaJDBCConfiguration config, String executionMode) {
        Properties props = config.getPdqProperties();
        if (props == null) {
            props = new Properties();
            config.setPdqProperties(props);
        }
        props.setProperty(pdqExecutionMode, executionMode);
        config.setPdqProperties(props);
    }

    public static StoreManager newPdqStoreManager(JDBCConfiguration jdbcConfig) {
        PDQStoreManager mgr = null;
        DBDictionary dict = ((PDQMappingRepository)jdbcConfig.getMetaDataRepositoryInstance()).getDBDictionary();
        if (dict.platform.indexOf("DB2") != -1 || dict.platform.indexOf("Informix") != -1) {
            mgr = new PDQStoreManager();
        }
        return mgr;
    }

    public static LockManager newPdqPessimisticLockManager() {
        return new PDQPessimisticLockManager();
    }
}

