/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.kernel;

import com.ibm.ws.persistence.jdbc.kernel.PreparedStatementManagerImpl;
import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import com.ibm.ws.persistence.pdq.meta.PDQBaseData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.OptimisticException;

public class PDQPreparedStatementManagerImpl
extends PreparedStatementManagerImpl {
    private List<Row> _heteroBatchedRows = null;
    private Object _data = null;
    private boolean _startBatch = false;
    private Log _log = null;
    private static final Localizer _loc = Localizer.forPackage(PDQPreparedStatementManagerImpl.class);

    public PDQPreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit) {
        super(store, conn, batchLimit);
    }

    @Override
    protected void flushAndUpdate(RowImpl row) throws SQLException {
        String sql;
        PreparedStatement stmnt;
        ClassMapping clm;
        VersionStrategy strat;
        OpenJPAStateManager osm;
        Column[] autoAssign = this.getAutoAssignColumns(row);
        String[] autoAssignColNames = this.getAutoAssignColNames(autoAssign, row);
        if (autoAssignColNames == null) {
            super.flushAndUpdate(row);
            return;
        }
        Column[] verCols = this.getVersionStrategyColumns(row);
        if (verCols != null && verCols.length > 0 && (osm = row.getPrimaryKey()) != null && (strat = (clm = (ClassMapping)osm.getMetaData()).getVersion().getStrategy()) instanceof ColumnVersionStrategy) {
            ((ColumnVersionStrategy)strat).setTokenVersionType(this._store);
        }
        if ((stmnt = this.prepareStatement(sql = row.getSQL(this._dict), autoAssignColNames)) != null) {
            row.flush(stmnt, this._dict, this._store);
        }
        try {
            Object obj = this.executeUpdateAutoGen(stmnt, sql, row, autoAssignColNames);
            List<Object> genKeys = this.getGeneratedKeys(obj, autoAssignColNames);
            if (genKeys.size() == 0) {
                this.logSQLWarnings(stmnt);
                Object failed = row.getFailedObject();
                if (failed != null) {
                    this._exceptions.add(new OptimisticException(failed));
                } else if (row.getAction() == 1) {
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)0, (Object)sql).getMessage());
                }
            }
            this.populateAutoAssignCols(obj, autoAssign, autoAssignColNames, row, genKeys);
            this.setVersion(row);
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore((SQLException)se, (Object)row.getFailedObject(), (DBDictionary)this._dict);
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected Object executeUpdateAutoGen(PreparedStatement stmnt, String sql, RowImpl row, String[] autoAssignColNames) throws SQLException {
        return PDQBaseData.updateAutoGen(this._conn, this._store, row, autoAssignColNames);
    }

    protected List<Object> getGeneratedKeys(Object obj, String[] autoAssignColNames) throws SQLException {
        Object[] objs;
        int updateCount;
        ArrayList<Object> vals = new ArrayList<Object>();
        if (obj instanceof ResultSet) {
            ResultSet rs = (ResultSet)obj;
            while (rs.next()) {
                for (int i = 0; i < autoAssignColNames.length; ++i) {
                    vals.add(rs.getObject(i + 1));
                }
            }
            rs.close();
        } else if (obj instanceof Object[] && (updateCount = ((Integer)(objs = (Object[])obj)[objs.length - 1]).intValue()) != 0) {
            for (int i = 0; i < objs.length - 1; ++i) {
                vals.add(objs[i]);
            }
        }
        return vals;
    }

    protected List<Object> populateAutoAssignCols(Object obj, Column[] autoAssign, String[] autoAssignColNames, RowImpl row, List vals) throws SQLException {
        this.setObjectId(vals, autoAssign, autoAssignColNames, row);
        return vals;
    }

    protected int executeUpdate(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        return PDQBaseData.update(this._conn, this._store, row, null, sql);
    }

    protected PreparedStatement prepareStatement(String sql) throws SQLException {
        return null;
    }

    @Override
    protected ResultSet executeQuery(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        return PDQBaseData.queryResults(this._conn, sql, this._store, row);
    }

    public void flush(RowImpl row) {
        try {
            if (row.getAction() != 0) {
                this.flushInternal(row);
                return;
            }
            StateManagerImpl s = (StateManagerImpl)row.getPrimaryKey();
            if (s == null) {
                this.flushInternal(row);
                return;
            }
            VersionStrategy strategy = ((ClassMapping)s.getMetaData()).getVersion().getStrategy();
            boolean isDBGenVersion = false;
            if (strategy != null && ColumnVersionStrategy.isVersionStrategyColumn(strategy)) {
                isDBGenVersion = true;
            }
            int whereVersionIdx = -1;
            int versionIdx = -1;
            ClassMapping meta = (ClassMapping)s.getMetaData();
            Column[] cols = row.getColumns();
            Version version = meta.getVersion();
            Column[] vcols = version.getColumns();
            if (vcols != null && vcols.length > 0) {
                Column verCol = vcols[0];
                versionIdx = verCol.getIndex();
                whereVersionIdx = versionIdx + cols.length;
            }
            RowImpl savedRow = (RowImpl)row.clone();
            Object failedObj = row.getFailedObject();
            savedRow.setFailedObject(failedObj);
            Object[] vals = row.getVals();
            Object[] savedVals = new Object[vals.length];
            System.arraycopy(vals, 0, savedVals, 0, vals.length);
            FieldMetaData[] fms = meta.getFields();
            HashMap lazyColumns = new HashMap();
            HashMap eagerColumns = new HashMap();
            this.findColumn(fms, lazyColumns, eagerColumns);
            BitSet lazyCol = new BitSet();
            BitSet eagerCol = new BitSet();
            for (int i = 0; i < cols.length; ++i) {
                if (vals[i] == null) continue;
                if (lazyColumns.containsKey(cols[i])) {
                    lazyCol.set(i);
                    continue;
                }
                if (!eagerColumns.containsKey(cols[i])) continue;
                eagerCol.set(i);
            }
            if (lazyCol.isEmpty()) {
                this.flushInternal(row);
                return;
            }
            boolean needCheckVersion = false;
            if (!eagerCol.isEmpty()) {
                for (int i = 0; i < cols.length; ++i) {
                    if (!lazyCol.get(i)) continue;
                    vals[i] = null;
                }
                RowImpl row1 = (RowImpl)savedRow.clone();
                row1.setFailedObject(failedObj);
                Object[] vals1 = row1.getVals();
                System.arraycopy(vals, 0, vals1, 0, vals1.length);
                this.flushInternal(row1);
                needCheckVersion = true;
                for (int i = 0; i < cols.length; ++i) {
                    if (!eagerCol.get(i)) continue;
                    vals[i] = null;
                }
            }
            for (int i = 0; i < cols.length; ++i) {
                if (!lazyCol.get(i)) continue;
                vals[i] = savedVals[i];
                RowImpl row1 = (RowImpl)savedRow.clone();
                row1.setFailedObject(failedObj);
                Object[] vals1 = row1.getVals();
                System.arraycopy(vals, 0, vals1, 0, vals1.length);
                if (needCheckVersion && whereVersionIdx != -1) {
                    if (isDBGenVersion) {
                        this.setVersion(s, strategy, vals1, whereVersionIdx, needCheckVersion);
                    } else {
                        vals1[whereVersionIdx] = vals[versionIdx];
                    }
                }
                this.flushInternal(row1);
                vals[i] = null;
                needCheckVersion = true;
            }
        }
        catch (SQLException se) {
            this._exceptions.add(SQLExceptions.getStore((SQLException)se, (DBDictionary)this._dict));
        }
        catch (OpenJPAException ke) {
            this._exceptions.add(ke);
        }
    }

    private void findColumn(FieldMetaData[] fms, Map lazyColumns, Map eagerColumns) {
        for (int i = 0; i < fms.length; ++i) {
            Column col;
            if (fms[i].isPrimaryKey() || fms[i].isVersion()) continue;
            Column[] cols = ((FieldMapping)fms[i]).getColumns();
            Column column = col = cols != null && cols.length > 0 ? cols[0] : null;
            if (col == null) continue;
            boolean isEager = fms[i].isInDefaultFetchGroup();
            if (!isEager) {
                lazyColumns.put(col, col);
                continue;
            }
            eagerColumns.put(col, col);
        }
    }

    private void setVersion(StateManagerImpl sm, VersionStrategy strategy, Object[] vals, int versionIdx, boolean needCheckVersion) throws SQLException {
        if (strategy == null) {
            return;
        }
        if (needCheckVersion) {
            strategy.checkVersion((OpenJPAStateManager)sm, this._store, true);
            vals[versionIdx] = sm.getVersion();
        }
    }

    public boolean isBatchDisabled() {
        return false;
    }

    protected void batchOrExecuteRow(RowImpl row) throws SQLException {
        if (this._heteroBatchedRows == null) {
            this._heteroBatchedRows = new LinkedList<Row>();
        }
        this._heteroBatchedRows.add((Row)row);
    }

    protected void addBatch(PreparedStatement ps, RowImpl row, int count) throws SQLException {
        if (this._log == null) {
            this._log = this._store.getConfiguration().getLog("openjpa.jdbc.JDBC");
        }
        if (count == 0 || this._startBatch) {
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("start-batch"));
            }
            this._data = PDQBaseData.startBatch(this._conn, this._store);
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("batch-stmt", (Object)row.getSQL(this._dict)));
        }
        PDQBaseData.update(this._conn, this._store, row, this._data);
        this._startBatch = false;
    }

    protected int[] executeBatch(PreparedStatement ps) throws SQLException {
        if (this._log == null) {
            this._log = this._store.getConfiguration().getLog("openjpa.jdbc.JDBC");
        }
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("end-batch"));
        }
        int[][] retrc = PDQBaseData.endBatch(this._conn, this._store, this._data);
        this._data = null;
        int[] rc = new int[retrc.length];
        for (int i = 0; i < retrc.length; ++i) {
            rc[i] = retrc[i][0];
        }
        this._startBatch = true;
        return rc;
    }

    public List getBatchedRows() {
        return this._heteroBatchedRows;
    }

    public String getBatchedSql() {
        return "";
    }
}

