/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.meta;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfiguration;
import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import com.ibm.ws.persistence.kernel.WsJpaStateManagerImpl;
import com.ibm.ws.persistence.pdq.meta.PDQMappingRepository;
import com.ibm.ws.persistence.pdq.meta.PDQParameterHandler;
import com.ibm.ws.persistence.pdq.meta.PreparedStatementObjArray;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.jdbc.JDBCEvent;
import org.apache.openjpa.lib.jdbc.JDBCListener;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;

public abstract class PDQBaseData {
    private static final Localizer _loc = Localizer.forPackage(PDQBaseData.class);
    public static final String generatorVersion = "1.1.1";
    private static final String PRINT_PARAMETERS_CONFIG_STR = "PrintParameters";
    private static String heterogeneousNone = "heterogeneousNone__";
    private static String heterogeneousModify = "heterogeneousModify__";
    private static String heterogeneousQuery = "heterogeneousQuery__";
    private static String heterogeneousMixed = "heterogeneousMixed__";
    private static Class<?> statementDescriptor;
    private static Class<?> generatorData;
    private static Class<?> data;
    private static Class<?> dataFactory;
    private static Class<?> heterogeneousBatchKind;
    private static Method getData;
    private static Method queryResultsStatic;
    private static Method queryResultsDynamic;
    private static Method updateStatic;
    private static Method updateDynamic;
    private static Method updateDynamicAutoGen;
    private static Method startBatch;
    private static Method endBatch;
    private static Method getBatchKind;
    private static PDQParameterHandler paramHandler;

    public static ResultSet queryResults(Connection conn, JDBCConfiguration conf, SQLBuffer buf) throws SQLException {
        String sql = buf.getSQL();
        Object[] params = buf.getParameters().toArray();
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleSQLBuffer(buf, conf.getDBDictionaryInstance(), stmnt);
        return PDQBaseData.executeQuery(sql, conn, conf, stmnt);
    }

    public static ResultSet queryResults(Connection conn, String sql, JDBCStore store, RowImpl row) throws SQLException {
        WsJpaJDBCConfiguration conf = (WsJpaJDBCConfiguration)store.getConfiguration();
        Object[] params = PDQBaseData.getVals(row);
        params = PDQBaseData.processNulls(row, params);
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleRow(row, store, stmnt);
        return PDQBaseData.executeQuery(sql, conn, conf, stmnt);
    }

    public static ResultSet queryResults(Connection conn, JDBCConfiguration conf, String sql, Object[] params, Column[] cols) throws SQLException {
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleParams(conf.getDBDictionaryInstance(), cols, stmnt);
        return PDQBaseData.executeQuery(sql, conn, conf, stmnt);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ResultSet executeQuery(String sql, Connection conn, JDBCConfiguration conf, PreparedStatementObjArray stmnt) throws SQLException {
        ResultSet resultSet;
        PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
        Object sd = pdqrepos.getStaticStatementDescriptor(sql);
        Properties props = ((WsJpaJDBCConfiguration)conf).getPdqProperties();
        Log _log = conf.getLog("wsjpa.pdq");
        JDBCEvent before = null;
        try {
            Object dataReturned = getData.invoke(dataFactory, conn, props);
            boolean isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            PDQBaseData.logSQL(_log, conf, sql, stmnt, isStatic);
            int rsType = 1003;
            int rsConcur = 1007;
            int rsHold = 1;
            before = PDQBaseData.fireEvent(sql, conn, conf, before, (short)5);
            ResultSet rs = null;
            rs = sd != null ? (ResultSet)queryResultsStatic.invoke(dataReturned, sd, stmnt.data_) : (ResultSet)queryResultsDynamic.invoke(dataReturned, rsType, rsConcur, rsHold, sql, stmnt.data_);
            resultSet = rs;
        }
        catch (InvocationTargetException de) {
            try {
                throw PDQBaseData.getSQLException(de, _log);
                catch (IllegalAccessException e) {
                    throw (SQLException)e.getCause();
                }
            }
            catch (Throwable throwable) {
                PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
                throw throwable;
            }
        }
        PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
        return resultSet;
    }

    public static int update(Connection conn, JDBCConfiguration conf, SQLBuffer update) throws SQLException {
        String sql = update.getSQL();
        Object[] params = update.getParameters().toArray();
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleSQLBuffer(update, conf.getDBDictionaryInstance(), stmnt);
        return PDQBaseData.executeUpdate(conn, conf, null, sql, stmnt);
    }

    public static int update(Connection conn, JDBCStore store, RowImpl row, Object data1) throws SQLException {
        return PDQBaseData.update(conn, store, row, data1, null);
    }

    public static int update(Connection conn, JDBCStore store, RowImpl row, Object data1, String sql) throws SQLException {
        if (sql == null) {
            sql = row.getSQL(store.getDBDictionary());
        }
        Object[] params = PDQBaseData.getVals(row);
        JDBCConfiguration conf = store.getConfiguration();
        params = PDQBaseData.processNulls(row, params);
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleRow(row, store, stmnt);
        sql = PDQBaseData.sort(sql, params);
        return PDQBaseData.executeUpdate(conn, conf, data1, sql, stmnt);
    }

    private static Object[] getVals(RowImpl row) {
        Column[] cols = row.getColumns();
        Object[] params = row.getVals();
        if (row.getAction() == 1) {
            return params;
        }
        for (int i = 0; i < cols.length; ++i) {
            VersionStrategy verStrat = cols[i].getVersionStrategy();
            if (!ColumnVersionStrategy.isVersionStrategyColumn(verStrat)) continue;
            int verIdx = i + params.length / 2;
            Object[] params1 = new Object[params.length + 1];
            Object val = params[verIdx];
            Object ver = null;
            Object rid = null;
            if (val instanceof Object[]) {
                System.arraycopy(params, 0, params1, 0, verIdx - 1);
                ver = ((Object[])val)[0];
                rid = ((Object[])val)[1];
                params1[verIdx] = ver;
                params1[verIdx + 1] = rid;
                System.arraycopy(params, verIdx + 1, params1, verIdx + 2, params.length - verIdx - 1);
            } else {
                System.arraycopy(params, 0, params1, 0, params.length - 1);
                if (i * 2 + 1 > params.length || (ver = params[i * 2 + 1]) == null) break;
                rid = ((WsJpaStateManagerImpl)row.getPrimaryKey()).getRid();
                params1[params.length - 1] = ver;
                params1[params.length] = rid;
            }
            return params1;
        }
        return params;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int executeUpdate(Connection conn, JDBCConfiguration conf, Object data1, String sql, PreparedStatementObjArray stmnt) throws SQLException {
        int n;
        Log _log = conf.getLog("wsjpa.pdq");
        PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
        Properties props = ((WsJpaJDBCConfiguration)conf).getPdqProperties();
        Object sd = pdqrepos.getStaticStatementDescriptor(sql);
        JDBCEvent before = null;
        try {
            Object dataTemp = data1;
            if (dataTemp == null) {
                dataTemp = getData.invoke(dataFactory, conn, props);
            }
            boolean isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            PDQBaseData.logSQL(_log, conf, sql, stmnt, isStatic);
            before = PDQBaseData.fireEvent(sql, conn, conf, before, (short)5);
            int count = 0;
            count = sd != null ? ((Integer)updateStatic.invoke(dataTemp, sd, stmnt.data_)).intValue() : ((Integer)updateDynamic.invoke(dataTemp, sql, stmnt.data_)).intValue();
            n = count;
        }
        catch (InvocationTargetException de) {
            try {
                throw PDQBaseData.getSQLException(de, _log);
                catch (IllegalAccessException e) {
                    throw (SQLException)e.getCause();
                }
            }
            catch (Throwable throwable) {
                PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
                throw throwable;
            }
        }
        PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
        return n;
    }

    public static Object updateAutoGen(Connection conn, JDBCStore store, RowImpl row, String[] autogenColNames) throws SQLException {
        String sql = row.getSQL(store.getDBDictionary());
        Object[] params = row.getVals();
        JDBCConfiguration conf = store.getConfiguration();
        params = PDQBaseData.processNulls(row, params);
        PreparedStatementObjArray stmnt = new PreparedStatementObjArray(params);
        paramHandler.handleRow(row, store, stmnt);
        sql = PDQBaseData.sort(sql, params);
        return PDQBaseData.executeUpdateAutoGen(conn, conf, sql, stmnt, autogenColNames);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object executeUpdateAutoGen(Connection conn, JDBCConfiguration conf, String sql, PreparedStatementObjArray stmnt, String[] autogenColNames) throws SQLException {
        Object object;
        Object dataReturned;
        JDBCEvent before;
        Log _log;
        block6: {
            _log = conf.getLog("wsjpa.pdq");
            PDQMappingRepository pdqrepos = (PDQMappingRepository)conf.getMappingRepositoryInstance();
            Properties props = ((WsJpaJDBCConfiguration)conf).getPdqProperties();
            Object sd = pdqrepos.getStaticStatementDescriptor(sql);
            before = null;
            dataReturned = getData.invoke(dataFactory, conn, props);
            boolean isStatic = sd != null && props != null && props.getProperty("pdq.executionMode").equals("STATIC");
            PDQBaseData.logSQL(_log, conf, sql, stmnt, isStatic);
            before = PDQBaseData.fireEvent(sql, conn, conf, before, (short)5);
            if (sd == null) break block6;
            Object object2 = queryResultsStatic.invoke(dataReturned, sd, stmnt.data_);
            PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
            return object2;
        }
        try {
            object = updateDynamicAutoGen.invoke(dataReturned, sql, Object[].class, autogenColNames, stmnt.data_);
        }
        catch (InvocationTargetException de) {
            try {
                throw PDQBaseData.getSQLException(de, _log);
                catch (IllegalAccessException e) {
                    throw (SQLException)e.getCause();
                }
            }
            catch (Throwable throwable) {
                PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
                throw throwable;
            }
        }
        PDQBaseData.fireEvent(sql, conn, conf, before, (short)6);
        return object;
    }

    private static Object[] processNulls(RowImpl row, Object ... vals) {
        int i = row.getAction() == 2 ? row.getColumns().length : 0;
        int length = 0;
        for (int j = i; j < vals.length; ++j) {
            if (vals[j] == null) continue;
            ++length;
        }
        Object[] params = new Object[length];
        int half = vals.length / 2;
        int j = 0;
        while (i < vals.length) {
            if (vals[i] == null) {
                --j;
            } else {
                params[j] = vals[i];
                if ((vals[i] != RowImpl.NULL || row.getAction() == 1 || i < half) && vals[i] == RowImpl.NULL) {
                    params[j] = null;
                }
            }
            ++i;
            ++j;
        }
        return params;
    }

    public static Object startBatch(Connection conn, JDBCStore store) throws SQLException {
        WsJpaJDBCConfiguration conf = (WsJpaJDBCConfiguration)store.getConfiguration();
        Log _log = conf.getLog("wsjpa.pdq");
        Properties props = conf.getPdqProperties();
        try {
            Object dataReturned = getData.invoke(dataFactory, conn, props);
            Enum[] batchKinds = (Enum[])heterogeneousBatchKind.getEnumConstants();
            for (int i = 0; i < batchKinds.length; ++i) {
                if (!batchKinds[i].name().equals(heterogeneousModify)) continue;
                startBatch.invoke(dataReturned, batchKinds[i]);
                return dataReturned;
            }
            return null;
        }
        catch (InvocationTargetException de) {
            throw PDQBaseData.getSQLException(de, _log);
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    public static int[][] endBatch(Connection conn, JDBCStore store, Object dataObject) throws SQLException {
        Log _log = store.getConfiguration().getLog("wsjpa.pdq");
        try {
            return (int[][])endBatch.invoke(dataObject, (Object[])null);
        }
        catch (InvocationTargetException de) {
            throw PDQBaseData.getSQLException(de, _log);
        }
        catch (IllegalAccessException e) {
            throw (SQLException)e.getCause();
        }
    }

    private static SQLException getSQLException(InvocationTargetException de, Log _log) {
        Throwable sqle;
        Throwable t;
        if (_log != null && _log.isTraceEnabled()) {
            de.printStackTrace();
            _log.trace((Object)de);
            t = de.getCause();
            if (t != null) {
                _log.trace((Object)t);
            }
        }
        if ((sqle = (t = de.getTargetException()).getCause()) == null) {
            if (t != null) {
                return new SQLException(t.getMessage());
            }
            return new SQLException(de.getMessage());
        }
        Throwable sqle1 = sqle.getCause();
        if (sqle1 != null) {
            sqle = sqle1;
        }
        return (SQLException)sqle;
    }

    private static JDBCEvent fireEvent(String sql, Connection conn, JDBCConfiguration conf, JDBCEvent associateEvent, short type) {
        JDBCListener[] listeners = conf.getJDBCListenerInstances();
        JDBCEvent event = new JDBCEvent(conn, type, associateEvent, (Statement)null, sql);
        if (listeners != null && listeners.length > 0) {
            block4: for (int i = 0; i < listeners.length; ++i) {
                switch (event.getType()) {
                    case 5: {
                        listeners[i].beforeExecuteStatement(event);
                        continue block4;
                    }
                    case 6: {
                        listeners[i].afterExecuteStatement(event);
                    }
                }
            }
        }
        return event;
    }

    public static String sort(String sql, Object[] params) {
        if (sql.substring(0, 6).equalsIgnoreCase("INSERT")) {
            return PDQBaseData.sortInsertStatement(sql, params);
        }
        if (sql.substring(0, 6).equalsIgnoreCase("UPDATE")) {
            return PDQBaseData.sortUpdateStatement(sql, params);
        }
        return sql;
    }

    private static String sortInsertStatement(String sql, Object[] params) {
        String sql1 = sql.substring(0, sql.indexOf("(") + 1);
        String sql2 = sql.substring(sql.indexOf("(") + 1, sql.indexOf(")"));
        String sql3 = sql.substring(sql.indexOf(")"), sql.lastIndexOf("(") + 1);
        String sql4 = sql.substring(sql.lastIndexOf("(") + 1, sql.lastIndexOf(")"));
        String sql5 = sql.substring(sql.lastIndexOf(")"));
        StringTokenizer st = new StringTokenizer(sql2, ",");
        ArrayList<String> cols = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            cols.add(st.nextToken().trim());
        }
        st = new StringTokenizer(sql4, ",");
        ArrayList<String> vals = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            vals.add(st.nextToken().trim());
        }
        HashMap<String, String> colValMap = new HashMap<String, String>();
        HashMap<String, Object> colParamMap = new HashMap<String, Object>();
        int j = 0;
        for (int i = 0; i < cols.size(); ++i) {
            String col = (String)cols.get(i);
            String val = (String)vals.get(i);
            colValMap.put(col, val);
            if (params == null || !val.equals("?")) continue;
            colParamMap.put(col, params[j++]);
        }
        Collections.sort(cols);
        StringBuilder sb = new StringBuilder(sql.length());
        StringBuilder valSb = new StringBuilder(sql.length());
        sb.append(sql1);
        int size = cols.size();
        int j2 = 0;
        for (int i = 0; i < size; ++i) {
            String col = (String)cols.get(i);
            String val = (String)colValMap.get(col);
            valSb.append(val);
            sb.append((String)cols.get(i));
            if (i < size - 1) {
                sb.append(",");
                valSb.append(",");
            }
            if (params == null || !val.equals("?")) continue;
            params[j2++] = colParamMap.get(col);
        }
        sb.append(sql3);
        sb.append(valSb.toString());
        sb.append(sql5);
        return sb.toString();
    }

    private static String sortUpdateStatement(String sql, Object[] params) {
        String sql1 = sql.substring(0, sql.indexOf(" SET ") + 5);
        String sql2 = sql.substring(sql.indexOf(" SET ") + 5, sql.indexOf(" WHERE "));
        String sql3 = sql.substring(sql.lastIndexOf(" WHERE "));
        StringTokenizer st = new StringTokenizer(sql2, ",");
        ArrayList<String> cols = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            cols.add(st.nextToken().trim());
        }
        if (cols.size() == 1) {
            return sql;
        }
        HashMap<String, String> colValMap = new HashMap<String, String>();
        HashMap<String, Object> colParamMap = new HashMap<String, Object>();
        int j = 0;
        for (int i = 0; i < cols.size(); ++i) {
            String col = (String)cols.get(i);
            if (col.indexOf(" = ?") == -1) continue;
            colValMap.put(col, "?");
            if (params == null) continue;
            colParamMap.put(col, params[j++]);
        }
        Collections.sort(cols);
        StringBuilder sb = new StringBuilder(sql.length());
        sb.append(sql1);
        int size = cols.size();
        int j2 = 0;
        for (int i = 0; i < size; ++i) {
            String col = (String)cols.get(i);
            String val = (String)colValMap.get(col);
            sb.append((String)cols.get(i));
            if (i < size - 1) {
                sb.append(", ");
            }
            if (params == null || !val.equals("?")) continue;
            params[j2++] = colParamMap.get(col);
        }
        sb.append(sql3);
        return sb.toString();
    }

    private static void logSQL(Log _pdqLog, JDBCConfiguration conf, String sql, PreparedStatementObjArray stmnt, boolean isStatic) {
        if (_pdqLog.isTraceEnabled()) {
            PDQBaseData.logSQL(_pdqLog, sql, stmnt, isStatic, conf);
            return;
        }
        Log _sqlLog = conf.getLog("openjpa.jdbc.SQL");
        PDQBaseData.logSQL(_sqlLog, sql, stmnt, isStatic, conf);
    }

    private static void logSQL(Log _log, String sql, PreparedStatementObjArray stmnt, boolean isStatic, JDBCConfiguration conf) {
        if (_log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder(sql.length());
            boolean printParameters = Boolean.parseBoolean(Configurations.parseProperties((String)conf.getConnectionFactoryProperties()).getProperty(PRINT_PARAMETERS_CONFIG_STR, "false"));
            sb.append(sql).append(" [");
            for (int i = 0; i < stmnt.data_.length; ++i) {
                sb.append(printParameters ? stmnt.data_[i] : "?");
                if (i >= stmnt.data_.length - 1) continue;
                sb.append(",");
            }
            sb.append("]");
            _log.trace((Object)_loc.get(isStatic ? "pdq-static" : "pdq-dynamic", (Object)sb.toString()));
        }
    }

    static {
        paramHandler = new PDQParameterHandler();
        try {
            ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            statementDescriptor = Class.forName("com.ibm.pdq.runtime.statement.StatementDescriptor", false, loader);
            dataFactory = Class.forName("com.ibm.pdq.runtime.factory.DataFactory", false, loader);
            getData = dataFactory.getMethod("getData", Connection.class, Properties.class);
            generatorData = Class.forName("com.ibm.pdq.runtime.generator.GeneratorData", false, loader);
            data = Class.forName("com.ibm.pdq.runtime.Data", false, loader);
            heterogeneousBatchKind = Class.forName("com.ibm.pdq.runtime.HeterogeneousBatchKind", false, loader);
            queryResultsStatic = generatorData.getMethod("queryResults", statementDescriptor, Object[].class);
            queryResultsDynamic = data.getMethod("queryResults", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Object[].class);
            updateStatic = generatorData.getMethod("update", statementDescriptor, Object[].class);
            updateDynamic = data.getMethod("update", String.class, Object[].class);
            updateDynamicAutoGen = data.getMethod("update", String.class, Class.class, String[].class, Object[].class);
            startBatch = data.getMethod("startBatch", heterogeneousBatchKind);
            endBatch = data.getMethod("endBatch", new Class[0]);
            getBatchKind = data.getMethod("getBatchKind", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

