/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdq.meta;

import com.ibm.ws.persistence.jdbc.conf.WsJpaJDBCConfigurationImpl;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.pdq.conf.PDQConfigurationHelper;
import com.ibm.ws.persistence.pdq.meta.PDQSequenceMapping;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.util.StoreException;

public class PDQMappingRepository
extends MappingRepository {
    private static final long serialVersionUID = -1340388073884964362L;
    private static final Localizer _loc = Localizer.forPackage(PDQMappingRepository.class);
    private Map<String, Object> _pdqStaticSDs = null;
    private static Class XmlReader;
    private static Class pdqXml;
    private static Class xmlStatement;
    private static Class xmlStatementDescriptor;
    private static Class xmlPackage;
    private static Class statementDescriptor;
    private static Method getPDQXml;
    private static Method parseStream;
    private static Method getStatements;
    private static Method createStatementDescriptorForRuntime;
    private static Method getDbProductName;
    private static Method getDbProductVersion;
    private static Method getPDQXmlStatementDescriptor;
    private static Method getPackageInfo;
    private static Method setCollectionName;
    private static Method getProcessedSql;
    private String xmlProductName;
    private String xmlProductVersion;
    private String puNameXml;

    public void endConfiguration() {
        super.endConfiguration();
        WsJpaJDBCConfigurationImpl config = (WsJpaJDBCConfigurationImpl)this.getConfiguration();
        String puName = config.getId();
        DBDictionary dict = this.getDBDictionary();
        Log log = config.getLog("wsjpa.pdq");
        try {
            config.getDataSource(null);
            if (log.isTraceEnabled()) {
                log.trace((Object)("DB platform: " + dict.platform + " supportsGetGeneratedKeys: " + dict.supportsGetGeneratedKeys + " dict: " + dict));
            }
        }
        catch (Exception se) {
            throw new StoreException((Throwable)se);
        }
        if (dict.platform.indexOf("DB2") != -1 && PDQConfigurationHelper.foundPDQXml(puName)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("loading pdqxml for PU: " + puName));
            }
            this.loadStaticStatementDescriptors();
            this.verifyProductVersion();
        }
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        if (this.getDBDictionary().platform.indexOf("DB2") != -1) {
            return new PDQSequenceMapping(name, this);
        }
        return super.newSequenceMetaData(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadStaticStatementDescriptors() {
        block15: {
            this.puNameXml = "META-INF/" + this.getConfiguration().getId() + ".pdqxml";
            String collectionName = this.getConfiguration().getValue("jdbc.CollectionId") == null ? null : this.getConfiguration().getValue("jdbc.CollectionId").getString();
            Log log = this.getConfiguration().getLog("wsjpa.pdq");
            ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            Enumeration urls = null;
            try {
                urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)this.puNameXml));
                if (!urls.hasMoreElements()) {
                    return;
                }
            }
            catch (Exception pae) {
                log.error((Object)_loc.get("pdq-xml-load-error", new Object[]{this.puNameXml, pae.getMessage()}));
                return;
            }
            ArrayList url = Collections.list(urls);
            try {
                InputStream ins = (InputStream)AccessController.doPrivileged(J2DoPrivHelper.openStreamAction((URL)((URL)url.get(0))));
                if (ins == null) break block15;
                try {
                    Object xmlReader = XmlReader.newInstance();
                    parseStream.invoke(xmlReader, ins);
                    Object pdqXmlTemp = getPDQXml.invoke(xmlReader, (Object[])null);
                    this.xmlProductName = (String)getDbProductName.invoke(pdqXmlTemp, (Object[])null);
                    this.xmlProductVersion = (String)getDbProductVersion.invoke(pdqXmlTemp, (Object[])null);
                    List stmtList = (List)getStatements.invoke(xmlReader, (Object[])null);
                    if (this._pdqStaticSDs == null) {
                        this._pdqStaticSDs = new HashMap<String, Object>();
                    }
                    Object sd = null;
                    for (int i = 0; i < stmtList.size(); ++i) {
                        Object xmlStmt = stmtList.get(i);
                        if (collectionName != null) {
                            Object xmlSD = getPDQXmlStatementDescriptor.invoke(xmlStmt, (Object[])null);
                            Object xmlPkg = getPackageInfo.invoke(xmlSD, (Object[])null);
                            setCollectionName.invoke(xmlPkg, collectionName);
                        }
                        sd = createStatementDescriptorForRuntime.invoke(xmlReader, getPDQXmlStatementDescriptor.invoke(xmlStmt, (Object[])null));
                        this._pdqStaticSDs.put((String)getProcessedSql.invoke(sd, (Object[])null), sd);
                    }
                }
                catch (Exception e) {
                    try {
                        log.error((Object)_loc.get("pdq-xml-load-error", new Object[]{this.puNameXml, e.getCause()}));
                    }
                    catch (Throwable throwable) {
                        ins.close();
                        if (log.isTraceEnabled()) {
                            log.trace((Object)_loc.get("pdq-xml-load-ok", new Object[]{this.puNameXml}));
                        }
                        throw throwable;
                    }
                    ins.close();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)_loc.get("pdq-xml-load-ok", new Object[]{this.puNameXml}));
                    }
                    break block15;
                }
                ins.close();
                if (log.isTraceEnabled()) {
                    log.trace((Object)_loc.get("pdq-xml-load-ok", new Object[]{this.puNameXml}));
                }
            }
            catch (Exception e) {
                log.error((Object)_loc.get("pdq-xml-load-error", new Object[]{this.puNameXml, e.getMessage()}));
                return;
            }
        }
    }

    public synchronized Object getStaticStatementDescriptor(String sql) {
        if (this._pdqStaticSDs == null) {
            return null;
        }
        return this._pdqStaticSDs.get(sql);
    }

    public void verifyProductVersion() {
        Log log = this.getConfiguration().getLog("wsjpa.pdq");
        String productName = ((DB2Dictionary)this.getDBDictionary()).getProductName();
        String productVersion = ((DB2Dictionary)this.getDBDictionary()).getProductVersion();
        if (this.xmlProductName != null && this.xmlProductVersion != null && productName != null && !((DB2Dictionary)this.getDBDictionary()).verifyProductVersion(this.xmlProductName, this.xmlProductVersion)) {
            log.warn((Object)_loc.get("pdq-dbversion", new Object[]{productName, productVersion, this.puNameXml}));
        }
    }

    static {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            XmlReader = Class.forName("com.ibm.pdq.runtime.internal.xml.PDQXmlReader", false, loader);
            getPDQXml = XmlReader.getMethod("getPDQXml", null);
            parseStream = XmlReader.getMethod("parseStream", InputStream.class);
            getStatements = XmlReader.getMethod("getStatements", null);
            pdqXml = Class.forName("com.ibm.pdq.runtime.internal.xml.PDQXml", false, loader);
            getDbProductName = pdqXml.getMethod("getDbProductName", null);
            getDbProductVersion = pdqXml.getMethod("getDbProductVersion", null);
            xmlStatement = Class.forName("com.ibm.pdq.runtime.internal.xml.PDQXmlStatement", false, loader);
            getPDQXmlStatementDescriptor = xmlStatement.getMethod("getPDQXmlStatementDescriptor", null);
            xmlStatementDescriptor = Class.forName("com.ibm.pdq.runtime.internal.xml.PDQXmlStatementDescriptor", false, loader);
            createStatementDescriptorForRuntime = XmlReader.getMethod("createStatementDescriptorForRuntime", xmlStatementDescriptor);
            getPackageInfo = xmlStatementDescriptor.getMethod("getPackageInfo", null);
            xmlPackage = Class.forName("com.ibm.pdq.runtime.internal.xml.PDQXmlPackage", false, loader);
            setCollectionName = xmlPackage.getMethod("setCollectionName", String.class);
            statementDescriptor = Class.forName("com.ibm.pdq.runtime.statement.StatementDescriptor", false, loader);
            getProcessedSql = statementDescriptor.getMethod("getProcessedSql", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

