/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.conf;

import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticConstraintUpdateManager;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticJDBCSeqValue;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticOperationOrderUpdateManager;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticPessimisticLockManager;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticSQLFactoryImpl;
import com.ibm.ws.persistence.pdqstatic.kernel.StaticBrokerImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.datacache.DataCacheManagerImpl;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.LockManager;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.LogFactory;

public class StaticJDBCConfigurationImpl
extends JDBCConfigurationImpl {
    public static final String LOG_SQLGEN = "wsjpa.Sqlgen";
    private LogFactory _logFactory = null;
    private Boolean _foundFFDC = null;
    private Class FFDC = null;

    public StaticJDBCConfigurationImpl() {
    }

    public StaticJDBCConfigurationImpl(boolean loadGlobals) {
        super(loadGlobals);
    }

    public StaticJDBCConfigurationImpl(boolean derivations, boolean loadGlobals) {
        super(derivations, loadGlobals);
    }

    public StaticJDBCConfigurationImpl(JDBCConfiguration conf) {
        super(conf);
    }

    public BrokerImpl newBrokerInstance(String user, String pass) {
        StaticBrokerImpl broker = new StaticBrokerImpl();
        broker.setAuthentication(user, pass);
        return broker;
    }

    public LockManager newLockManagerInstance() {
        if (this.getLockManager().startsWith("pessimistic")) {
            return new StaticPessimisticLockManager();
        }
        return (LockManager)this.lockManagerPlugin.instantiate(LockManager.class, (Configuration)this, false);
    }

    public DataCacheManager getDataCacheManagerInstance() {
        return new DataCacheManagerImpl();
    }

    public Map getQueryCompilationCacheInstance() {
        return new HashMap();
    }

    public void configureStaticPlugins() {
        this.setSeqPlugin();
        this.setDataCachePlugin();
        this.setQueryCompilationCachePlugin();
        this.setSynchronizeMappingsPlugin();
        String updateMgr = this.getUpdateManager().toLowerCase();
        if (updateMgr.indexOf("constraint") != -1 || updateMgr.indexOf("default") != -1) {
            this.setUpdateManager(StaticConstraintUpdateManager.class.getCanonicalName());
        } else if (updateMgr.indexOf("operation") != -1) {
            this.setUpdateManager(StaticOperationOrderUpdateManager.class.getCanonicalName());
        }
        this.setSQLFactory(StaticSQLFactoryImpl.class.getCanonicalName());
        this.metaRepositoryPlugin.setAlias("default", StaticMappingRepository.class.getCanonicalName());
        this.setMetaDataRepository(StaticMappingRepository.class.getCanonicalName());
        this.setTransactionModePlugin();
        this.setConnectionFactoryName(null);
    }

    protected void setSeqPlugin() {
        this.seqPlugin.setAliases(StaticJDBCSeqValue.ALIASES);
        this.seqPlugin.setDefault(StaticJDBCSeqValue.ALIASES[0]);
        this.seqPlugin.setString(StaticJDBCSeqValue.ALIASES[0]);
    }

    protected void setDataCachePlugin() {
        String[] aliases = new String[]{"false", null};
        this.dataCachePlugin.setAliases(aliases);
        this.dataCachePlugin.setDefault(aliases[0]);
        this.dataCachePlugin.setString(aliases[0]);
    }

    protected void setQueryCompilationCachePlugin() {
        String[] aliases = new String[]{"false", null};
        this.queryCompilationCachePlugin.setAliases(aliases);
        this.queryCompilationCachePlugin.setDefault(aliases[0]);
        this.queryCompilationCachePlugin.setString(aliases[0]);
    }

    protected void setSynchronizeMappingsPlugin() {
        String value = "buildSchema";
        this.synchronizeMappings = this.addString("jdbc.SynchronizeMappings");
        String[] aliases = new String[]{"true", value};
        this.synchronizeMappings.setAliases(aliases);
        this.synchronizeMappings.setDefault(aliases[0]);
        this.setSynchronizeMappings(value);
    }

    public void setTransactionModePlugin() {
        this.setTransactionMode(this.transactionMode.getDefault());
        this.setConnectionFactoryMode(this.connectionFactoryMode.getDefault());
    }

    public LogFactory getLogFactory() {
        if (this.foundFFDC()) {
            return super.getLogFactory();
        }
        if (this._logFactory == null) {
            this._logFactory = super.getLogFactory();
        }
        return this._logFactory;
    }

    private boolean foundFFDC() {
        if (this._foundFFDC == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                this.FFDC = Class.forName("com.ibm.ffdc.Manager", false, loader);
                this._foundFFDC = true;
            }
            catch (Exception e) {
                this._foundFFDC = false;
            }
        }
        return this._foundFFDC;
    }
}

