/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSelectStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticUpdateStmt;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import java.util.Collection;
import java.util.Iterator;
import javax.persistence.EntityManager;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

public class StaticDeleteStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticDeleteStmt.class);

    public StaticDeleteStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
    }

    @Override
    public void generate() {
        this.deleteEntities();
        this.deleteCircularEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEntities() {
        StaticSelectStmt selectStmt = new StaticSelectStmt(this.em, this.bindInfo, this._logs);
        Collection entities = selectStmt.getEntities();
        Iterator iter = entities.iterator();
        while (iter.hasNext()) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
            this.em.getTransaction().begin();
            Object entity = iter.next();
            String entityClassName = entity.getClass().getName();
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            this.metaRepo.setRuntimeSignatureInfo(entityClassName + ":Remove", new StaticMappingRepository.RuntimeInfo(entityClassName, entityClassName, entityClassName, "Remove", this.em, null));
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)_loc.get("remove-entity", (Object)entityClassName));
            }
            try {
                if (!StaticSQLGenUtil.removeFlush(this.em, entity, this._logs)) {
                    StaticSQLGenUtil.rollback(this.em, this._logs);
                    continue;
                }
            }
            finally {
                this.metaRepo.setRuntimeSignatureInfo(null, null);
                continue;
            }
            StaticSQLGenUtil.commit(this.em, this._logs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCircularEntities() {
        StaticUpdateStmt updateStmt = new StaticUpdateStmt(this.em, this.bindInfo, this._logs);
        Collection circularEntities = updateStmt.getEntities();
        for (Object entity : circularEntities) {
            Boolean isDet = ((PersistenceCapable)entity).pcIsDetached();
            if (isDet != null && isDet.booleanValue()) continue;
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
            this.em.getTransaction().begin();
            String entityClassName = entity.getClass().getName();
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            this.metaRepo.setRuntimeSignatureInfo(entityClassName + ":Remove", new StaticMappingRepository.RuntimeInfo(entityClassName, entityClassName, entityClassName, "Remove", this.em, null));
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)_loc.get("remove-entity", (Object)entityClassName));
            }
            try {
                if (!StaticSQLGenUtil.remove(this.em, entity, this._logs)) {
                    StaticSQLGenUtil.rollback(this.em, this._logs);
                    continue;
                }
            }
            finally {
                this.metaRepo.setRuntimeSignatureInfo(null, null);
                continue;
            }
            StaticSQLGenUtil.commit(this.em, this._logs);
        }
    }
}

