/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.conf.StaticJDBCConfigurationImpl;
import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticConstraintUpdateManager;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;

public class StaticInsertStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticInsertStmt.class);

    public StaticInsertStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
    }

    @Override
    public void generate() {
        this.createEntities();
    }

    /*
     * WARNING - void declaration
     */
    public List createEntities() {
        this.em.clear();
        ArrayList<WrappedEntity> entities = new ArrayList<WrappedEntity>();
        ArrayList<Object> persistEntities = new ArrayList<Object>();
        HashMap<WrappedEntity, ClassMapping> entity2Clm = new HashMap<WrappedEntity, ClassMapping>();
        HashMap<ClassMapping, WrappedEntity> clm2Entity = new HashMap<ClassMapping, WrappedEntity>();
        HashMap<Object, Object[]> failedEntities = new HashMap<Object, Object[]>();
        ArrayList<ClassMapping> entitiesToBeCreated = new ArrayList<ClassMapping>();
        for (int i = 0; i < this.clms.length; ++i) {
            if (this.clms[i].isEmbeddedOnly()) continue;
            Class cls = this.clms[i].getDescribedType();
            String entityClassName = cls.getName();
            int n = cls.getModifiers();
            boolean isAbstract = Modifier.isAbstract(n);
            boolean isInterface = Modifier.isInterface(n);
            if (isAbstract || isInterface) continue;
            entitiesToBeCreated.add(this.clms[i]);
            FieldMetaData[] pks = this.clms[i].getPrimaryKeyFields();
            if (this.clms[i].getIdentityType() != 2 || this.clms[i].isOpenJPAIdentity() && pks[0].getDeclaredTypeCode() == 29) continue;
            entitiesToBeCreated.add(this.clms[i]);
        }
        for (ClassMapping clm : entitiesToBeCreated) {
            void var10_16;
            Class cls = clm.getDescribedType();
            Object var10_13 = null;
            try {
                Object t = cls.newInstance();
            }
            catch (Exception e) {
                try {
                    Object object = StaticSQLGenUtil.constructObjFromClass(cls, this._logs);
                }
                catch (Exception ex) {
                    StaticSQLGenUtil.printException(this._logs, ex);
                }
            }
            if (var10_16 == null) continue;
            FieldMapping[] allPKFields = (FieldMapping[])clm.getPrimaryKeyFields();
            FieldMapping[] fields = (FieldMapping[])clm.getFields();
            try {
                StaticSQLGenUtil.setPrimaryKey(allPKFields, var10_16, this._logs);
            }
            catch (Exception e) {
                failedEntities.put(var10_16, new Object[]{fields, clm});
                continue;
            }
            if (!StaticSQLGenUtil.setNonNullableFields((FieldMetaData[])fields, var10_16, this._logs)) continue;
            StaticSQLGenUtil.setExternalStringFields(fields, var10_16, this._logs);
            WrappedEntity wEntity = new WrappedEntity(var10_16);
            entities.add(wEntity);
            entity2Clm.put(wEntity, clm);
            clm2Entity.put(clm, wEntity);
        }
        boolean usingConstraintUpateManager = false;
        StaticJDBCConfigurationImpl conf = (StaticJDBCConfigurationImpl)((EntityManagerImpl)this.em).getConfiguration();
        if (conf.getUpdateManagerInstance() instanceof StaticConstraintUpdateManager) {
            usingConstraintUpateManager = true;
        }
        for (Object e : entities) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
            this.em.getTransaction().begin();
            WrappedEntity wEntity = (WrappedEntity)e;
            ClassMapping clm = (ClassMapping)entity2Clm.get(wEntity);
            Class cls = clm.getDescribedType();
            String entityClassName = cls.getName();
            if (usingConstraintUpateManager) {
                this.setRelationFields(wEntity, entity2Clm, clm2Entity);
            }
            FieldMapping[] fields = (FieldMapping[])clm.getFields();
            this.metaRepo.setRuntimeSignatureInfo(entityClassName + ":Create", new StaticMappingRepository.RuntimeInfo(entityClassName, entityClassName, entityClassName, "Persist", this.em, null));
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)_loc.get("add-entity", (Object)entityClassName));
            }
            if (!StaticSQLGenUtil.persist(this.em, wEntity.entity, this._logs)) {
                failedEntities.put(wEntity.entity, new Object[]{fields, clm});
                this.em.getTransaction().rollback();
                continue;
            }
            StaticSQLGenUtil.setVersion(clm, wEntity.entity, this._logs);
            persistEntities.add(wEntity.entity);
            StaticSQLGenUtil.flush(this.em, this._logs);
            StaticSQLGenUtil.commit(this.em, this._logs);
        }
        if (failedEntities.size() > 0) {
            this.persistFailedObj(failedEntities, persistEntities);
        }
        return entities;
    }

    private void persistFailedObj(Map failedEntities, List managedEntities) {
        int failedCount = failedEntities.size();
        HashMap failedEntities1 = new HashMap();
        Set failedObjs = failedEntities.keySet();
        Iterator iter = failedObjs.iterator();
        while (iter.hasNext()) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().commit();
            }
            this.em.getTransaction().begin();
            Object failedObj = iter.next();
            String failedEntityClassName = failedObj.getClass().getName();
            Object[] entityInfo = (Object[])failedEntities.get(failedObj);
            FieldMetaData[] fmd = (FieldMetaData[])entityInfo[0];
            ClassMapping clm = (ClassMapping)entityInfo[1];
            if (!StaticSQLGenUtil.setNonNullableFields(failedObj, fmd, managedEntities, this._logs)) continue;
            this.metaRepo.setRuntimeSignatureInfo(failedEntityClassName + ":Create", new StaticMappingRepository.RuntimeInfo(failedEntityClassName, failedEntityClassName, failedEntityClassName, "Persist", this.em, null));
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(failedEntityClassName);
            }
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)_loc.get("add-entity", (Object)failedEntityClassName));
            }
            if (!StaticSQLGenUtil.persistFlush(this.em, failedObj, this._logs)) {
                failedEntities1.put(failedObj, entityInfo);
                StaticSQLGenUtil.rollback(this.em, this._logs);
                continue;
            }
            StaticSQLGenUtil.setVersion(clm, failedObj, this._logs);
            StaticSQLGenUtil.flush(this.em, this._logs);
            StaticSQLGenUtil.commit(this.em, this._logs);
            managedEntities.add(failedObj);
        }
        if (failedEntities1.size() == 0 || failedEntities1.size() == failedCount) {
            return;
        }
        this.persistFailedObj(failedEntities1, managedEntities);
    }

    private void setRelationFields(WrappedEntity wEntity, Map<WrappedEntity, ClassMapping> entity2Clm, Map<ClassMapping, WrappedEntity> clm2Entity) {
        ClassMapping clm = entity2Clm.get(wEntity);
        FieldMapping[] fms = clm.getFieldMappings();
        for (int i = 0; i < fms.length; ++i) {
            ClassMapping rClm = fms[i].getDeclaredTypeMapping();
            WrappedEntity rEntity = clm2Entity.get(rClm);
            if (rEntity == null) continue;
            StaticSQLGenUtil.setField((FieldMetaData)fms[i], wEntity.entity, this._logs, rEntity.entity);
        }
    }

    private static class WrappedEntity {
        public Object entity;

        public WrappedEntity(Object entity) {
            this.entity = entity;
        }
    }
}

