/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.pdqstatic.conf.StaticJDBCConfigurationImpl;
import com.ibm.ws.persistence.pdqstatic.gen.StaticDeleteStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticInsertStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSelectStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticUpdateStmt;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticJDBCBrokerFactory;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticDB2Dictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticInformixDictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticOracleDictionary;
import com.ibm.ws.persistence.pdqstatic.kernel.StaticBrokerImpl;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DB2Dictionary;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.InformixDictionary;
import org.apache.openjpa.jdbc.sql.OracleDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.PersistenceProviderImpl;

public class StaticSQLGenerator {
    private EntityManagerFactoryImpl emf = null;
    private EntityManager em = null;
    private StaticJDBCConfigurationImpl conf = null;
    private Log _logs = null;
    private String url = null;
    private String userName = null;
    private String pwd = null;
    private BindInfo bindInfo = new BindInfo();
    protected ClassMapping[] clms = null;

    public StaticSQLGenerator(String puName, String collectionId, String urlString, String user, String password, boolean singlePackage, String packageName) throws Exception {
        this.bindInfo.puName = puName;
        this.bindInfo.collectionId = collectionId;
        this.bindInfo.singlePackage = singlePackage;
        this.bindInfo.packageName = packageName;
        this.url = urlString;
        this.userName = user;
        this.pwd = password;
        this.init(puName);
    }

    private void init(String puName) throws Exception {
        HashMap<Object, Object> props = new HashMap<Object, Object>(System.getProperties());
        props.put("openjpa.BrokerFactory", StaticJDBCBrokerFactory.class.getName());
        props.put("openjpa.BrokerImpl", StaticBrokerImpl.class.getName());
        PersistenceProviderImpl provider = new PersistenceProviderImpl();
        this.emf = (EntityManagerFactoryImpl)provider.createEntityManagerFactory(puName, props);
        if (this.emf == null) {
            System.out.println("puName " + puName + " is invalid.");
            System.exit(1);
        }
        this.conf = (StaticJDBCConfigurationImpl)this.emf.getBrokerFactory().getConfiguration();
        this.setURL();
        DBDictionary dbDictionary = this.conf.getDBDictionaryInstance();
        if (dbDictionary instanceof DB2Dictionary) {
            this.conf.dbdictionaryPlugin.setClassName(StaticDB2Dictionary.class.getCanonicalName());
        } else if (dbDictionary instanceof InformixDictionary) {
            this.conf.dbdictionaryPlugin.setClassName(StaticInformixDictionary.class.getCanonicalName());
            this.conf.setConnectionDriverName("com.ibm.db2.jcc.DB2Driver");
        } else if (dbDictionary instanceof OracleDictionary) {
            this.conf.dbdictionaryPlugin.setClassName(StaticOracleDictionary.class.getCanonicalName());
        } else {
            throw new Exception("Unsupported database");
        }
        this._logs = this.conf.getLog("wsjpa.Sqlgen");
    }

    public void setURL() {
        if (this.url == null) {
            return;
        }
        System.out.println("url from user is " + this.url);
        if (this.url.startsWith("jdbc:db2")) {
            this.setDB2URL();
        } else {
            this.conf.setConnectionURL(this.url);
        }
        this.conf.setConnectionUserName(this.userName);
        this.conf.setConnectionPassword(this.pwd);
    }

    private void setDB2URL() {
        HashMap<String, String> connectionProperties = null;
        String urlData = this.url.substring("jdbc:db2:".length());
        connectionProperties = urlData.indexOf("/") == -1 ? this.processDB2Type2JDBCURL(urlData) : this.processDB2Type4JDBCURL(urlData);
        StringBuffer confSB = new StringBuffer();
        for (String key : connectionProperties.keySet()) {
            String value = connectionProperties.get(key);
            if (confSB.length() != 0) {
                confSB.append(", ");
            }
            confSB.append(key).append('=').append(value);
        }
        this.conf.setConnectionProperties(new String(confSB));
        this.conf.setConnectionDriverName("com.ibm.db2.jcc.DB2SimpleDataSource");
        System.out.println("URL from user is " + this.url);
        System.out.println("ConnectionProperties: " + new String(confSB));
    }

    private HashMap<String, String> processDB2Type2JDBCURL(String urlData) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("DriverType", "2");
        int jdbcPropertiesIndex = urlData.indexOf(58);
        if (jdbcPropertiesIndex == -1) {
            returnMap.put("DatabaseName", urlData);
        } else {
            returnMap.put("DatabaseName", urlData.substring(0, jdbcPropertiesIndex));
            this.processDB2JDBCProperties(urlData.substring(jdbcPropertiesIndex + 1), returnMap);
        }
        return returnMap;
    }

    private HashMap<String, String> processDB2Type4JDBCURL(String urlData) {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        urlData = urlData.substring(2);
        int dbNameIdx = urlData.indexOf("/");
        String type4Info = urlData.substring(0, dbNameIdx);
        int portIdx = type4Info.indexOf(":");
        returnMap.put("ServerName", type4Info.substring(0, portIdx));
        returnMap.put("PortNumber", type4Info.substring(portIdx + 1));
        returnMap.put("DriverType", "4");
        String dbName = urlData.substring(dbNameIdx + 1);
        int jdbcPropertiesIndex = dbName.indexOf(58);
        if (jdbcPropertiesIndex == -1) {
            returnMap.put("DatabaseName", dbName);
        } else {
            returnMap.put("DatabaseName", dbName.substring(0, jdbcPropertiesIndex));
            this.processDB2JDBCProperties(dbName.substring(jdbcPropertiesIndex + 1), returnMap);
        }
        return returnMap;
    }

    private void processDB2JDBCProperties(String jdbcPropertyStr, HashMap<String, String> returnMap) {
        jdbcPropertyStr = jdbcPropertyStr.trim();
        ArrayList<String> propertiesList = new ArrayList<String>();
        int cIndex = -1;
        while ((cIndex = jdbcPropertyStr.indexOf(59)) != -1) {
            propertiesList.add(jdbcPropertyStr.substring(0, cIndex));
            jdbcPropertyStr = jdbcPropertyStr.substring(cIndex + 1);
        }
        if (jdbcPropertyStr.length() != 0) {
            System.err.println("FATAL ERROR: TERMINATING \";\" CHARACTER IS MISSING FROM THE JDBC PROPERTIES SPECIFIED IN THE JDBC URL.");
            System.exit(-1);
        }
        for (String property : propertiesList) {
            String propName = "";
            String propValue = "";
            int valIndex = property.indexOf("=");
            if (valIndex != -1) {
                propName = property.substring(0, valIndex);
                propValue = property.substring(valIndex + 1);
            }
            if (valIndex == -1 || propName.length() == 0 || propValue.length() == 0) {
                StringBuffer errMsgSB = new StringBuffer();
                errMsgSB.append("FATAL ERROR: BAD JDBC PROPERTY ENTRY ");
                errMsgSB.append('\"').append(property).append('\"');
                errMsgSB.append(" ENCOUNTERED");
                if (valIndex == -1) {
                    errMsgSB.append(" (Missing '=' separating property ");
                    errMsgSB.append("name and value)");
                } else if (propName.length() == 0) {
                    errMsgSB.append(" (Missing property name)");
                } else if (propValue.length() == 0) {
                    errMsgSB.append(" (Missing property value)");
                }
                System.err.println(new String(errMsgSB));
                System.exit(-1);
            }
            returnMap.put(propName, propValue);
        }
    }

    public void generateSQL() {
        this.em = this.emf.createEntityManager();
        this.loadPersistenceEntities();
        StaticInsertStmt insertStmt = new StaticInsertStmt(this.em, this.bindInfo, this._logs);
        insertStmt.generate();
        StaticDeleteStmt deleteStmt = new StaticDeleteStmt(this.em, this.bindInfo, this._logs);
        deleteStmt.generate();
        StaticUpdateStmt updateStmt = new StaticUpdateStmt(this.em, this.bindInfo, this._logs);
        updateStmt.generate();
        StaticSelectStmt selectStmt = new StaticSelectStmt(this.em, this.bindInfo, this._logs);
        selectStmt.generate();
        this.em.close();
    }

    private void loadPersistenceEntities() {
        StaticMappingRepository metaRepo = (StaticMappingRepository)this.conf.getMetaDataRepositoryInstance();
        Collection persistentTypes = metaRepo.loadPersistentTypes(false, null);
        for (Class cls : persistentTypes) {
            if (cls == null) continue;
            metaRepo.getMetaDataFactory().load(cls, 5, null);
        }
        metaRepo.setPU(this.bindInfo.puName);
        metaRepo.setSinglePackage(this.bindInfo.singlePackage);
        if (this.bindInfo.packageName != null) {
            metaRepo.setPkgName(this.bindInfo.packageName);
        }
        if (this.bindInfo.collectionId != null) {
            metaRepo.setCollection(this.bindInfo.collectionId);
        }
        this.clms = metaRepo.getMappings();
    }

    public PDQMetas getPDQMetas() {
        StaticMappingRepository metaRepo = (StaticMappingRepository)((EntityManagerImpl)this.em).getConfiguration().getMetaDataRepositoryInstance();
        return metaRepo.getPDQMetas();
    }

    public List<String> checkMisplacedSQL() {
        StaticMappingRepository metaRepo = (StaticMappingRepository)((EntityManagerImpl)this.em).getConfiguration().getMetaDataRepositoryInstance();
        Map<String, String> package2entityMap = metaRepo.getPackage2EntityMap();
        Map<String, List<String>> package2SqlMap = metaRepo.getPackage2SqlMap();
        HashMap<String, String> entityClassName2TableMap = new HashMap<String, String>();
        for (int i = 0; i < this.clms.length; ++i) {
            int modifiers = this.clms[i].getDescribedType().getModifiers();
            if (Modifier.isAbstract(modifiers)) continue;
            String entityName = this.clms[i].getDescribedType().getName();
            Table tbl = this.clms[i].getTable();
            if (tbl == null) continue;
            String tableName = tbl.getFullIdentifier().getName();
            entityClassName2TableMap.put(entityName, tableName);
        }
        ArrayList<String> err = new ArrayList<String>();
        Set<String> pkgs = package2entityMap.keySet();
        for (String pkg : pkgs) {
            List<String> sqls;
            String entityName;
            String tableName;
            if (pkg.equals(StaticMappingRepository.SEQ_PKG_NAME) || pkg.equals(StaticMappingRepository.NAMED_QUERY_PKG_NAME) || (tableName = (String)entityClassName2TableMap.get(entityName = package2entityMap.get(pkg))) == null || (sqls = package2SqlMap.get(pkg)) == null) continue;
            this.assertSQLFragnments(pkg, sqls, err, "INSERT INTO " + tableName);
            this.assertSQLFragnments(pkg, sqls, err, "UPDATE " + tableName);
            this.assertSQLFragnments(pkg, sqls, err, "DELETE FROM " + tableName);
            this.assertSQLFragnments(pkg, sqls, err, "SELECT ", "FROM " + tableName);
        }
        return err;
    }

    void assertSQLFragnments(String pkg, List<String> list, List<String> err, String ... keys) {
        if (this.match(list, keys)) {
            return;
        }
        err.add("None of the following " + list.size() + " SQL \r\n" + this.listToString(list) + "in package " + pkg + " contains all keys \r\n" + this.listToString(Arrays.asList(keys)));
    }

    boolean match(List<String> SQLs, String ... keys) {
        if (SQLs == null || keys == null) {
            return false;
        }
        for (String sql : SQLs) {
            boolean matched = true;
            for (String key : keys) {
                if (sql.indexOf(key) != -1) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    String listToString(List<String> list) {
        StringBuffer buf = new StringBuffer();
        for (String s : list) {
            buf.append(s).append("\r\n");
        }
        return buf.toString();
    }

    public Log getLog() {
        return this._logs;
    }

    class BindInfo {
        public String puName = null;
        public String collectionId = null;
        public boolean singlePackage = false;
        public String packageName = null;

        BindInfo() {
        }
    }
}

