/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.gen;

import com.ibm.ws.persistence.pdqstatic.conf.StaticJDBCConfigurationImpl;
import com.ibm.ws.persistence.pdqstatic.gen.StaticAbstractSQLStmt;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenerator;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import org.apache.openjpa.jdbc.kernel.JDBCStoreManager;
import org.apache.openjpa.jdbc.kernel.SQLStoreQuery;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.OrderedMap;
import org.apache.openjpa.meta.MetaDataFactory;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.persistence.EntityManagerImpl;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.persistence.QueryOperationType;
import org.apache.openjpa.util.UserException;

public class StaticSelectStmt
extends StaticAbstractSQLStmt {
    private static final Localizer _loc = Localizer.forPackage(StaticSelectStmt.class);
    protected Map<String, List> updatableFieldsMap = new HashMap<String, List>();
    protected Map<String, Map> pkSettersMap = new HashMap<String, Map>();
    protected int[] lockMode = new int[]{3, 2, 3};

    public StaticSelectStmt(EntityManager em, StaticSQLGenerator.BindInfo bindInfo, Log _logs) {
        super(em, bindInfo, _logs);
        if (this.updatableFieldsMap.size() == 0) {
            StaticSQLGenUtil.findUpdatableFields(this.clms, this.updatableFieldsMap, this.pkSettersMap);
        }
    }

    @Override
    public void generate() {
        this.generateSelectSQL();
        this.generateNamedQueryStmt();
    }

    private void generateSelectSQL() {
        this.em.clear();
        this.em.getTransaction().begin();
        Collection entities = this.getEntities();
        try {
            for (Object entity : entities) {
                String entityClassName = entity.getClass().getName();
                if (!this.bindInfo.singlePackage) {
                    this.metaRepo.setPkgName(entityClassName);
                }
                this.invokeGetters(entity);
            }
            StaticSQLGenUtil.commit(this.em, this._logs);
        }
        catch (Exception e) {
            StaticSQLGenUtil.rollback(this.em, this._logs);
        }
    }

    private void invokeGetters(Object entity) {
        Class<?> entityClass = entity.getClass();
        Method[] methods = entityClass.getMethods();
        List fieldsToUpdate = this.updatableFieldsMap.get(entityClass.getName());
        if (fieldsToUpdate == null) {
            return;
        }
        ArrayList pcGetMethods = new ArrayList();
        ArrayList getMethods = new ArrayList();
        StaticSQLGenUtil.getMethods(entity, pcGetMethods, getMethods, true, fieldsToUpdate);
        this.invokeGetters(entity, pcGetMethods, true);
        if (getMethods.size() != 0) {
            this.invokeGetters(entity, getMethods, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeGetters(Object entity, List methods, boolean isPCGet) {
        Class<?> cls = entity.getClass();
        for (Method getMethod : methods) {
            String getter = getMethod.getName();
            String entityClassName = cls.getName();
            this.metaRepo.setRuntimeSignatureInfo(entityClassName + ":" + getter, new StaticMappingRepository.RuntimeInfo(entityClassName, entityClassName, entityClassName, getter, this.em, null));
            try {
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace((Object)_loc.get("retrieve-entity", (Object)(cls.getName() + "." + getter)));
                }
                getMethod.setAccessible(true);
                if (isPCGet) {
                    getMethod.invoke(null, entity);
                    continue;
                }
                getMethod.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
            }
            finally {
                this.metaRepo.setRuntimeSignatureInfo(null, null);
            }
        }
    }

    private void generateNamedQueryStmt() {
        this.em.getTransaction().begin();
        for (int i = 0; i < this.lockMode.length; ++i) {
            this.generateNamedQueryStmt(this.lockMode[i], true);
            this.generateNamedQueryStmt(this.lockMode[i], false);
        }
        StaticSQLGenUtil.rollback(this.em, this._logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateNamedQueryStmt(int lockMode, boolean getSingleResult) {
        MetaDataFactory _factory = this.metaRepo.getMetaDataFactory();
        ClassLoader envLoader = ((EntityManagerImpl)this.em).getBroker().getClassLoader();
        Class cls = null;
        for (int i = 0; i < this.clms.length; ++i) {
            if (this.clms[i].isEmbeddedOnly()) continue;
            cls = this.clms[i].getDescribedType();
            break;
        }
        _factory.load(cls, 4, envLoader);
        QueryMetaData[] queries = this.metaRepo.getQueryMetaDatas();
        QueryMetaData query = null;
        this.metaRepo.setSignatureNamedQueryMetaData(null, null);
        Map cls2EntitiesMap = this.getCls2Entities();
        for (int j = 0; j < queries.length; ++j) {
            String queryName;
            block36: {
                query = queries[j];
                queryName = query.getName();
                this.metaRepo.setSignatureNamedQueryMetaData(query.getSourceScope() + ":NamedQuery:" + queryName, query);
                if (!this.bindInfo.singlePackage) {
                    this.metaRepo.setPkgName(StaticMappingRepository.NAMED_QUERY_PKG_NAME);
                }
                if (query.getLanguage().equals("openjpa.SQL")) {
                    StaticJDBCConfigurationImpl conf = (StaticJDBCConfigurationImpl)this.metaRepo.getConfiguration();
                    Broker broker = ((EntityManagerImpl)this.em).getBroker();
                    JDBCStoreManager store = (JDBCStoreManager)broker.getStoreManager().getDelegate();
                    Connection con = store.getConnection();
                    String sql = query.getQueryString();
                    if (sql.substring(0, 6).equalsIgnoreCase("call ")) continue;
                    Statement pstmt = null;
                    try {
                        sql = this.fixParameterMarkers(sql);
                        pstmt = con.prepareStatement(sql);
                        this.metaRepo.createPDQMeta(sql, (PreparedStatement)pstmt, -1, false);
                        continue;
                    }
                    catch (SQLException e) {
                        StaticSQLGenUtil.printException(this._logs, e);
                        continue;
                    }
                    finally {
                        try {
                            if (pstmt != null) {
                                pstmt.close();
                            }
                        }
                        catch (SQLException e) {}
                    }
                }
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace((Object)("Start generating SQL for " + queryName));
                }
                QueryImpl q = (QueryImpl)this.em.createNamedQuery(queryName);
                if (lockMode == 1) {
                    q.getFetchPlan().setReadLockMode(LockModeType.READ);
                } else if (lockMode == 2) {
                    q.getFetchPlan().setReadLockMode(LockModeType.WRITE);
                }
                OrderedMap types = q.getDelegate().getOrderedParameterTypes();
                int size = types.size();
                for (Object parmName : types.keySet()) {
                    Class clss = (Class)types.get(parmName);
                    Object parmObj = cls2EntitiesMap.get(clss);
                    if (parmObj == null) {
                        try {
                            parmObj = StaticSQLGenUtil.constructObjFromClass(clss, this._logs);
                        }
                        catch (Exception e) {
                            StaticSQLGenUtil.printException(this._logs, e);
                            continue;
                        }
                    }
                    if (parmName instanceof Integer) {
                        q.setParameter(((Integer)parmName).intValue(), parmObj);
                        continue;
                    }
                    q.setParameter(parmName.toString(), parmObj);
                }
                if (q.getOperation() != QueryOperationType.SELECT) {
                    try {
                        q.executeUpdate();
                    }
                    catch (Exception e) {
                        StaticSQLGenUtil.printException(this._logs, e);
                    }
                } else {
                    if (getSingleResult) {
                        try {
                            q.getSingleResult();
                        }
                        catch (Exception e) {
                            if (!(e instanceof NoResultException)) {
                                StaticSQLGenUtil.printException(this._logs, e);
                            }
                            break block36;
                        }
                    }
                    try {
                        q.getResultList();
                    }
                    catch (Exception e) {
                        if (e instanceof NoResultException) break block36;
                        StaticSQLGenUtil.printException(this._logs, e);
                    }
                }
            }
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)("Done generating SQL for " + queryName));
            }
            this.metaRepo.setSignatureNamedQueryMetaData(null, null);
        }
    }

    public Collection getEntities() {
        Map cls2EntitiesMap = this.getCls2Entities();
        return cls2EntitiesMap.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCls2Entities() {
        this.em.clear();
        HashMap<Class, Object> cls2EntitiesMap = new HashMap<Class, Object>();
        for (int i = 0; i < this.clms.length; ++i) {
            ClassMapping clm = this.clms[i];
            if (this.clms[i].isEmbeddedOnly()) continue;
            Class cls = this.clms[i].getDescribedType();
            String entityClassName = cls.getName();
            if (!this.bindInfo.singlePackage) {
                this.metaRepo.setPkgName(entityClassName);
            }
            Object pkObj = null;
            try {
                pkObj = StaticSQLGenUtil.getPrimaryKeyObj(clm, this._logs);
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                continue;
            }
            if (pkObj == null) continue;
            this.metaRepo.setRuntimeSignatureInfo(entityClassName + ":find", new StaticMappingRepository.RuntimeInfo(entityClassName, entityClassName, entityClassName, "Find", this.em, this.clms[i]));
            if (this._logs.isTraceEnabled()) {
                this._logs.trace((Object)("Start generating SQL for " + entityClassName + ":find"));
            }
            try {
                Object entity = this.em.find(cls, pkObj);
                cls2EntitiesMap.put(cls, entity);
                StaticSQLGenUtil.setVersion(this.clms[i], entity, this._logs);
                continue;
            }
            catch (Exception e) {
                StaticSQLGenUtil.printException(this._logs, e);
                continue;
            }
            finally {
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace((Object)("Done generating SQL for " + entityClassName + ":find"));
                }
                this.metaRepo.setRuntimeSignatureInfo(null, null);
            }
        }
        return cls2EntitiesMap;
    }

    private String fixParameterMarkers(String sql) {
        ArrayList paramOrder = new ArrayList();
        try {
            return SQLStoreQuery.substituteParams((String)sql, paramOrder);
        }
        catch (Exception e) {
            throw new UserException(e.getLocalizedMessage());
        }
    }
}

