/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.kernel.PreparedStatementManagerImpl;
import com.ibm.ws.persistence.pdq.meta.PDQBaseData;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.jdbc.kernel.StaticOperationOrderUpdateManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Version;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.util.OpenJPAException;

public class StaticPreparedStatementManagerImpl
extends PreparedStatementManagerImpl {
    public StaticPreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit) {
        super(store, conn, batchLimit);
    }

    public void flush(RowImpl row) {
        try {
            this.flushInternal(row);
            if (this._store.getConfiguration().getUpdateManagerInstance() instanceof StaticOperationOrderUpdateManager) {
                return;
            }
            ForeignKey[] fks = row.getTable().getForeignKeys();
            if (fks == null || fks.length == 0) {
                return;
            }
            StateManagerImpl sm = (StateManagerImpl)row.getPrimaryKey();
            if (sm == null) {
                return;
            }
            int action = row.getAction();
            if (action == 2) {
                return;
            }
            RowImpl savedRow = (RowImpl)row.clone();
            savedRow.setFailedObject(row.getFailedObject());
            if (action == 0) {
                Column[] cols = row.getColumns();
                Object[] vals = row.getVals();
                HashMap<Column, Object> col2Val = new HashMap<Column, Object>();
                HashMap<Column, Integer> col2Idx = new HashMap<Column, Integer>();
                for (int i = 0; i < cols.length; ++i) {
                    col2Val.put(cols[i], vals[i]);
                    col2Idx.put(cols[i], i);
                }
                ArrayList<Column[]> fkColumns = new ArrayList<Column[]>();
                for (int i = 0; i < fks.length; ++i) {
                    fkColumns.add(fks[i].getColumns());
                }
                this.ConstraintUpdate(savedRow, fkColumns, cols, col2Val, col2Idx, true);
                this.ConstraintUpdate(savedRow, fkColumns, cols, col2Val, col2Idx, false);
            } else if (action == 1) {
                RowImpl row1 = (RowImpl)savedRow.clone();
                row1.setFailedObject(savedRow.getFailedObject());
                Object[] vals1 = row1.getVals();
                this.ConstraintInsert(row1);
            }
        }
        catch (SQLException se) {
            this._exceptions.add(SQLExceptions.getStore((SQLException)se, (DBDictionary)this._dict));
        }
        catch (OpenJPAException ke) {
            this._exceptions.add(ke);
        }
    }

    private void setNullToWhereVersionColumns(RowImpl row) {
        int whereVersionIdx = -1;
        int versionIdx = -1;
        StateManagerImpl sm = (StateManagerImpl)row.getPrimaryKey();
        ClassMapping meta = (ClassMapping)sm.getMetaData();
        Column[] cols = row.getColumns();
        Object[] vals = row.getVals();
        Version version = meta.getVersion();
        Column[] vcols = version.getColumns();
        Table versionTable = null;
        Table rowTable = row.getColumns()[0].getTable();
        if (vcols != null && vcols.length > 0) {
            for (int i = 0; i < vcols.length; ++i) {
                versionTable = vcols[i].getTable();
                if (versionTable != rowTable) continue;
                versionIdx = vcols[i].getIndex();
                whereVersionIdx = versionIdx + cols.length;
                vals[whereVersionIdx] = null;
            }
        }
    }

    private void ConstraintUpdate(RowImpl row, List<Column[]> fkColumns, Column[] cols, Map col2Val, Map<Column, Integer> col2Idx, boolean setNullToVersionColumns) throws SQLException {
        RowImpl row1 = (RowImpl)row.clone();
        row1.setFailedObject(row.getFailedObject());
        if (setNullToVersionColumns) {
            this.setNullToWhereVersionColumns(row1);
        }
        Object[] vals1 = row1.getVals();
        for (Column[] fkCols : fkColumns) {
            for (int i = 0; i < cols.length; ++i) {
                vals1[i] = null;
            }
            boolean needFlush = false;
            for (int i = 0; i < fkCols.length; ++i) {
                Object val = col2Val.get(fkCols[i]);
                int idx = col2Idx.get(fkCols[i]);
                vals1[idx] = val;
                if (val == null) continue;
                needFlush = true;
            }
            if (!needFlush) continue;
            this.flushInternal(row1);
        }
    }

    private void ConstraintInsert(RowImpl row) throws SQLException {
        ForeignKey[] fks = row.getTable().getForeignKeys();
        for (int i = 0; i < fks.length; ++i) {
            RowImpl row1 = (RowImpl)row.clone();
            row1.setFailedObject(row.getFailedObject());
            row1.clearForeignKey(fks[i]);
            this.flushInternal(row1);
        }
    }

    protected PreparedStatement prepareStatement(String sql, String[] autoAssignColNames) throws SQLException {
        sql = PDQBaseData.sort(sql, null);
        return super.prepareStatement(sql, autoAssignColNames);
    }

    protected int executeSQL(PreparedStatement stmnt, String sql, RowImpl row, Object[] verCols) throws SQLException {
        if (this._dict.supportsSelectFromFinalTable) {
            this.executeQuery(stmnt, sql, row);
        } else {
            this.executeUpdate(stmnt, sql, row);
        }
        return 1;
    }

    protected int executeUpdate(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        JDBCConfigurationImpl conf = (JDBCConfigurationImpl)this._store.getConfiguration();
        Column[] autoAssign = this.getAutoAssignColumns(row);
        String[] autoAssignColNames = this.getAutoAssignColNames(autoAssign, row);
        return StaticSQLGenUtil.executeUpdate(stmnt, sql, row.getAction(), autoAssignColNames, (JDBCConfiguration)conf, true);
    }

    @Override
    protected ResultSet executeQuery(PreparedStatement stmnt, String sql, RowImpl row) throws SQLException {
        return StaticSQLGenUtil.executeQuery(stmnt, sql, this._store.getConfiguration());
    }

    protected List<Object> populateAutoAssignCols(PreparedStatement stmnt, Column[] autoAssign, String[] autoAssignColNames, RowImpl row) {
        return Collections.EMPTY_LIST;
    }

    @Override
    protected int processResults(ResultSet rs, List autoAssignVals, List versionVals, String[] autoAssignColNames, Column[] verCols) throws SQLException {
        return 1;
    }

    @Override
    protected void setVersion(List vals, RowImpl row, Object[] cols) throws SQLException {
    }
}

