/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.meta;

import com.ibm.pdq.runtime.internal.xml.PDQXml;
import com.ibm.pdq.runtime.internal.xml.PDQXmlParameterMetaData;
import com.ibm.pdq.runtime.internal.xml.PDQXmlResultSetMetaData;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatement;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatementAttributes;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.pdq.runtime.statement.SqlStatementType;
import com.ibm.pdq.tools.DataVersion;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.pdq.meta.PDQBaseData;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepositoryUtil;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticSequenceMapping;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticPDQDictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticSelectImpl;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMeta;
import com.ibm.ws.persistence.pdqstatic.meta.PDQMetas;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.persistence.EntityManager;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.QueryMetaData;
import org.apache.openjpa.meta.SequenceMetaData;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.OpenJPAPersistence;

public class StaticMappingRepository
extends MappingRepository {
    private static final long serialVersionUID = 1L;
    private static final Localizer _loc = Localizer.forPackage(StaticMappingRepository.class);
    protected Log _logs = null;
    private PDQMetas _pdqmetas = null;
    private String _pu;
    private boolean _singlePackage = false;
    private String _pkgName = null;
    private String _collectionId = null;
    private String _runtimeSignature = null;
    private QueryMetaData _queryMeta = null;
    private RuntimeInfo _runtimeInfo = null;
    private SqlStatementType _stmtType = SqlStatementType.OTHERSQL;
    private Map<String, String> entity2packageMap = new HashMap<String, String>();
    private Map<String, String> package2entityMap = new HashMap<String, String>();
    private Map<String, Integer> packageNumMap = new HashMap<String, Integer>();
    private Map<String, List<String>> package2SqlMap = new HashMap<String, List<String>>();
    private int packageNum = 0;
    private Map<String, PDQXmlResultSetMetaData> rmdMap = new HashMap<String, PDQXmlResultSetMetaData>();
    private Map<StaticSelectImpl.StaticSelectResult, List> resMap = new HashMap<StaticSelectImpl.StaticSelectResult, List>();
    private long oldConsistencyToken = 0L;
    private int serverType = -1;
    private Map stmntMetadata = new HashMap();
    private int pdqMajorVersion = 0;
    private int pdqMinorVersion = 0;
    private boolean useOldProblemDeterminationTag = true;
    private int dbType = -1;
    private int maxPackageNameLength = 0;
    public static String SEQ_PKG_NAME = "pkgseq";
    public static String NAMED_QUERY_PKG_NAME = "NamedQ";

    public StaticMappingRepository() {
        this._pdqmetas = new PDQMetas();
        this.getPDQVersion();
    }

    public void getPDQVersion() {
        String version = DataVersion.getProductVersion();
        StringTokenizer st = new StringTokenizer(version, ".");
        ArrayList<String> versions = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            versions.add(st.nextToken());
        }
        this.pdqMajorVersion = Integer.parseInt((String)versions.get(0));
        this.pdqMinorVersion = Integer.parseInt((String)versions.get(1));
        this.useOldProblemDeterminationTag();
    }

    private int getDbType() {
        if (this.dbType == -1) {
            JDBCConfigurationImpl conf = (JDBCConfigurationImpl)this.getConfiguration();
            StaticPDQDictionary dict = (StaticPDQDictionary)conf.getDBDictionaryInstance();
            this.dbType = dict.getPlatform();
        }
        return this.dbType;
    }

    private int getMaxPackageNameLength() {
        if (this.maxPackageNameLength == 0) {
            JDBCConfigurationImpl conf = (JDBCConfigurationImpl)this.getConfiguration();
            StaticPDQDictionary dict = (StaticPDQDictionary)conf.getDBDictionaryInstance();
            this.maxPackageNameLength = dict.getMaxPackageNameLength();
        }
        return this.maxPackageNameLength;
    }

    public void useOldProblemDeterminationTag() {
        this.useOldProblemDeterminationTag = this.pdqMajorVersion == 1 || this.pdqMajorVersion == 2 && this.pdqMinorVersion == 0;
    }

    public void setPU(String pu) {
        this._pu = pu;
    }

    public String getPU() {
        return this._pu;
    }

    public void setSinglePackage(boolean singlePackage) {
        this._singlePackage = singlePackage;
    }

    public boolean getSinglePackage() {
        return this._singlePackage;
    }

    public void setCollection(String col) {
        this._collectionId = col;
    }

    public String getCollection() {
        return this._collectionId;
    }

    public void setRuntimeSignature(String signature) {
        this._runtimeSignature = signature;
    }

    public String getRuntimeSignature() {
        return this._runtimeSignature;
    }

    public void setRuntimeInfo(RuntimeInfo runtimeInfo) {
        this._runtimeInfo = runtimeInfo;
    }

    public RuntimeInfo getRuntimeInfo() {
        return this._runtimeInfo;
    }

    public void setRuntimeSignatureInfo(String signature, RuntimeInfo runtimeInfo) {
        if (this.useOldProblemDeterminationTag) {
            this.setRuntimeSignature(signature);
        } else {
            this.setRuntimeInfo(runtimeInfo);
        }
    }

    public void setNamedQueryMetaData(QueryMetaData qMeta) {
        this._queryMeta = qMeta;
    }

    public void setSignatureNamedQueryMetaData(String signature, QueryMetaData qMeta) {
        if (this.useOldProblemDeterminationTag) {
            this.setRuntimeSignature(signature);
        } else {
            this.setNamedQueryMetaData(qMeta);
        }
    }

    public QueryMetaData getNamedQueryMetaData() {
        return this._queryMeta;
    }

    public Map getStmntMetadata() {
        return this.stmntMetadata;
    }

    public void setPkgName(String entityClassName) {
        if (this._singlePackage) {
            this._pkgName = entityClassName;
            return;
        }
        String pkgName = this.entity2packageMap.get(entityClassName);
        if (pkgName == null) {
            pkgName = this.makeNewPackageName(entityClassName);
        }
        this._pkgName = pkgName;
        if (this.serverType == -1) {
            DBDictionary dict = this.getDBDictionary();
            if (dict instanceof DB2Dictionary) {
                this.serverType = ((DB2Dictionary)dict).getDb2ServerType();
            }
            if (this.serverType == 1 || this.serverType == 5) {
                SEQ_PKG_NAME = SEQ_PKG_NAME.toUpperCase();
            }
        }
        if (this.serverType == 1 || this.serverType == 5) {
            this._pkgName = this._pkgName.toUpperCase();
        }
    }

    public String makeNewPackageName(String entityName) {
        String entityName1 = entityName.substring(entityName.lastIndexOf(".") + 1);
        int maxPackageNameLength = this.getMaxPackageNameLength();
        if (entityName1.length() <= maxPackageNameLength) {
            this.entity2packageMap.put(entityName, entityName1);
            this.package2entityMap.put(entityName1, entityName);
            return entityName1;
        }
        String prefix = entityName1.substring(0, maxPackageNameLength);
        return this.makeNewPackageName1(entityName, prefix);
    }

    protected String makeNewPackageName1(String entityName, String prefix) {
        String pkgName = null;
        int pkgNum = 0;
        if (!this.packageNumMap.containsKey(prefix)) {
            pkgName = prefix;
            if (!this.package2entityMap.containsKey(pkgName)) {
                this.entity2packageMap.put(entityName, pkgName);
                this.package2entityMap.put(pkgName, entityName);
                this.packageNumMap.put(prefix, 1);
                return pkgName;
            }
            if (prefix.length() == 1) {
                return this.generatePkgName(entityName);
            }
            String prefix1 = prefix.substring(0, prefix.length() - 1);
            return this.makeNewPackageName1(entityName, prefix1);
        }
        pkgNum = this.packageNumMap.get(prefix);
        if (pkgNum < 9 && !this.package2entityMap.containsKey(pkgName = prefix.substring(0, prefix.length() - 1) + ++pkgNum)) {
            this.entity2packageMap.put(entityName, pkgName);
            this.package2entityMap.put(pkgName, entityName);
            this.packageNumMap.put(prefix, pkgNum);
            return pkgName;
        }
        if (prefix.length() == 1) {
            return this.generatePkgName(entityName);
        }
        String prefix1 = prefix.substring(0, prefix.length() - 1);
        return this.makeNewPackageName1(entityName, prefix1);
    }

    protected String generatePkgName(String entityName) {
        String pkgName = "pkg" + this.packageNum;
        ++this.packageNum;
        this.entity2packageMap.put(entityName, pkgName);
        this.package2entityMap.put(pkgName, entityName);
        return pkgName;
    }

    public void setStmtType(SqlStatementType type) {
        this._stmtType = type;
    }

    public SqlStatementType getStmtType() {
        return this._stmtType;
    }

    public void createPDQMeta(String sqlStr, PreparedStatement stmnt, int type) {
        this.createPDQMeta(sqlStr, stmnt, null, type, true);
    }

    public void createPDQMeta(String sqlStr, PreparedStatement stmnt, int type, boolean toSort) {
        this.createPDQMeta(sqlStr, stmnt, null, type, toSort);
    }

    public void createPDQMeta(String sqlStr, PreparedStatement stmnt, String[] autogenColumnNames, int type, boolean toSort) {
        PDQMeta meta;
        if (this._pkgName != null && (meta = this._pdqmetas.getPackage(SEQ_PKG_NAME)) != null) {
            if (this._collectionId != null) {
                meta.setCollectionName(this._collectionId);
            }
            if (this._singlePackage) {
                meta.setPackageName(this._pkgName);
                this._pdqmetas.removePackage(SEQ_PKG_NAME);
                this._pdqmetas.addPackage(this._pkgName, meta);
            }
        }
        if (toSort) {
            sqlStr = PDQBaseData.sort(sqlStr, null);
        }
        if (sqlStr.substring(0, 6).equalsIgnoreCase("values")) {
            return;
        }
        if (this._logs == null) {
            this._logs = this.getConfiguration().getLog("wsjpa.Sqlgen");
        }
        if ((meta = this._pdqmetas.getPackageFromSQL(sqlStr)) == null && (meta = this._pdqmetas.getPackage(this._pkgName)) == null) {
            meta = this.createPDQXmlPackage();
            this._pdqmetas.addPackage(this._pkgName, meta);
        }
        PDQXmlStatement pdqStmnt = null;
        if (this.useOldProblemDeterminationTag) {
            if (meta.exists(sqlStr)) {
                if (this._runtimeSignature != null) {
                    meta.updateMethodName(sqlStr, this._runtimeSignature);
                }
                return;
            }
        } else {
            pdqStmnt = meta.getPDQXmlStatement(sqlStr);
            if (pdqStmnt != null) {
                if (this._runtimeInfo != null || this._queryMeta != null) {
                    StaticMappingRepositoryUtil.populateStatementMetaData(pdqStmnt, this);
                } else {
                    this._logs.trace((Object)_loc.get("missing-statement-metadata", new Object[]{this._runtimeInfo, this._queryMeta, sqlStr}));
                }
                return;
            }
        }
        if ((pdqStmnt = this.createPDQXmlStatement(sqlStr, autogenColumnNames, stmnt, type)) == null) {
            return;
        }
        meta.addStatement(pdqStmnt);
        this.checkMisplacedSQL(meta, sqlStr);
        this._pdqmetas.putSQLPackage(sqlStr, meta);
        this._pdqmetas.incrementCount();
    }

    private void checkMisplacedSQL(PDQMeta meta, String sqlStr) {
        String pkg = meta.getPackageName();
        List<String> sqls = this.package2SqlMap.get(pkg);
        if (sqls == null) {
            sqls = new ArrayList<String>();
            this.package2SqlMap.put(pkg, sqls);
        }
        sqls.add(sqlStr);
    }

    private PDQMeta createPDQXmlPackage() {
        long consistencyToken = 0L;
        if (this._pkgName == null) {
            this.setPkgName(SEQ_PKG_NAME);
        }
        if (this._collectionId == null) {
            this._collectionId = "NULLID";
        }
        PDQMeta pkg = new PDQMeta();
        pkg.setPackageName(this._pkgName);
        pkg.setCollectionName(this._collectionId);
        consistencyToken = System.currentTimeMillis();
        if (consistencyToken == this.oldConsistencyToken) {
            ++consistencyToken;
        }
        pkg.setConsistencyToken(consistencyToken);
        this.oldConsistencyToken = consistencyToken;
        return pkg;
    }

    private PDQXmlStatement createPDQXmlStatement(String sqlStr, String[] autogenColumnNames, PreparedStatement stmnt, int type) {
        PDQXmlStatementAttributes cursor;
        PDQXmlStatementDescriptor pdqStmntD;
        PDQXmlStatement pdqStmnt;
        block12: {
            pdqStmnt = new PDQXmlStatement();
            pdqStmntD = new PDQXmlStatementDescriptor();
            pdqStmnt.setPDQXmlStatementDescriptor(pdqStmntD);
            if (autogenColumnNames != null && autogenColumnNames.length > 0) {
                pdqStmntD.setAutogenColumnNames(autogenColumnNames);
            }
            if (this.useOldProblemDeterminationTag) {
                pdqStmntD.setMethodName(this._runtimeSignature);
            }
            pdqStmntD.setParameterHandlerName(null);
            if (!this.setMetaData(stmnt, sqlStr, pdqStmntD)) {
                return null;
            }
            pdqStmntD.setRowHandlerName(null);
            cursor = new PDQXmlStatementAttributes();
            cursor.setHoldability(Integer.valueOf(1));
            try {
                cursor.setConcurrency(Integer.valueOf(stmnt.getResultSetConcurrency()));
                cursor.setType(Integer.valueOf(stmnt.getResultSetType()));
            }
            catch (SQLException e) {
                if (!this._logs.isTraceEnabled()) break block12;
                this._logs.trace((Object)_loc.get("fail-to-retrieve-ResultSetConcurrency-or-ResultSetType", (Object)sqlStr));
                StaticSQLGenUtil.printException(this._logs, e);
            }
        }
        pdqStmntD.setStatementAttributes(cursor);
        pdqStmntD.setSql(sqlStr);
        String opCode = sqlStr.substring(0, 7);
        if (type == 0 || type == -1 && opCode.equalsIgnoreCase("UPDATE ")) {
            pdqStmntD.setStatementType(SqlStatementType.UPDATE.name());
        } else if (type == 1 || type == -1 && opCode.equalsIgnoreCase("INSERT ")) {
            pdqStmntD.setStatementType(SqlStatementType.INSERT.name());
        } else if (type == 2 || type == -1 && opCode.equalsIgnoreCase("DELETE ")) {
            pdqStmntD.setStatementType(SqlStatementType.DELETE.name());
        } else {
            pdqStmntD.setStatementType(SqlStatementType.QUERY.name());
        }
        if (!this.useOldProblemDeterminationTag) {
            StaticMappingRepositoryUtil.setStatementMetaData(pdqStmnt, this);
        }
        return pdqStmnt;
    }

    private boolean setMetaData(PreparedStatement stmnt, String sqlStr, PDQXmlStatementDescriptor pdqStmntD) {
        if (this.getDbType() == 3) {
            return true;
        }
        PreparedStatement stmnt3 = null;
        Object stmnt2 = stmnt;
        try {
            while (true) {
                Method getInnermostDelegate = stmnt2.getClass().getMethod("getInnermostDelegate", null);
                stmnt2 = getInnermostDelegate.invoke(stmnt2, (Object[])null);
            }
        }
        catch (Exception ne) {
            stmnt3 = stmnt2;
            try {
                PDQXmlParameterMetaData pmd = new PDQXmlParameterMetaData();
                pmd.init(stmnt3);
                PDQXmlResultSetMetaData rmd = new PDQXmlResultSetMetaData();
                rmd.init(stmnt3);
                this.rmdMap.put(sqlStr, rmd);
                pdqStmntD.setParameterMetadata(pmd);
                pdqStmntD.setResultSetMetaData(rmd);
                return true;
            }
            catch (SQLException e) {
                if (this._logs.isTraceEnabled()) {
                    this._logs.trace((Object)_loc.get("fail-to-retrieve-ParameterMetaData-or-ResultSetMetaData", (Object)sqlStr));
                    StaticSQLGenUtil.printException(this._logs, e);
                }
                return false;
            }
        }
    }

    public List getColumns(String sql) {
        try {
            return this.rmdMap.get(sql).getColumns();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setColumns(StaticSelectImpl.StaticSelectResult res, List columns) {
        this.resMap.put(res, columns);
    }

    public List getColumns(StaticSelectImpl.StaticSelectResult res) {
        return this.resMap.get((Object)res);
    }

    public PDQMetas getPDQMetas() {
        PDQXml pdqXml = ((StaticPDQDictionary)this.getDBDictionary()).getPDQXml();
        this._pdqmetas.setPDQXml(pdqXml);
        if (this._logs != null && this._logs.isTraceEnabled()) {
            this.dumpPackageNames();
        }
        return this._pdqmetas;
    }

    private void dumpPackageNames() {
        Set<String> keys = this.entity2packageMap.keySet();
        for (String entityName : keys) {
            if (entityName.equals(SEQ_PKG_NAME)) continue;
            String pkgName = this.entity2packageMap.get(entityName);
            this._logs.trace((Object)_loc.get("entity-package", new Object[]{entityName, pkgName}));
        }
    }

    public Map<String, List<String>> getPackage2SqlMap() {
        return this.package2SqlMap;
    }

    public Map<String, String> getPackage2EntityMap() {
        return this.package2entityMap;
    }

    protected SequenceMetaData newSequenceMetaData(String name) {
        return new StaticSequenceMapping(name, this);
    }

    public void addSystemListener(Object listener) {
    }

    public static class RuntimeInfo {
        public String entityName;
        public String entityClassName;
        public String definedIn;
        public String operation;
        public String fetchGroups;
        public String eagerSelectToManyFields;

        public RuntimeInfo(String entityName, String entityClassName, String definedIn, String operation, EntityManager em, ClassMapping clm) {
            this.entityName = entityName;
            this.entityClassName = entityClassName;
            this.definedIn = definedIn;
            this.operation = operation;
            FetchPlan fp = OpenJPAPersistence.cast((EntityManager)em).getFetchPlan();
            Collection coll = fp.getFetchGroups();
            StringBuilder fgs = new StringBuilder(100);
            int j = 0;
            for (String fg : coll) {
                if (j > 0) {
                    fgs.append(",");
                }
                fgs.append(fg);
                ++j;
            }
            this.fetchGroups = fgs.toString();
            if (clm != null) {
                StringBuilder eager = new StringBuilder(100);
                FieldMetaData[] fmds = clm.getFields();
                j = 0;
                for (int i = 0; i < fmds.length; ++i) {
                    if (!((FieldMapping)fmds[i]).isEagerSelectToMany()) continue;
                    if (j > 0) {
                        eager.append(",");
                    }
                    eager.append(fmds[i].getName());
                    ++j;
                }
                this.eagerSelectToManyFields = eager.toString();
            }
        }

        public String toString() {
            return new StringBuilder(100).append("entityName=").append(this.entityName).append(":").append("entityClassName=").append(this.entityClassName).append(":").append("definedIn=").append(this.definedIn).append(":").append("operation=").append(this.operation).toString();
        }

        public boolean equals(RuntimeInfo runtimeInfo) {
            if (runtimeInfo == null) {
                return false;
            }
            if (this == runtimeInfo) {
                return true;
            }
            return this.entityName.equals(runtimeInfo.entityName) && this.entityClassName.equals(runtimeInfo.entityClassName) && this.definedIn.equals(runtimeInfo.definedIn) && this.operation.equals(runtimeInfo.operation);
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + this.entityName.hashCode();
            result = 31 * result + this.entityClassName.hashCode();
            result = 31 * result + this.definedIn.hashCode();
            result = 31 * result + this.operation.hashCode();
            return result;
        }
    }
}

