/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.meta;

import com.ibm.pdq.runtime.internal.xml.PDQXmlEntity;
import com.ibm.pdq.runtime.internal.xml.PDQXmlNamedNativeQuery;
import com.ibm.pdq.runtime.internal.xml.PDQXmlNamedQuery;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatement;
import com.ibm.pdq.runtime.internal.xml.PDQXmlStatementMetadata;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.openjpa.meta.QueryMetaData;

public class StaticMappingRepositoryUtil {
    public static void populateStatementMetaData(PDQXmlStatement pdqStmnt, StaticMappingRepository metaRepo) {
        PDQXmlStatementMetadata smd = pdqStmnt.getPDQXmlStatementMetadata();
        boolean isOrm = true;
        String fileName = null;
        Object srcScope = null;
        QueryMetaData _queryMeta = metaRepo.getNamedQueryMetaData();
        Map stmntMetadata = metaRepo.getStmntMetadata();
        StaticMappingRepository.RuntimeInfo _runtimeInfo = metaRepo.getRuntimeInfo();
        if (_queryMeta != null) {
            PDQXmlNamedQuery namedQuery;
            int type = _queryMeta.getSourceType();
            if (type == 2) {
                File srcFile = _queryMeta.getSourceFile();
                try {
                    fileName = srcFile.getCanonicalPath();
                }
                catch (IOException e) {
                    fileName = srcFile.getName();
                }
            } else {
                srcScope = _queryMeta.getSourceScope();
                isOrm = false;
            }
            if ((namedQuery = (PDQXmlNamedQuery)stmntMetadata.get(_queryMeta)) == null) {
                if (_queryMeta.getLanguage().equals("openjpa.SQL")) {
                    namedQuery = new PDQXmlNamedNativeQuery();
                    smd.addNamedNativeQuery((PDQXmlNamedNativeQuery)namedQuery);
                } else {
                    namedQuery = new PDQXmlNamedQuery();
                    smd.addNamedQuery(namedQuery);
                }
                stmntMetadata.put(_queryMeta, namedQuery);
                namedQuery.setName(_queryMeta.getName());
                if (isOrm) {
                    namedQuery.setDefinedInFile(fileName);
                    namedQuery.setLine(Integer.valueOf(_queryMeta.getLineNumber()));
                    namedQuery.setColumn(Integer.valueOf(_queryMeta.getColNumber()));
                } else {
                    namedQuery.setDefinedInClass(((Class)srcScope).getName());
                }
            }
        } else if (_runtimeInfo != null) {
            PDQXmlEntity entity = (PDQXmlEntity)stmntMetadata.get(_runtimeInfo.toString());
            if (entity == null) {
                entity = new PDQXmlEntity();
                entity.setName(_runtimeInfo.entityName);
                entity.setDefinedInClass(_runtimeInfo.entityClassName);
                entity.setOperation(_runtimeInfo.operation);
                stmntMetadata.put(_runtimeInfo.toString(), entity);
            }
            if (!smd.getEntityList().contains(entity)) {
                smd.addEntity(entity);
            }
        }
    }

    public static void setStatementMetaData(PDQXmlStatement pdqStmnt, StaticMappingRepository metaRepo) {
        PDQXmlStatementMetadata smd = new PDQXmlStatementMetadata();
        pdqStmnt.setPDQXmlStatementMetadata(smd);
        StaticMappingRepositoryUtil.populateStatementMetaData(pdqStmnt, metaRepo);
    }
}

