/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.sql;

import com.ibm.pdq.runtime.internal.xml.PDQXml;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.Param;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.FieldMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.exps.Path;
import org.apache.openjpa.lib.log.Log;

public class StaticDBDictionary
extends DBDictionary {
    private Log _logs = null;
    private PDQXml _pdqXml = null;

    public void connectedConfiguration(Connection conn) throws SQLException {
        DatabaseMetaData dbMeta = conn.getMetaData();
        this._pdqXml = new PDQXml();
        this._pdqXml.initOrigin(dbMeta, "OpenJPA");
    }

    public PDQXml getPDQXml() {
        return this._pdqXml;
    }

    protected void calculateValue(Val val, Select sel, ExpContext ctx, ExpState state, Path path, ExpState pathState, JDBCConfiguration conf) {
        try {
            val.calculateValue(sel, ctx, state, (Val)path, pathState);
        }
        catch (Exception e) {
            if (this._logs == null) {
                this._logs = conf.getLog("wsjpa.Sqlgen");
            }
            StaticSQLGenUtil.printException(this._logs, e);
            PCPath.PathExpState pstate = (PCPath.PathExpState)pathState;
            FieldMapping field = pstate.cmpfield != null ? pstate.cmpfield : pstate.field;
            Class cls = field.getDeclaredType();
            try {
                Object parmObj = StaticSQLGenUtil.constructObjFromClass(cls, this._logs);
                if (parmObj instanceof Enum) {
                    parmObj = ((Enum)parmObj).ordinal();
                }
                Param.ParamExpState paramState = (Param.ParamExpState)state;
                paramState.sqlValue = parmObj;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected ResultSet executeQuery(Connection conn, PreparedStatement stmnt, String str, JDBCConfiguration conf, DBDictionary dict) throws SQLException {
        SQLBuffer sql = new SQLBuffer(dict).append(str);
        return StaticSQLGenUtil.executeQuery(stmnt, sql.getSQL(), conf);
    }

    protected ResultSet executeQuery(Connection conn, PreparedStatement stmnt, String str, String schemaName, String sequenceName, JDBCConfiguration conf, DBDictionary dict) throws SQLException {
        return this.executeQuery(conn, stmnt, str, conf, dict);
    }

    protected Sequence[] getSequence(ResultSet rs) throws SQLException {
        ArrayList seqList = new ArrayList();
        return seqList.toArray(new Sequence[seqList.size()]);
    }

    protected Object getKey(ResultSet rs, Column col) throws SQLException {
        return new Integer(1);
    }
}

