/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.pdqstatic.jdbc.sql;

import com.ibm.ws.persistence.jdbc.sql.SelectImpl;
import com.ibm.ws.persistence.pdqstatic.gen.StaticSQLGenUtil;
import com.ibm.ws.persistence.pdqstatic.jdbc.meta.StaticMappingRepository;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticDB2Dictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticPDQDictionary;
import com.ibm.ws.persistence.pdqstatic.jdbc.sql.StaticResultSetResult;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.SelectExecutor;

public class StaticSelectImpl
extends SelectImpl {
    private int dbType = -1;
    private final StaticPDQDictionary dict;

    public StaticSelectImpl(JDBCConfiguration conf) {
        super(conf);
        this.dict = (StaticPDQDictionary)conf.getDBDictionaryInstance();
        this.dbType = this.dict.getPlatform();
    }

    protected void setTimeout(PreparedStatement stmnt, boolean forUpdate, JDBCFetchConfiguration fetch) throws SQLException {
    }

    public ResultSet executeQuery(Connection conn, PreparedStatement stmnt, String sql, JDBCStore store, Object[] params, Column[] cols) throws SQLException {
        return StaticSQLGenUtil.executeQuery(stmnt, sql, store.getConfiguration());
    }

    public ResultSet executeQuery(Connection conn, PreparedStatement stmnt, SQLBuffer sql, boolean isLRS, JDBCStore store) throws SQLException {
        String sqlStr = sql.getSQL();
        StaticSQLGenUtil.executeQuery(stmnt, sqlStr, store.getConfiguration());
        if (this.dbType == 1) {
            JDBCFetchConfiguration fetch = store.getFetchConfiguration();
            if (fetch == null) {
                return null;
            }
            int origIsolation = fetch.getIsolation();
            String forUpdateClause1 = this.getForUpdateClause(4, fetch);
            String forUpdateClause2 = this.getForUpdateClause(8, fetch);
            String vanilaStr = this.getSqlWithoutForUpdateClause(sqlStr, forUpdateClause1);
            vanilaStr = this.getSqlWithoutForUpdateClause(vanilaStr, forUpdateClause2);
            StaticSQLGenUtil.executeQuery(stmnt, vanilaStr, store.getConfiguration());
            StaticSQLGenUtil.executeQuery(stmnt, vanilaStr.concat(forUpdateClause1), store.getConfiguration());
            StaticSQLGenUtil.executeQuery(stmnt, vanilaStr.concat(forUpdateClause2), store.getConfiguration());
        }
        return null;
    }

    private String getSqlWithoutForUpdateClause(String sqlStr, String forUpdateClause) {
        int idx = sqlStr.indexOf(forUpdateClause);
        if (idx == -1) {
            return sqlStr;
        }
        return sqlStr.substring(0, idx);
    }

    private String getForUpdateClause(int isolationLevel, JDBCFetchConfiguration fetch) {
        this.setIsolation(fetch, isolationLevel);
        String optimizeClause = ((StaticDB2Dictionary)this.dict).getOptimizeClause((Select)this);
        String forUpdateClause = ((StaticDB2Dictionary)this.dict).getForUpdateClause(fetch, true, (Select)this);
        if (optimizeClause.length() == 0) {
            return forUpdateClause;
        }
        return forUpdateClause.substring(optimizeClause.length());
    }

    private void setIsolation(JDBCFetchConfiguration fetch, int level) {
        if (fetch != null) {
            fetch.setIsolation(level);
        }
    }

    protected int getCount(ResultSet rs) throws SQLException {
        return 1;
    }

    public Result getEagerResult(Connection conn, PreparedStatement stmnt, ResultSet rs, JDBCStore store, JDBCFetchConfiguration fetch, boolean forUpdate, SQLBuffer sql) throws SQLException {
        StaticMappingRepository repos = (StaticMappingRepository)store.getConfiguration().getMetaDataRepositoryInstance();
        List columns = repos.getColumns(sql.getSQL());
        StaticSelectResult res = new StaticSelectResult(null, null, null, store.getDBDictionary());
        repos.setColumns(res, columns);
        res.setStore(store);
        res.setLocking(forUpdate);
        if (this.getEagerMap() != null) {
            Map eager = this.getEagerMap();
            for (Map.Entry entry : eager.entrySet()) {
                StaticSelectResult eres;
                if (entry.getValue() == this) {
                    eres = res;
                    continue;
                }
                eres = ((SelectExecutor)entry.getValue()).execute(store, fetch);
            }
        }
        return res;
    }

    public static class StaticSelectResult
    extends StaticResultSetResult {
        public StaticSelectResult(Connection conn, Statement stmnt, ResultSet rs, DBDictionary dict) {
            super(conn, stmnt, rs, dict);
        }

        protected boolean containsInternal(Object obj, Joins joins) {
            return false;
        }
    }
}

