/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.annotation;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.spi.AnnotationProvider;

public class WASMyFacesAnnotationProvider
extends AnnotationProvider {
    private static final String CLASS_NAME = WASMyFacesAnnotationProvider.class.getName();
    private static final Logger logger = Logger.getLogger(WASMyFacesAnnotationProvider.class.getName());
    private final AnnotationProvider defaultProvider;
    private static Set<Class<? extends Annotation>> annotationClasses;

    public WASMyFacesAnnotationProvider(AnnotationProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    public Map<Class<? extends Annotation>, Set<Class<?>>> getAnnotatedClasses(ExternalContext ctx) {
        HashMap map;
        block4: {
            map = new HashMap();
            ServletContext sctx = (ServletContext)ctx.getContext();
            IServletContext servletContext = WASMyFacesAnnotationProvider.unwrapServletContext(sctx);
            Container moduleContainer = servletContext.getModuleContainer();
            try {
                WebAnnotations webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
                AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                ClassLoader cl = ClassUtils.getContextClassLoader();
                for (Class<? extends Annotation> annotation : annotationClasses) {
                    Set classNames = annotationTargets.getAllInheritedAnnotatedClasses(annotation.getCanonicalName());
                    HashSet classSet = new HashSet();
                    for (String className : classNames) {
                        Class<?> loaded = this.loadClass(className, cl);
                        if (loaded == null) continue;
                        classSet.add(loaded);
                    }
                    map.put(annotation, classSet);
                }
            }
            catch (UnableToAdaptException uae) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block4;
                logger.logp(Level.FINE, CLASS_NAME, "getAnnotatedClasses", "unable to adapt to WebAnnotations", uae);
            }
        }
        return map;
    }

    @Override
    public Set<URL> getBaseUrls() throws IOException {
        return this.defaultProvider.getBaseUrls();
    }

    private static IServletContext unwrapServletContext(ServletContext context) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "original context->" + context);
        }
        while (context instanceof ServletContextFacade) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "unwrapServletContext", "nested context->" + context);
            }
            context = ((ServletContextFacade)context).getIServletContext();
        }
        return (IServletContext)context;
    }

    private Class<?> loadClass(String className, ClassLoader loader) {
        try {
            return loader.loadClass(className);
        }
        catch (Throwable t) {
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "loadClass", "exception loading class " + className, t);
            }
            return null;
        }
    }

    static {
        HashSet<Class> annotations = new HashSet<Class>(10, 1.0f);
        annotations.add(FacesComponent.class);
        annotations.add(FacesBehavior.class);
        annotations.add(FacesConverter.class);
        annotations.add(FacesValidator.class);
        annotations.add(FacesRenderer.class);
        annotations.add(ManagedBean.class);
        annotations.add(NamedEvent.class);
        annotations.add(FacesBehaviorRenderer.class);
        annotationClasses = Collections.unmodifiableSet(annotations);
    }
}

