/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.annotation;

import com.ibm.ws.jsf.config.annotation.WebSphereAnnotationLifecycleProvider;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.config.annotation.NoAnnotationLifecyleProvider;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class WebSphereLifecycleProviderFactory
extends LifecycleProviderFactory {
    private static HashMap<ClassLoader, LifecycleProvider> lifecycleProviders;
    private static final Logger log;

    public WebSphereLifecycleProviderFactory() {
        if (lifecycleProviders == null) {
            lifecycleProviders = new HashMap();
        }
    }

    @Override
    public LifecycleProvider getLifecycleProvider(ExternalContext externalContext) {
        ClassLoader cl = ClassUtils.getContextClassLoader();
        LifecycleProvider provider = null;
        provider = lifecycleProviders.get(cl);
        if (provider == null) {
            if (externalContext != null) {
                provider = new WebSphereAnnotationLifecycleProvider(externalContext);
                lifecycleProviders.put(cl, provider);
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("ExternalContext not found, resolve fallback LifecycleProvider");
                }
                provider = new NoAnnotationLifecyleProvider();
            }
        }
        return provider;
    }

    @Override
    public void release() {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("about to clear lifecycle provider map");
        }
        lifecycleProviders.clear();
    }

    static {
        log = Logger.getLogger(WebSphereLifecycleProviderFactory.class.getName());
    }
}

