/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.resource;

import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.Dictionary;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;

public class JSFCDIConfigProvider {
    public static final String PHASE_LISTENER = "com.ibm.ws.cdi.provider.jsf.phase.listener";
    public static final String JSF_APPLICATION_FACTORY = "com.ibm.ws.cdi.provider.jsf.application.factory";
    public static final String CDI_CONFIG_ADMIN_PID = "com.ibm.ws.cdi.provider.props";
    private static final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configAdmin");

    public static String getPhaseListener() throws IOException {
        return JSFCDIConfigProvider.getConfigProperty(PHASE_LISTENER);
    }

    public static String getApplicationFactory() throws IOException {
        return JSFCDIConfigProvider.getConfigProperty(JSF_APPLICATION_FACTORY);
    }

    public void setConfigAdmin(ServiceReference<ConfigurationAdmin> configAdmin) {
        configAdminRef.setReference(configAdmin);
    }

    protected void unsetConfigAdmin(ServiceReference<ConfigurationAdmin> ref) {
        configAdminRef.unsetReference(ref);
    }

    protected void activate(ComponentContext context) {
        configAdminRef.activate(context);
    }

    protected void deactivate(ComponentContext context) {
        configAdminRef.deactivate(context);
    }

    private static String getConfigProperty(String key) throws IOException {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)configAdminRef.getServiceWithException();
        Configuration config = configAdmin.getConfiguration(CDI_CONFIG_ADMIN_PID, null);
        Dictionary dict = config.getProperties();
        Object v = dict.get(key);
        if (v instanceof String) {
            return (String)v;
        }
        return null;
    }
}

