/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.resource;

import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleClassesInfo;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;

public class LibertyFaceletConfigResourceProvider
extends FaceletConfigResourceProvider {
    private static final String CLASS_NAME = LibertyFaceletConfigResourceProvider.class.getName();
    protected static final Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACELET_TAGLIB_SUFFIX = ".taglib.xml";
    private FaceletConfigResourceProvider defaultProvider;

    public LibertyFaceletConfigResourceProvider() {
    }

    public LibertyFaceletConfigResourceProvider(FaceletConfigResourceProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    public Collection<URL> getFaceletTagLibConfigurationResources(ExternalContext context) throws IOException {
        String method = "getFaceletTagLibConfigurationResources";
        Collection<URL> urlSet = null;
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getFaceletTagLibConfigurationResources");
        }
        boolean isOSGIApp = false;
        if (context.getApplicationMap().get("osgi-bundlecontext") != null) {
            isOSGIApp = true;
        }
        urlSet = this.defaultProvider.getFaceletTagLibConfigurationResources(context);
        if (isOSGIApp) {
            Object o = context.getContext();
            ServletContextFacade sc = null;
            if (o instanceof ServletContextFacade) {
                sc = (ServletContextFacade)o;
                Container c = sc.getIServletContext().getModuleContainer();
                if (c != null) {
                    urlSet = this.getFaceletTagLibConfigResourcesHelper(c, urlSet);
                }
            } else if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "getFaceletTagLibConfigurationResources", "OSGI app without a Servlet Context");
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "getFaceletTagLibConfigurationResources");
        }
        return urlSet;
    }

    private Collection<URL> getFaceletTagLibConfigResourcesHelper(Container c, Collection<URL> urlSet) {
        String method = "getFaceletTagLibConfigResourcesHelper";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getFaceletTagLibConfigResourcesHelper");
        }
        if (urlSet == null) {
            urlSet = new ArrayList<URL>();
        }
        try {
            ArrayList<Container> jarResourceContainers = new ArrayList<Container>();
            WebModuleClassesInfo classesInfo = (WebModuleClassesInfo)c.adapt(WebModuleClassesInfo.class);
            int numberOfJars = 0;
            if (classesInfo != null) {
                List containerInfos = classesInfo.getClassesContainers();
                for (ContainerInfo containerInfo : containerInfos) {
                    if (containerInfo.getType() != ContainerInfo.Type.WEB_INF_LIB) continue;
                    jarResourceContainers.add(containerInfo.getContainer());
                    ++numberOfJars;
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getFaceletTagLibConfigResourcesHelper", "Checking " + numberOfJars + " jars for META-INF/*.taglib.xml");
            }
            for (Container jarContainer : jarResourceContainers) {
                Entry metaInf = jarContainer.getEntry(META_INF_PREFIX);
                if (metaInf == null) continue;
                Container metaInfContainer = (Container)metaInf.adapt(Container.class);
                for (Entry entry : metaInfContainer) {
                    String name = entry.getName();
                    if (!name.endsWith(FACELET_TAGLIB_SUFFIX)) continue;
                    URL urlObject = entry.getResource();
                    urlSet.add(urlObject);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.logp(Level.FINE, CLASS_NAME, "getFaceletTagLibConfigResourcesHelper", "Adding " + urlObject.toString());
                }
            }
        }
        catch (UnableToAdaptException e) {
            throw new IllegalStateException(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "getFaceletTagLibConfigResourcesHelper", urlSet);
        }
        return urlSet;
    }
}

