/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.config.resource;

import com.ibm.wsspi.webcontainer.WCCustomProperties;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.view.facelets.util.Classpath;

public class WASFacesConfigResourceProvider
extends FacesConfigResourceProvider {
    private static final String CLASS_NAME = WASFacesConfigResourceProvider.class.getName();
    protected static Logger logger = Logger.getLogger(CLASS_NAME);
    private static final String META_INF_PREFIX = "META-INF/";
    private static final String FACES_CONFIG_SUFFIX = ".faces-config.xml";
    private static final String FACES_CONFIG_IMPLICIT = "META-INF/faces-config.xml";
    private static final String DISABLE_ALTERNATE_FACES_CONFIG_SEARCH_CONTEXT_PARAM = "com.ibm.ws.jsf.disablealternatefacesconfigsearch";
    private FacesConfigResourceProvider defaultProvider;

    public WASFacesConfigResourceProvider() {
    }

    public WASFacesConfigResourceProvider(FacesConfigResourceProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    public Collection<URL> getMetaInfConfigurationResources(ExternalContext context) throws IOException {
        ArrayList<URL> urlSet = new ArrayList<URL>();
        String method = "getMetaInfConfigurationResources";
        if (!this.isWildCardFacesConfigScanDisabled(context)) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, method, "searching for META_INF/faces-config.xml resources in classpath jars");
            }
            Enumeration<URL> resources = this.getClassLoader().getResources(FACES_CONFIG_IMPLICIT);
            while (resources.hasMoreElements()) {
                urlSet.add(resources.nextElement());
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, method, "alternate faces config scanning is enabled, searching for META-INF/*.faces-config.xml resources");
            }
            URL[] urls = Classpath.search(this.getClassLoader(), META_INF_PREFIX, FACES_CONFIG_SUFFIX);
            for (int i = 0; i < urls.length; ++i) {
                urlSet.add(urls[i]);
            }
            return urlSet;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, method, "searching for META_INF/faces-config.xml resources in classpath jars");
        }
        Enumeration<URL> resources = this.getClassLoader().getResources(FACES_CONFIG_IMPLICIT);
        while (resources.hasMoreElements()) {
            urlSet.add(resources.nextElement());
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, method, "alternate faces config scanning is disabled, skipping search for META-INF/*.faces-config.xml");
        }
        return urlSet;
    }

    private boolean isWildCardFacesConfigScanDisabled(ExternalContext context) {
        String contextParamValue = context.getInitParameter(DISABLE_ALTERNATE_FACES_CONFIG_SEARCH_CONTEXT_PARAM);
        if (contextParamValue != null) {
            return Boolean.parseBoolean(contextParamValue);
        }
        return WCCustomProperties.JSF_DISABLE_ALTERNATE_FACES_CONFIG_SEARCH;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader loader = ClassUtils.getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        return loader;
    }
}

