/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.ext;

import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.ExternalContext;
import javax.faces.webapp.FacesServlet;
import javax.servlet.ServletRegistration;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.shared_impl.webapp.webxml.DelegatedFacesServlet;
import org.apache.myfaces.spi.ServletMapping;
import org.apache.myfaces.spi.WebConfigProvider;
import org.apache.myfaces.spi.impl.ServletMappingImpl;

public class LibertyWebConfigProvider
extends WebConfigProvider {
    private static final Logger log = Logger.getLogger("com.ibm.ws.jsf.ext.LibertyWebConfigProvider");

    @Override
    public List<ServletMapping> getFacesServletMappings(ExternalContext externalContext) {
        IServletContext context = (IServletContext)externalContext.getContext();
        MyfacesConfig mfconfig = MyfacesConfig.getCurrentInstance(externalContext);
        String delegateFacesServlet = mfconfig.getDelegateFacesServlet();
        ArrayList<ServletMapping> facesServletMappings = new ArrayList<ServletMapping>();
        Map servletRegistrations = context.getServletRegistrations();
        if (null != servletRegistrations) {
            for (Map.Entry entry : servletRegistrations.entrySet()) {
                Class servletClass;
                ServletRegistration servletRegistration = (ServletRegistration)entry.getValue();
                String servletName = servletRegistration.getClassName();
                if (servletName == null) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Encountered a null Servlet name: continuing on to the next Servlet that was registered");
                    continue;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Trying to load the following Servlet that was registered: " + servletName);
                }
                if ((servletClass = ClassUtils.simpleClassForName(servletName, false)) == null) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("servletClass is null for: " + servletName);
                    log.fine("Continuing on to the next Servlet that was registered.");
                    continue;
                }
                if (!FacesServlet.class.isAssignableFrom(servletClass) && !DelegatedFacesServlet.class.isAssignableFrom(servletClass) && !servletClass.getName().equals(delegateFacesServlet)) continue;
                Collection mappings = servletRegistration.getMappings();
                for (String url : mappings) {
                    org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping delegateMapping = new org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping(servletName, servletClass, url);
                    facesServletMappings.add(new ServletMappingImpl(delegateMapping));
                }
            }
        }
        return facesServletMappings;
    }

    @Override
    public boolean isErrorPagePresent(ExternalContext externalContext) {
        IServletContext context = (IServletContext)externalContext.getContext();
        WebAppConfig webAppConfig = context.getWebAppConfig();
        return webAppConfig.isErrorPagePresent();
    }
}

