/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.extprocessor;

import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.jsf.JSFConstants;
import com.ibm.ws.jsf.extprocessor.JSFExtensionProcessor;
import com.ibm.ws.jsf.util.FacesMessages;
import com.ibm.ws.jsf.util.JspURIMatcher;
import com.ibm.ws.jsf.util.WSFacesUtil;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.extension.ExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.net.URL;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextListener;
import javax.validation.ValidationException;
import javax.validation.ValidatorFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class JSFExtensionFactory
implements ExtensionFactory {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.extprocessor.JSFExtensionFactory";
    private static final String FACES_SERVLET_RESOURCE = "javax/faces/webapp/FacesServlet.class";
    private static final String SUN_CONFIGURE_LISTENER_CLASSNAME = "com.sun.faces.config.ConfigureListener";
    private static final String MYFACES_LIFECYCLE_LISTENER_CLASSNAME = "org.apache.myfaces.webapp.StartupServletContextListener";
    private static final String sunRIClassToSearch = "com/sun/faces/vendor/WebSphereInjectionProvider.class";
    private static final String myFacesClassToSearch = "com/ibm/ws/jsf/config/annotation/WASMyFacesAnnotationProvider.class";
    private URL defaultFacesServlet = null;
    private String applicationName = null;
    private static final String SUN_LISTENER_REGISTERED_STRING = "sunListenerRegistered";
    private static final String MYFACES_LISTENER_REGISTERED_STRING = "myfacesListenerRegistered";
    private static final String NO_LISTENER_REGISTERED_STRING = "noListenerFound";
    private JSFConstants.JSFImplEnabled jsfImplEnabled = null;
    private final AtomicReference<ClassLoadingService> classLoadingSRRef = new AtomicReference<Object>(null);
    private final AtomicServiceReference<BeanValidation> beanValidationSRRef = new AtomicServiceReference("beanValidation");
    private static final AtomicServiceReference<SerializationService> serializationServiceRef = new AtomicServiceReference("serializationService");

    public JSFExtensionFactory() {
        this.defaultFacesServlet = WSFacesUtil.getClassLoader(this).getResource(FACES_SERVLET_RESOURCE);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "<clinit>", "defaultFacesServlet = " + this.defaultFacesServlet);
        }
    }

    public void activate(ComponentContext compcontext, Map<String, Object> properties) {
        this.beanValidationSRRef.activate(compcontext);
        serializationServiceRef.activate(compcontext);
    }

    public void deactivate(ComponentContext compcontext) {
        this.beanValidationSRRef.deactivate(compcontext);
        serializationServiceRef.deactivate(compcontext);
    }

    protected void setClassLoadingService(ClassLoadingService ref) {
        this.classLoadingSRRef.set(ref);
    }

    protected void unsetClassLoadingService(ClassLoadingService ref) {
        this.classLoadingSRRef.set(null);
    }

    public void setBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidationSRRef.setReference(ref);
    }

    public void unsetBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidationSRRef.unsetReference(ref);
    }

    public BeanValidation getBeanValidation() {
        return (BeanValidation)this.beanValidationSRRef.getService();
    }

    protected void setSerializationService(ServiceReference<SerializationService> ref) {
        serializationServiceRef.setReference(ref);
    }

    protected void unsetSerializationService(ServiceReference<SerializationService> ref) {
        serializationServiceRef.unsetReference(ref);
    }

    public static SerializationService getSerializationService() {
        return (SerializationService)serializationServiceRef.getService();
    }

    private void setValidatorFactoryAttribute(IServletContext ctxt) {
        BeanValidation bv = this.getBeanValidation();
        ComponentMetaData cmd = null;
        ValidatorFactory vf = null;
        if (bv != null) {
            cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null) {
                try {
                    vf = bv.getValidatorFactory(cmd);
                    ctxt.setAttribute("javax.faces.validator.beanValidator.ValidatorFactory", (Object)vf);
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "VALIDATOR_FACTORY_KEY set to: " + vf);
                    }
                }
                catch (ValidationException bve) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "exception thrown while attempting to set the validator factory", bve);
                    }
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "setValidatorFactoryAttribute", "bean validation service was null");
        }
    }

    public ExtensionProcessor createExtensionProcessor(IServletContext webapp) throws Exception {
        WebAppConfig config;
        this.applicationName = webapp.getServletContextName();
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Enter createExtensionProcessor(): webapp =[" + this.applicationName + "]");
        }
        if (!this.isFacesApp(config = webapp.getWebAppConfig())) {
            webapp.setAttribute(JSFConstants.JSF_IMPL_ENABLED_PARAM, (Object)JSFConstants.JSFImplEnabled.None);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Exit createExtensionProcessor(): JSF is not enabled for webapp =[" + this.applicationName + "]");
            }
            return null;
        }
        this.initFaces(webapp, config);
        webapp.setAttribute(JSFConstants.JSF_IMPL_ENABLED_PARAM, (Object)this.jsfImplEnabled);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "createExtensionProcessor", "Exit createExtensionProcessor(): JSF is enabled for webapp: [" + this.applicationName + "] using implementation=[" + (Object)((Object)this.jsfImplEnabled) + "]");
        }
        if (this.jsfImplEnabled == JSFConstants.JSFImplEnabled.MyFaces) {
            this.setValidatorFactoryAttribute(webapp);
        }
        return new JSFExtensionProcessor(webapp);
    }

    private void initFaces(IServletContext webapp, WebAppConfig config) throws Exception {
        ClassLoader appClassLoader = WSFacesUtil.getContextClassLoader(webapp);
        ClassLoader ourClassLoader = JSFExtensionFactory.class.getClassLoader();
        URL webappFacesServlet = appClassLoader.getResource(FACES_SERVLET_RESOURCE);
        if (log.isLoggable(Level.FINE)) {
            log.logp(Level.FINE, CLASS_NAME, "initFaces", "webappFacesServlet equals " + webappFacesServlet.getPath());
            log.logp(Level.FINE, CLASS_NAME, "initFaces", "webappFacesServlet path equals " + webappFacesServlet.getPath());
        }
        boolean usingCustomJar = false;
        boolean usingDefaultSunRIJar = false;
        boolean usingDefaultMyFacesJar = false;
        if (!this.defaultFacesServlet.equals(webappFacesServlet)) {
            usingCustomJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "using a custom jar");
            }
        } else if (appClassLoader.getResource(sunRIClassToSearch) != null) {
            usingDefaultSunRIJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Using the sunRI runtime jar");
            }
        } else {
            usingDefaultMyFacesJar = true;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Using the myFaces runtime jar");
            }
        }
        String listenerFound = this.checkForListeners(config);
        if (usingCustomJar) {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Webapp [" + this.applicationName + "] overrode default Faces Servlet. WebSphere Myfaces JSF config will be ignored.");
            }
            this.handleJSPUpdateCheck(webapp);
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.Custom;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Webapp [" + this.applicationName + "] is providing a third party JSF runtime.");
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "FacesServlet URL path=[" + webappFacesServlet.getPath() + "]");
            }
        } else if (usingDefaultSunRIJar) {
            this.handleJSPUpdateCheck(webapp);
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.SunRI;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 JSF Implementation detected and will be used to configure the webapp for  [" + this.applicationName + "].");
            }
            if (!listenerFound.equals(SUN_LISTENER_REGISTERED_STRING)) {
                boolean sunListenerInitialized;
                if (listenerFound.equals(MYFACES_LISTENER_REGISTERED_STRING) && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg("jsf.warn.myfaces.listener.for.ri.app", new Object[]{this.applicationName}));
                }
                if (sunListenerInitialized = this.registerListener(webapp, SUN_CONFIGURE_LISTENER_CLASSNAME, appClassLoader)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 JSF Implementation listener is initialized for [" + this.applicationName + "].");
                    }
                    this.jsfImplEnabled = JSFConstants.JSFImplEnabled.SunRI;
                } else {
                    this.jsfImplEnabled = JSFConstants.JSFImplEnabled.Custom;
                    if (log.isLoggable(Level.WARNING)) {
                        log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg("jsf.warn.ri.impl.not.initialized", new Object[]{this.applicationName}));
                    }
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "Sun RI 1.2 listener already configured, skipping listener registration for  [" + this.applicationName + "].");
            }
        } else if (usingDefaultMyFacesJar) {
            this.jsfImplEnabled = JSFConstants.JSFImplEnabled.MyFaces;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces JSF Implementation detected and will be used to configure the webapp for  [" + this.applicationName + "].");
            }
            if (listenerFound.equals(MYFACES_LISTENER_REGISTERED_STRING)) {
                if (log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces listener already configured, skipping listener registration for  [" + this.applicationName + "].");
                }
            } else {
                boolean myfacesListenerInitialized;
                if (listenerFound.equals(SUN_LISTENER_REGISTERED_STRING) && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg("jsf.warn.ri.listener.for.myfaces.app", new Object[]{this.applicationName}));
                }
                if ((myfacesListenerInitialized = this.registerListener(webapp, MYFACES_LIFECYCLE_LISTENER_CLASSNAME, ourClassLoader)) && log.isLoggable(Level.FINE)) {
                    log.logp(Level.FINE, CLASS_NAME, "initFaces", "MyFaces listener is initialized for [" + this.applicationName + "].");
                }
                if (!myfacesListenerInitialized && log.isLoggable(Level.WARNING)) {
                    log.logp(Level.WARNING, CLASS_NAME, "initFaces", FacesMessages.getMsg("jsf.warn.myfaces.not.initialized", new Object[]{this.applicationName}));
                }
            }
        }
    }

    public List getPatternList() {
        return Collections.EMPTY_LIST;
    }

    private boolean registerListener(IServletContext webapp, String listenerClassName, ClassLoader classLoader) {
        try {
            ServletContextListener listener = (ServletContextListener)Class.forName(listenerClassName, true, classLoader).newInstance();
            webapp.addLifecycleListener((EventListener)listener);
        }
        catch (Exception e) {
            if (log.isLoggable(Level.WARNING)) {
                log.logp(Level.WARNING, CLASS_NAME, "registerListener", FacesMessages.getMsg("jsf.warn.exception.during.listener", new Object[]{listenerClassName, this.applicationName}), e);
            }
            return false;
        }
        return true;
    }

    private String checkForListeners(WebAppConfig config) {
        String listenerFound = NO_LISTENER_REGISTERED_STRING;
        if (config != null) {
            List listeners = config.getListeners();
            for (Object listener : listeners) {
                if (!(listener instanceof String)) continue;
                String listenerClassname = (String)listener;
                if (listenerClassname.equals(SUN_CONFIGURE_LISTENER_CLASSNAME)) {
                    listenerFound = SUN_LISTENER_REGISTERED_STRING;
                    break;
                }
                if (!listenerClassname.equals(MYFACES_LIFECYCLE_LISTENER_CLASSNAME)) continue;
                listenerFound = MYFACES_LISTENER_REGISTERED_STRING;
                break;
            }
        }
        return listenerFound;
    }

    private boolean isFacesApp(WebAppConfig config) {
        Iterator servletConfigs = config.getServletInfos();
        while (servletConfigs.hasNext()) {
            String servletClass = ((IServletConfig)servletConfigs.next()).getClassName();
            if (!"javax.faces.webapp.FacesServlet".equals(servletClass) && !"org.apache.myfaces.webapp.MyFacesServlet".equals(servletClass)) continue;
            return true;
        }
        return false;
    }

    private void handleJSPUpdateCheck(IServletContext webapp) {
        String jspUpdateCheckEnabled = webapp.getInitParameter(JSFConstants.JSP_UPDATE_CHECK);
        if (jspUpdateCheckEnabled != null && jspUpdateCheckEnabled.equalsIgnoreCase("TRUE")) {
            JspURIMatcher matcher = new JspURIMatcher(webapp);
            webapp.setAttribute(JSFConstants.JSP_URI_MATCHER, (Object)matcher);
        }
    }
}

