/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsf.util;

import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.javaee.dd.common.ParamValue;
import com.ibm.ws.javaee.dd.jsf.FacesConfig;
import com.ibm.ws.javaee.dd.jsf.FacesConfigManagedBean;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.targets.AnnotationTargets_Targets;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.service.component.ComponentContext;

public class JSFInjectionClassListCollaborator
implements WebAppInjectionClassListCollaborator {
    protected static final Logger log = Logger.getLogger("com.ibm.ws.jsf");
    private static final String CLASS_NAME = "com.ibm.ws.jsf.util.JSFInjectionClassListCollaborator";
    public static final String FACES_CONFIG_NAMES = "javax.faces.CONFIG_FILES";

    public void activate(ComponentContext compcontext) {
    }

    public void deactivate(ComponentContext compcontext) {
    }

    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> injectionClassNames;
        block7: {
            String methodName;
            block6: {
                methodName = "getInjectionClasses";
                injectionClassNames = new ArrayList<String>();
                try {
                    WebAnnotations webAnnotations = AnnotationsBetaHelper.getWebAnnotations((Container)moduleContainer);
                    AnnotationTargets_Targets annotationTargets = webAnnotations.getAnnotationTargets();
                    Set managedBeanClassNames = annotationTargets.getAllInheritedAnnotatedClasses("javax.faces.bean.ManagedBean");
                    injectionClassNames.addAll(managedBeanClassNames);
                }
                catch (UnableToAdaptException e) {
                    if (!log.isLoggable(Level.FINE)) break block6;
                    log.logp(Level.FINE, CLASS_NAME, methodName, "Failed to locate javax.faces.bean.ManagedBean annotated classes", e);
                }
            }
            try {
                FacesConfig facesConfig = (FacesConfig)moduleContainer.adapt(FacesConfig.class);
                if (facesConfig != null) {
                    List beans = facesConfig.getManagedBeans();
                    for (FacesConfigManagedBean bean : beans) {
                        injectionClassNames.add(bean.getManagedBeanClass());
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block7;
                log.logp(Level.FINE, CLASS_NAME, methodName, "failed to adapt to default faces-config in Container", e);
            }
        }
        this.addConfigFileBeans(moduleContainer.getEntry("META-INF/faces-config.xml"), injectionClassNames);
        this.searchJars(moduleContainer, injectionClassNames);
        this.addAlternateNamedFacesConfig(moduleContainer, injectionClassNames);
        return injectionClassNames;
    }

    private void addAlternateNamedFacesConfig(Container moduleContainer, List<String> classList) {
        block6: {
            try {
                WebApp webapp = (WebApp)moduleContainer.adapt(WebApp.class);
                if (webapp == null) {
                    return;
                }
                List params = webapp.getContextParams();
                String configNames = null;
                for (ParamValue param : params) {
                    if (!param.getName().equals(FACES_CONFIG_NAMES)) continue;
                    configNames = param.getValue();
                    break;
                }
                if (configNames == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(configNames, ",");
                while (st.hasMoreTokens()) {
                    this.addConfigFileBeans(moduleContainer.getEntry(st.nextToken()), classList);
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block6;
                log.logp(Level.FINE, CLASS_NAME, "addAlternateNamedFacesConfig", "failed to adapt conatiner to WebApp", e);
            }
        }
    }

    private void searchJars(Container moduleContainer, List<String> classList) {
        block7: {
            String methodName = "searchJars";
            Entry webinfLibEntry = moduleContainer.getEntry("WEB-INF/lib");
            if (webinfLibEntry == null) {
                return;
            }
            try {
                Container webinfLibContainer = (Container)webinfLibEntry.adapt(Container.class);
                for (Entry libEntry : webinfLibContainer) {
                    if (!libEntry.getName().endsWith(".jar")) continue;
                    try {
                        Container metainfContainer;
                        Container jarContainer = (Container)libEntry.adapt(Container.class);
                        if (jarContainer == null) continue;
                        this.addConfigFileBeans(jarContainer.getEntry("META-INF/faces-config.xml"), classList);
                        Entry metainf = jarContainer.getEntry("META-INF");
                        if (metainf == null || (metainfContainer = (Container)metainf.adapt(Container.class)) == null) continue;
                        for (Entry metaInfEntry : metainfContainer) {
                            if (!metaInfEntry.getName().endsWith(".faces-config.xml")) continue;
                            this.addConfigFileBeans(metaInfEntry, classList);
                        }
                    }
                    catch (UnableToAdaptException e) {
                        if (!log.isLoggable(Level.FINE)) continue;
                        log.logp(Level.FINE, CLASS_NAME, methodName, "unable to adapt jar or META-INF dir in jar named " + libEntry.getName() + " to a container", e);
                    }
                }
            }
            catch (UnableToAdaptException e) {
                if (!log.isLoggable(Level.FINE)) break block7;
                log.logp(Level.FINE, CLASS_NAME, methodName, "unable to adapt WEB-INF/lib to a container", e);
            }
        }
    }

    private void addConfigFileBeans(Entry e, List<String> classList) {
        block4: {
            if (e == null) {
                return;
            }
            try {
                FacesConfig facesConfig = (FacesConfig)e.adapt(FacesConfig.class);
                List beans = facesConfig.getManagedBeans();
                for (FacesConfigManagedBean bean : beans) {
                    classList.add(bean.getManagedBeanClass());
                }
            }
            catch (UnableToAdaptException ex) {
                if (!log.isLoggable(Level.FINE)) break block4;
                log.logp(Level.FINE, CLASS_NAME, "getConfigFileBeans", "failed to adapt to faces-config from entry:" + e, ex);
            }
        }
    }
}

