/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.jsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.application.MyfacesStateManager;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.application.viewstate.CounterKeyFactory;
import org.apache.myfaces.application.viewstate.CounterSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.KeyFactory;
import org.apache.myfaces.application.viewstate.RandomKeyFactory;
import org.apache.myfaces.application.viewstate.RandomSessionViewStorageFactory;
import org.apache.myfaces.application.viewstate.SecureRandomKeyFactory;
import org.apache.myfaces.application.viewstate.SecureSerializedViewCollection;
import org.apache.myfaces.application.viewstate.SecureSerializedViewKey;
import org.apache.myfaces.application.viewstate.SessionViewStorageFactory;
import org.apache.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.MyFacesObjectInputStream;
import org.apache.myfaces.shared_impl.util.WebConfigParamUtils;

public class JspStateManagerImpl
extends MyfacesStateManager {
    private static final Logger log = Logger.getLogger(JspStateManagerImpl.class.getName());
    private static final String SERIALIZED_VIEW_SESSION_ATTR = JspStateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = JspStateManagerImpl.class.getName() + ".SERIALIZED_VIEW";
    private static final String RESTORED_SERIALIZED_VIEW_REQUEST_ATTR = JspStateManagerImpl.class.getName() + ".RESTORED_SERIALIZED_VIEW";
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE = "org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT = "hard-soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT = "soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK = "soft-weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK = "weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF = "off";
    private static final String SERIALIZE_STATE_IN_SESSION_PARAM = "org.apache.myfaces.SERIALIZE_STATE_IN_SESSION";
    private static final String COMPRESS_SERVER_STATE_PARAM = "org.apache.myfaces.COMPRESS_STATE_IN_SESSION";
    private static final boolean DEFAULT_COMPRESS_SERVER_STATE_PARAM = true;
    private static final boolean DEFAULT_SERIALIZE_STATE_IN_SESSION = true;
    private static final int UNCOMPRESSED_FLAG = 0;
    private static final int COMPRESSED_FLAG = 1;
    private static final int JSF_SEQUENCE_INDEX = 0;
    private RenderKitFactory _renderKitFactory = null;
    private SessionViewStorageFactory sessionViewStorageFactory;

    public JspStateManagerImpl() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!this.isSavingStateInClient(facesContext)) {
            String randomMode = WebConfigParamUtils.getStringInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_VIEW_STATE_SESSION_TOKEN", "secureRandom");
            if ("random".equals(randomMode)) {
                this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new RandomKeyFactory(facesContext));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using RandomKeyFactory");
                }
            } else if ("none".equals(randomMode)) {
                this.sessionViewStorageFactory = new CounterSessionViewStorageFactory(new CounterKeyFactory());
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using CounterKeyFactory");
                }
            } else {
                this.sessionViewStorageFactory = new RandomSessionViewStorageFactory(new SecureRandomKeyFactory(facesContext));
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Created sessionViewStorageFactory using SecureRandomKeyFactory");
                }
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("New JspStateManagerImpl instance created");
        }
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering getComponentStateToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting getComponentStateToSave");
        }
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        TreeStructureManager tsm = new TreeStructureManager();
        Object retVal = tsm.buildTreeStructureToSave(viewRoot);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting getTreeStructureToSave");
        }
        return retVal;
    }

    protected void restoreComponentState(FacesContext facesContext, UIViewRoot uiViewRoot, String renderKitId) {
        Object serializedComponentStates;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering restoreComponentState");
        }
        RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        if (this.isSavingStateInClient(facesContext)) {
            serializedComponentStates = this.isLegacyResponseStateManager(responseStateManager) ? responseStateManager.getComponentStateToRestore(facesContext) : responseStateManager.getState(facesContext, uiViewRoot.getViewId());
            if (serializedComponentStates == null) {
                log.severe("No serialized component state found in client request!");
                uiViewRoot.setViewId(null);
                return;
            }
        } else {
            Object[] savedState = (Object[])responseStateManager.getState(facesContext, uiViewRoot.getViewId());
            Object serverStateId = this.getSecureServerStateId(savedState);
            Object[] stateObj = (Object[])(serverStateId == null ? null : this.getSerializedViewFromServletSession(facesContext, uiViewRoot.getViewId(), serverStateId));
            if (stateObj == null) {
                log.severe("No serialized view found in server session!");
                uiViewRoot.setViewId(null);
                return;
            }
            StateManager.SerializedView serializedView = new StateManager.SerializedView((StateManager)this, stateObj[0], stateObj[1]);
            serializedComponentStates = serializedView.getState();
            if (serializedComponentStates == null) {
                log.severe("No serialized component state found in server session!");
                return;
            }
        }
        if (uiViewRoot.getRenderKitId() == null) {
            uiViewRoot.setRenderKitId(renderKitId);
        }
        uiViewRoot.processRestoreState(facesContext, serializedComponentStates);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting restoreComponentState");
        }
    }

    protected Object getSecureServerStateId(Object[] state) {
        Object sequence;
        if (state != null && (sequence = state[0]) != null) {
            return this.getKeyFactory().decode((String)sequence);
        }
        return null;
    }

    protected Integer getServerStateId(Object[] state) {
        return null;
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering restoreTreeStructure");
        }
        RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
        ResponseStateManager responseStateManager = rk.getResponseStateManager();
        if (this.isSavingStateInClient(facesContext)) {
            Object treeStructure = responseStateManager.getTreeStructureToRestore(facesContext, viewId);
            if (treeStructure == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Exiting restoreTreeStructure - No tree structure state found in client request");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure(treeStructure);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Tree structure restored from client request");
            }
        } else {
            Object[] state = (Object[])responseStateManager.getState(facesContext, viewId);
            Object serverStateId = this.getSecureServerStateId(state);
            Object[] stateObj = (Object[])(serverStateId == null ? null : this.getSerializedViewFromServletSession(facesContext, viewId, serverStateId));
            if (stateObj == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Exiting restoreTreeStructure - No serialized view found in server session!");
                }
                return null;
            }
            StateManager.SerializedView serializedView = new StateManager.SerializedView((StateManager)this, stateObj[0], stateObj[1]);
            Object treeStructure = serializedView.getStructure();
            if (treeStructure == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Exiting restoreTreeStructure - No tree structure state found in server session, former UIViewRoot must have been transient");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure(serializedView.getStructure());
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Tree structure restored from server session");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting restoreTreeStructure");
        }
        return uiViewRoot;
    }

    public UIViewRoot restoreView(FacesContext facesContext, String viewId, String renderKitId) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering restoreView - viewId: " + viewId + " ; renderKitId: " + renderKitId);
        }
        UIViewRoot uiViewRoot = null;
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        StateManagementStrategy sms = null;
        if (vdl != null) {
            sms = vdl.getStateManagementStrategy(facesContext, viewId);
        }
        if (sms != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Redirect to StateManagementStrategy: " + sms.getClass().getName());
            }
            uiViewRoot = sms.restoreView(facesContext, viewId, renderKitId);
        } else {
            Object[] stateArray;
            TreeStructureManager tsm;
            Object state;
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            if (this.isSavingStateInClient(facesContext)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Restoring view from client");
                }
                state = responseStateManager.getState(facesContext, viewId);
            } else {
                Object[] savedState;
                Object serverStateId;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Restoring view from session");
                }
                Object object = state = (serverStateId = this.getSecureServerStateId(savedState = (Object[])responseStateManager.getState(facesContext, viewId))) == null ? null : this.getSerializedViewFromServletSession(facesContext, viewId, serverStateId);
            }
            if (state != null && (uiViewRoot = (tsm = new TreeStructureManager()).restoreTreeStructure((stateArray = (Object[])state)[0])) != null) {
                facesContext.setViewRoot(uiViewRoot);
                uiViewRoot.processRestoreState(facesContext, stateArray[1]);
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting restoreView - " + viewId);
        }
        return uiViewRoot;
    }

    public Object saveView(FacesContext facesContext) {
        StateManagementStrategy sms;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        String viewId = uiViewRoot.getViewId();
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        if (vdl != null && (sms = vdl.getStateManagementStrategy(facesContext, viewId)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Calling saveView of StateManagementStrategy: " + sms.getClass().getName());
            }
            return sms.saveView(facesContext);
        }
        if (uiViewRoot.isTransient()) {
            return null;
        }
        return super.saveView(facesContext);
    }

    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        ExternalContext externalContext;
        Object serializedView;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering saveSerializedView");
        }
        JspStateManagerImpl.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet<String>());
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing saveSerializedView - Checked for duplicate Ids");
        }
        if ((serializedView = (externalContext = facesContext.getExternalContext()).getRequestMap().get(SERIALIZED_VIEW_REQUEST_ATTR)) == null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing saveSerializedView - create new serialized view");
            }
            Object treeStruct = this.getTreeStructureToSave(facesContext);
            Object compStates = this.getComponentStateToSave(facesContext);
            serializedView = new Object[]{treeStruct, compStates};
            externalContext.getRequestMap().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing saveSerializedView - new serialized view created");
            }
        }
        Object[] serializedViewArray = (Object[])serializedView;
        if (!this.isSavingStateInClient(facesContext)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing saveSerializedView - server-side state saving - save state");
            }
            this.saveSerializedViewInServletSession(facesContext, serializedView);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting saveSerializedView - server-side state saving - saved state");
            }
            return new StateManager.SerializedView((StateManager)this, serializedViewArray[0], (Object)new Object[0]);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting saveSerializedView - client-side state saving");
        }
        return new StateManager.SerializedView((StateManager)this, serializedViewArray[0], serializedViewArray[1]);
    }

    private static void checkForDuplicateIds(FacesContext context, UIComponent component, Set<String> ids) {
        String id = component.getId();
        if (id != null && !ids.add(id)) {
            throw new IllegalStateException("Client-id : " + id + " is duplicated in the faces tree. Component : " + component.getClientId(context) + ", path: " + JspStateManagerImpl.getPathToComponent(component));
        }
        if (component instanceof NamingContainer) {
            ids = new HashSet<String>();
        }
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent kid = (UIComponent)it.next();
            JspStateManagerImpl.checkForDuplicateIds(context, kid, ids);
        }
    }

    private static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        JspStateManagerImpl.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, intBuf.toString());
        JspStateManagerImpl.getPathToComponent(component.getParent(), buf);
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering writeState");
        }
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        if (this.isLegacyResponseStateManager(responseStateManager)) {
            responseStateManager.writeState(facesContext, serializedView);
        } else if (!this.isSavingStateInClient(facesContext)) {
            Object[] state = new Object[2];
            state[0] = this.getKeyFactory().encode(this.getNextSecureViewSequence(facesContext));
            responseStateManager.writeState(facesContext, (Object)state);
        } else {
            Object[] state = new Object[]{serializedView.getStructure(), serializedView.getState()};
            responseStateManager.writeState(facesContext, (Object)state);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting writeState");
        }
    }

    public String getViewState(FacesContext facesContext) {
        StateManagementStrategy sms;
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        String viewId = uiViewRoot.getViewId();
        ViewDeclarationLanguage vdl = facesContext.getApplication().getViewHandler().getViewDeclarationLanguage(facesContext, viewId);
        if (vdl != null && (sms = vdl.getStateManagementStrategy(facesContext, viewId)) != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Calling saveView of StateManagementStrategy from getViewState: " + sms.getClass().getName());
            }
            return facesContext.getRenderKit().getResponseStateManager().getViewState(facesContext, this.saveView(facesContext));
        }
        Object[] savedState = (Object[])this.saveView(facesContext);
        if (!this.isSavingStateInClient(facesContext)) {
            Object[] state = new Object[2];
            state[0] = this.getKeyFactory().encode(this.getNextSecureViewSequence(facesContext));
            return facesContext.getRenderKit().getResponseStateManager().getViewState(facesContext, (Object)state);
        }
        return facesContext.getRenderKit().getResponseStateManager().getViewState(facesContext, (Object)savedState);
    }

    @Override
    public void writeStateAsUrlParams(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering writeStateAsUrlParams");
        }
        if (this.isSavingStateInClient(facesContext)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing writeStateAsUrlParams - client-side state saving writing state");
            }
            UIViewRoot uiViewRoot = facesContext.getViewRoot();
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            if (responseStateManager instanceof MyfacesResponseStateManager) {
                ((MyfacesResponseStateManager)responseStateManager).writeStateAsUrlParams(facesContext, serializedView);
            } else {
                log.severe("ResponseStateManager of render kit " + uiViewRoot.getRenderKitId() + " is no MyfacesResponseStateManager and does not support saving state in url parameters.");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting writeStateAsUrlParams");
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected void saveSerializedViewInServletSession(FacesContext context, Object serializedView) {
        Map sessionMap = context.getExternalContext().getSessionMap();
        SecureSerializedViewCollection viewCollection = (SecureSerializedViewCollection)sessionMap.get(SERIALIZED_VIEW_SESSION_ATTR);
        if (viewCollection == null) {
            viewCollection = new SecureSerializedViewCollection();
            sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
        }
        SecureSerializedViewKey nextKey = this.getSessionViewStorageFactory().createSerializedViewKey(context, context.getViewRoot().getViewId(), this.getNextSecureViewSequence(context));
        viewCollection.add(context, this.serializeView(context, serializedView), nextKey);
        sessionMap.put(SERIALIZED_VIEW_SESSION_ATTR, viewCollection);
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Integer sequence) {
        return null;
    }

    protected Object getSerializedViewFromServletSession(FacesContext context, String viewId, Object sequence) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Object serializedView = null;
        if (requestMap.containsKey(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR)) {
            serializedView = requestMap.get(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR);
        } else {
            Object state;
            SecureSerializedViewCollection viewCollection = (SecureSerializedViewCollection)externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR);
            if (viewCollection != null && sequence != null && (state = viewCollection.get(this.getSessionViewStorageFactory().createSerializedViewKey(context, viewId, sequence))) != null) {
                serializedView = this.deserializeView(state);
            }
            requestMap.put(RESTORED_SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
            this.nextSecureViewSequence(context);
        }
        return serializedView;
    }

    protected int getNextViewSequence(FacesContext context) {
        return 0;
    }

    protected void nextViewSequence(FacesContext facescontext) {
    }

    protected Object getNextSecureViewSequence(FacesContext context) {
        Object sequence = context.getAttributes().get("jsf_sequence");
        if (sequence == null) {
            sequence = this.nextSecureViewSequence(context);
            context.getAttributes().put("jsf_sequence", sequence);
        }
        return sequence;
    }

    protected Object nextSecureViewSequence(FacesContext facescontext) {
        Object sequence = this.getKeyFactory().generateKey(facescontext);
        facescontext.getAttributes().put("jsf_sequence", sequence);
        return sequence;
    }

    protected Object serializeView(FacesContext context, Object serializedView) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering serializeView");
        }
        if (this.isSerializeStateInSession(context)) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Processing serializeView - serialize state in session");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            try {
                OutputStream os = baos;
                if (this.isCompressStateInSession(context)) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize compressed");
                    }
                    ((OutputStream)os).write(1);
                    os = new GZIPOutputStream(os, 1024);
                } else {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Processing serializeView - serialize uncompressed");
                    }
                    ((OutputStream)os).write(0);
                }
                Object[] stateArray = (Object[])serializedView;
                ObjectOutputStream out = new ObjectOutputStream(os);
                out.writeObject(stateArray[0]);
                out.writeObject(stateArray[1]);
                out.close();
                baos.close();
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Exiting serializeView - serialized. Bytes : " + baos.size());
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Exiting serializeView - Could not serialize state: " + e.getMessage(), e);
                return null;
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Exiting serializeView - do not serialize state in session.");
        }
        return serializedView;
    }

    protected boolean isSerializeStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(SERIALIZE_STATE_IN_SESSION_PARAM);
        boolean serialize = true;
        if (value != null) {
            serialize = Boolean.valueOf(value);
        }
        return serialize;
    }

    protected boolean isCompressStateInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(COMPRESS_SERVER_STATE_PARAM);
        boolean compress = true;
        if (value != null) {
            compress = Boolean.valueOf(value);
        }
        return compress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object deserializeView(Object state) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Entering deserializeView");
        }
        if (state instanceof byte[]) {
            Object[] objectArray;
            block15: {
                ByteArrayInputStream bais;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Processing deserializeView - deserializing serialized state. Bytes : " + ((byte[])state).length);
                }
                InputStream is = bais = new ByteArrayInputStream((byte[])state);
                if (((InputStream)is).read() == 1) {
                    is = new GZIPInputStream(is);
                }
                MyFacesObjectInputStream ois = null;
                try {
                    MyFacesObjectInputStream in;
                    ois = in = new MyFacesObjectInputStream(is);
                    Object[] object = null;
                    object = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<Object[]>(){

                        @Override
                        public Object[] run() throws PrivilegedActionException, IOException, ClassNotFoundException {
                            return new Object[]{in.readObject(), in.readObject()};
                        }
                    }) : new Object[]{in.readObject(), in.readObject()};
                    objectArray = object;
                    if (ois == null) break block15;
                }
                catch (Throwable throwable) {
                    try {
                        if (ois != null) {
                            ois.close();
                            ois = null;
                        }
                        throw throwable;
                    }
                    catch (PrivilegedActionException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        log.log(Level.SEVERE, "Exiting deserializeView - Could not deserialize state: " + e.getMessage(), e);
                        return null;
                    }
                }
                ois.close();
                ois = null;
            }
            return objectArray;
        }
        if (state instanceof Object[]) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Exiting deserializeView - state not serialized.");
            }
            return state;
        }
        if (state == null) {
            log.severe("Exiting deserializeView - this method should not be called with a null-state.");
            return null;
        }
        log.severe("Exiting deserializeView - this method should not be called with a state of type : " + state.getClass());
        return null;
    }

    private boolean isLegacyResponseStateManager(ResponseStateManager instance) {
        Method[] methods;
        for (Method m : methods = instance.getClass().getMethods()) {
            if (!m.getName().equals("getState") || !Arrays.equals(m.getParameterTypes(), new Class[]{FacesContext.class, String.class})) continue;
            return false;
        }
        return true;
    }

    protected KeyFactory getKeyFactory() {
        return this.sessionViewStorageFactory.getKeyFactory();
    }

    protected SessionViewStorageFactory getSessionViewStorageFactory() {
        return this.sessionViewStorageFactory;
    }

    protected static class SerializedViewKey
    implements Serializable {
        private static final long serialVersionUID = -1170697124386063642L;
        private final String _viewId;
        private final Integer _sequenceId = null;

        public SerializedViewKey(String viewId, Integer sequence) {
            this._viewId = null;
        }

        public SerializedViewKey(FacesContext context) {
            this._viewId = null;
        }
    }

    protected static class SerializedViewCollection
    implements Serializable {
        private static final long serialVersionUID = -3734849062185115847L;
        private final boolean _enableRemoveRestoredViewState = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext()).isEnableRemoveRestoredViewState();
        private final List<Object> _keys = new ArrayList<Object>(20);
        private final Map<Object, Object> _serializedViews = new HashMap<Object, Object>();
        private transient Map<Object, Object> _oldSerializedViews = null;

        protected SerializedViewCollection() {
        }

        public synchronized void add(FacesContext context, Object state) {
        }

        protected int getNumberOfViewsInSession(FacesContext context) {
            return 0;
        }

        protected Map<Object, Object> getOldSerializedViewsMap() {
            return null;
        }

        protected String getCacheOldViewsInSessionMode(FacesContext context) {
            return null;
        }

        public Object get(Integer sequence, String viewId) {
            return null;
        }
    }
}

