/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.myfaces.application.viewstate.SecureSerializedViewKey;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;

public class SecureSerializedViewCollection
implements Serializable {
    private static final long serialVersionUID = -3734849062185115847L;
    private static final Logger log = Logger.getLogger(SecureSerializedViewCollection.class.getName());
    private static final String NUMBER_OF_VIEWS_IN_SESSION_PARAM = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    private static final int DEFAULT_NUMBER_OF_VIEWS_IN_SESSION = 20;
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE = "org.apache.myfaces.CACHE_OLD_VIEWS_IN_SESSION_MODE";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT = "hard-soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT = "soft";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK = "soft-weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK = "weak";
    private static final String CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF = "off";
    private final boolean _enableRemoveRestoredViewState = MyfacesConfig.getCurrentInstance(FacesContext.getCurrentInstance().getExternalContext()).isEnableRemoveRestoredViewState();
    private final List<SecureSerializedViewKey> _keys = new ArrayList<SecureSerializedViewKey>(20);
    private final Map<SecureSerializedViewKey, Object> _serializedViews = new HashMap<SecureSerializedViewKey, Object>();
    private transient Map<Object, Object> _oldSerializedViews = null;

    public synchronized void add(FacesContext context, Object state, SecureSerializedViewKey key) {
        this._serializedViews.put(key, state);
        while (this._keys.remove(key)) {
        }
        this._keys.add(key);
        int views = this.getNumberOfViewsInSession(context);
        while (this._keys.size() > views) {
            key = this._keys.remove(0);
            Object oldView = this._serializedViews.remove(key);
            if (oldView == null || CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF.equals(this.getCacheOldViewsInSessionMode(context))) continue;
            this.getOldSerializedViewsMap().put(key, oldView);
        }
    }

    protected int getNumberOfViewsInSession(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(NUMBER_OF_VIEWS_IN_SESSION_PARAM);
        int views = 20;
        if (value != null) {
            try {
                views = Integer.parseInt(value);
                if (views <= 0) {
                    log.severe("Configured value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION is not valid, must be an value > 0, using default value (20");
                    views = 20;
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Error determining the value for org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION, expected an integer value > 0, using default value (20): " + e.getMessage(), e);
            }
        }
        return views;
    }

    protected Map<Object, Object> getOldSerializedViewsMap() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (this._oldSerializedViews == null && context != null) {
            String cacheMode = this.getCacheOldViewsInSessionMode(context);
            if (CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK.equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(2, 2, true);
            } else if (CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK.equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(1, 2, true);
            } else if (CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT.equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(1, 1, true);
            } else if (CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT.equals(cacheMode)) {
                this._oldSerializedViews = new ReferenceMap(0, 1);
            }
        }
        return this._oldSerializedViews;
    }

    protected String getCacheOldViewsInSessionMode(FacesContext context) {
        String value = context.getExternalContext().getInitParameter(CACHE_OLD_VIEWS_IN_SESSION_MODE);
        if (value == null) {
            return CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF;
        }
        if (value.equalsIgnoreCase(CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT)) {
            return CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT;
        }
        if (value.equalsIgnoreCase(CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK)) {
            return CACHE_OLD_VIEWS_IN_SESSION_MODE_SOFT_WEAK;
        }
        if (value.equalsIgnoreCase(CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK)) {
            return CACHE_OLD_VIEWS_IN_SESSION_MODE_WEAK;
        }
        if (value.equalsIgnoreCase(CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT)) {
            return CACHE_OLD_VIEWS_IN_SESSION_MODE_HARD_SOFT;
        }
        return CACHE_OLD_VIEWS_IN_SESSION_MODE_OFF;
    }

    public Object get(SecureSerializedViewKey key) {
        Map<Object, Object> oldSerializedViewMap;
        Object value = null;
        if (!this._enableRemoveRestoredViewState) {
            value = this._serializedViews.get(key);
        } else {
            value = this._serializedViews.remove(key);
            while (this._keys.remove(key)) {
            }
        }
        if (value == null && (oldSerializedViewMap = this.getOldSerializedViewsMap()) != null) {
            value = !this._enableRemoveRestoredViewState ? oldSerializedViewMap.get(key) : oldSerializedViewMap.remove(key);
        }
        return value;
    }
}

