/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.ConfigFilesXmlValidationUtils;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.annotation.AnnotationConfigurator;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.impl.digester.DigesterFacesConfigUnmarshallerImpl;
import org.apache.myfaces.config.impl.digester.elements.Factory;
import org.apache.myfaces.shared_impl.config.MyfacesConfig;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.xml.sax.SAXException;

public class DefaultFacesConfigurationProvider
extends FacesConfigurationProvider {
    private static final String STANDARD_FACES_CONFIG_RESOURCE = "META-INF/standard-faces-config.xml";
    private static final String DEFAULT_FACES_CONFIG = "/WEB-INF/faces-config.xml";
    private static final Set<String> FACTORY_NAMES = new HashSet<String>();
    private static final Logger log;
    private FacesConfigUnmarshaller<? extends FacesConfig> _unmarshaller;
    private AnnotationConfigurator _annotationConfigurator;

    protected void setUnmarshaller(ExternalContext ectx, FacesConfigUnmarshaller<? extends FacesConfig> unmarshaller) {
        this._unmarshaller = unmarshaller;
    }

    protected FacesConfigUnmarshaller<? extends FacesConfig> getUnmarshaller(ExternalContext ectx) {
        if (this._unmarshaller == null) {
            this._unmarshaller = new DigesterFacesConfigUnmarshallerImpl(ectx);
        }
        return this._unmarshaller;
    }

    protected void setAnnotationConfigurator(AnnotationConfigurator configurator) {
        this._annotationConfigurator = configurator;
    }

    protected AnnotationConfigurator getAnnotationConfigurator() {
        if (this._annotationConfigurator == null) {
            this._annotationConfigurator = new AnnotationConfigurator();
        }
        return this._annotationConfigurator;
    }

    @Override
    public FacesConfig getStandardFacesConfig(ExternalContext ectx) {
        try {
            InputStream stream;
            URL url;
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ClassUtils.getResource(STANDARD_FACES_CONFIG_RESOURCE)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            if ((stream = ClassUtils.getResourceAsStream(STANDARD_FACES_CONFIG_RESOURCE)) == null) {
                throw new FacesException("Standard faces config META-INF/standard-faces-config.xml not found");
            }
            if (log.isLoggable(Level.INFO)) {
                log.info("Reading standard config META-INF/standard-faces-config.xml");
            }
            FacesConfig facesConfig = this.getUnmarshaller(ectx).getFacesConfig(stream, STANDARD_FACES_CONFIG_RESOURCE);
            stream.close();
            return facesConfig;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
    }

    @Override
    public FacesConfig getAnnotationsFacesConfig(ExternalContext ectx, boolean metadataComplete) {
        return this.getAnnotationConfigurator().createFacesConfig(ectx, metadataComplete);
    }

    @Override
    public FacesConfig getMetaInfServicesFacesConfig(ExternalContext ectx) {
        try {
            org.apache.myfaces.config.impl.digester.elements.FacesConfig facesConfig = new org.apache.myfaces.config.impl.digester.elements.FacesConfig();
            Factory factory = new Factory();
            facesConfig.addFactory(factory);
            for (String factoryName : FACTORY_NAMES) {
                List<String> classList = ServiceProviderFinderFactory.getServiceProviderFinder(ectx).getServiceProviderList(factoryName);
                for (String className : classList) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Found " + factoryName + " factory implementation: " + className);
                    }
                    if (factoryName.equals("javax.faces.application.ApplicationFactory")) {
                        factory.addApplicationFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExceptionHandlerFactory")) {
                        factory.addExceptionHandlerFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.ExternalContextFactory")) {
                        factory.addExternalContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.FacesContextFactory")) {
                        factory.addFacesContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.lifecycle.LifecycleFactory")) {
                        factory.addLifecycleFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.render.RenderKitFactory")) {
                        factory.addRenderkitFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.view.facelets.TagHandlerDelegateFactory")) {
                        factory.addTagHandlerDelegateFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.context.PartialViewContextFactory")) {
                        factory.addPartialViewContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.component.visit.VisitContextFactory")) {
                        factory.addVisitContextFactory(className);
                        continue;
                    }
                    if (factoryName.equals("javax.faces.view.ViewDeclarationLanguageFactory")) {
                        factory.addViewDeclarationLanguageFactory(className);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected factory name " + factoryName);
                }
            }
            return facesConfig;
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FacesConfig> getClassloaderFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            FacesConfigResourceProvider provider = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(ectx).createFacesConfigResourceProvider(ectx);
            Collection<URL> facesConfigs = provider.getMetaInfConfigurationResources(ectx);
            for (URL url : facesConfigs) {
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML()) {
                    this.validateFacesConfig(ectx, url);
                }
                InputStream stream = null;
                try {
                    stream = this.openStreamWithoutCache(url);
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Reading config : " + url.toExternalForm());
                    }
                    appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, url.toExternalForm()));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    @Override
    public List<FacesConfig> getContextSpecifiedFacesConfig(ExternalContext ectx) {
        ArrayList<FacesConfig> appConfigResources = new ArrayList<FacesConfig>();
        try {
            for (String systemId : this.getConfigFilesList(ectx)) {
                InputStream stream;
                URL url;
                if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(systemId)) != null) {
                    this.validateFacesConfig(ectx, url);
                }
                if ((stream = ectx.getResourceAsStream(systemId)) == null) {
                    log.severe("Faces config resource " + systemId + " not found");
                    continue;
                }
                if (log.isLoggable(Level.INFO)) {
                    log.info("Reading config " + systemId);
                }
                appConfigResources.add(this.getUnmarshaller(ectx).getFacesConfig(stream, systemId));
                stream.close();
            }
        }
        catch (Throwable e) {
            throw new FacesException(e);
        }
        return appConfigResources;
    }

    @Override
    public FacesConfig getWebAppFacesConfig(ExternalContext ectx) {
        try {
            InputStream stream;
            URL url;
            FacesConfig webAppConfig = null;
            if (MyfacesConfig.getCurrentInstance(ectx).isValidateXML() && (url = ectx.getResource(DEFAULT_FACES_CONFIG)) != null) {
                this.validateFacesConfig(ectx, url);
            }
            if ((stream = ectx.getResourceAsStream(DEFAULT_FACES_CONFIG)) != null) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Reading config /WEB-INF/faces-config.xml");
                }
                webAppConfig = this.getUnmarshaller(ectx).getFacesConfig(stream, DEFAULT_FACES_CONFIG);
                stream.close();
            }
            return webAppConfig;
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        catch (SAXException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private InputStream openStreamWithoutCache(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        return connection.getInputStream();
    }

    private List<String> getConfigFilesList(ExternalContext ectx) {
        String configFiles = ectx.getInitParameter("javax.faces.CONFIG_FILES");
        ArrayList<String> configFilesList = new ArrayList<String>();
        if (configFiles != null) {
            StringTokenizer st = new StringTokenizer(configFiles, ",", false);
            while (st.hasMoreTokens()) {
                String systemId = st.nextToken().trim();
                if (DEFAULT_FACES_CONFIG.equals(systemId)) {
                    if (!log.isLoggable(Level.WARNING)) continue;
                    log.warning("/WEB-INF/faces-config.xml has been specified in the javax.faces.CONFIG_FILES context parameter of the deployment descriptor. This will automatically be removed, if we wouldn't do this, it would be loaded twice.  See JSF spec 1.1, 10.3.2");
                    continue;
                }
                configFilesList.add(systemId);
            }
        }
        return configFilesList;
    }

    private void validateFacesConfig(ExternalContext ectx, URL url) throws IOException, SAXException {
        String version = ConfigFilesXmlValidationUtils.getFacesConfigVersion(url);
        if ("1.2".equals(version) || "2.0".equals(version)) {
            ConfigFilesXmlValidationUtils.validateFacesConfigFile(url, ectx, version);
        }
    }

    static {
        FACTORY_NAMES.add("javax.faces.application.ApplicationFactory");
        FACTORY_NAMES.add("javax.faces.context.ExceptionHandlerFactory");
        FACTORY_NAMES.add("javax.faces.context.ExternalContextFactory");
        FACTORY_NAMES.add("javax.faces.context.FacesContextFactory");
        FACTORY_NAMES.add("javax.faces.lifecycle.LifecycleFactory");
        FACTORY_NAMES.add("javax.faces.render.RenderKitFactory");
        FACTORY_NAMES.add("javax.faces.view.facelets.TagHandlerDelegateFactory");
        FACTORY_NAMES.add("javax.faces.context.PartialViewContextFactory");
        FACTORY_NAMES.add("javax.faces.component.visit.VisitContextFactory");
        FACTORY_NAMES.add("javax.faces.view.ViewDeclarationLanguageFactory");
        log = Logger.getLogger(DefaultFacesConfigurationProvider.class.getName());
    }
}

