/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import com.ibm.ws.jsf.config.annotation.WebSphereLifecycleProviderFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.config.annotation.LifecycleProvider;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class LifecycleProviderFactory {
    protected static final String FACTORY_DEFAULT = WebSphereLifecycleProviderFactory.class.getName();
    private static final String FACTORY_KEY = LifecycleProviderFactory.class.getName();

    public static LifecycleProviderFactory getLifecycleProviderFactory() {
        return LifecycleProviderFactory.getLifecycleProviderFactory(FacesContext.getCurrentInstance().getExternalContext());
    }

    public static LifecycleProviderFactory getLifecycleProviderFactory(ExternalContext ctx) {
        LifecycleProviderFactory instance = (LifecycleProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        LifecycleProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (LifecycleProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, LifecycleProviderFactory.class, FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (LifecycleProviderFactory)SpiUtils.build(ctx, LifecycleProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException((Throwable)pae);
        }
        return lpf;
    }

    public static void setLifecycleProviderFactory(LifecycleProviderFactory instance) {
        FacesContext.getCurrentInstance().getExternalContext().getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract LifecycleProvider getLifecycleProvider(ExternalContext var1);

    public abstract void release();
}

