/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.NamingException;
import org.apache.myfaces.config.annotation.LifecycleProvider2;
import org.apache.myfaces.shared_impl.util.ClassUtils;

public class NoInjectionAnnotationLifecycleProvider
implements LifecycleProvider2 {
    @Override
    public Object newInstance(String className) throws InstantiationException, IllegalAccessException, NamingException, InvocationTargetException, ClassNotFoundException {
        Class clazz = ClassUtils.classForName(className);
        Object object = clazz.newInstance();
        this.processAnnotations(object);
        return object;
    }

    @Override
    public void postConstruct(Object instance) throws IllegalAccessException, InvocationTargetException {
        Method[] methods = instance.getClass().getDeclaredMethods();
        Method postConstruct = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstruct != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PostConstruct annotation");
            }
            postConstruct = method;
        }
        this.invokeAnnotatedMethod(postConstruct, instance);
    }

    @Override
    public void destroyInstance(Object instance) throws IllegalAccessException, InvocationTargetException {
        Method[] methods = instance.getClass().getDeclaredMethods();
        Method preDestroy = null;
        for (Method method : methods) {
            if (!method.isAnnotationPresent(PreDestroy.class)) continue;
            if (preDestroy != null || method.getParameterTypes().length != 0 || Modifier.isStatic(method.getModifiers()) || method.getExceptionTypes().length > 0 || !method.getReturnType().getName().equals("void")) {
                throw new IllegalArgumentException("Invalid PreDestroy annotation");
            }
            preDestroy = method;
        }
        this.invokeAnnotatedMethod(preDestroy, instance);
    }

    private void invokeAnnotatedMethod(Method method, Object instance) throws IllegalAccessException, InvocationTargetException {
        if (method != null) {
            boolean accessibility = method.isAccessible();
            method.setAccessible(true);
            method.invoke(instance, new Object[0]);
            method.setAccessible(accessibility);
        }
    }

    protected void processAnnotations(Object instance) throws IllegalAccessException, InvocationTargetException, NamingException {
    }
}

