/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.annotation;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared_impl.util.ClassUtils;

class _PackageInfo {
    private transient Logger log = null;
    private static final _PackageInfo INSTANCE = new _PackageInfo();

    _PackageInfo() {
    }

    public static final _PackageInfo getInstance() {
        return INSTANCE;
    }

    public Class[] getClasses(List<Class> classes, String pckgname) throws ClassNotFoundException {
        Enumeration<URL> resources;
        ClassLoader cld;
        String path;
        try {
            path = pckgname.replace('.', '/');
            cld = ClassUtils.getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            resources = cld.getResources(path);
            if (resources == null || !resources.hasMoreElements()) {
                throw new ClassNotFoundException("No resource for " + path);
            }
        }
        catch (NullPointerException e) {
            throw new ClassNotFoundException(pckgname + " (" + pckgname + ") does not appear to be a valid package", e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(pckgname + " (" + pckgname + ") does not appear to be a valid package", e);
        }
        while (resources.hasMoreElements()) {
            File file;
            URL resource = resources.nextElement();
            URLConnection connection = null;
            try {
                connection = resource.openConnection();
            }
            catch (IOException e) {
                throw new ClassNotFoundException(pckgname + " (" + pckgname + ") does not appear to be a valid package", e);
            }
            if (connection instanceof JarURLConnection) {
                JarURLConnection juc = (JarURLConnection)connection;
                JarFile jarFile = null;
                try {
                    jarFile = juc.getJarFile();
                }
                catch (IOException e) {
                    throw new ClassNotFoundException(pckgname + " (" + pckgname + ") does not appear to be a valid package", e);
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (!entryName.startsWith(path) || !entryName.toLowerCase().endsWith(".class")) continue;
                    String className = this.filenameToClassname(entryName);
                    this.loadClass(classes, cld, className);
                }
                continue;
            }
            try {
                file = new File(connection.getURL().toURI());
            }
            catch (URISyntaxException e) {
                this.log().log(Level.WARNING, "error loading directory " + connection, e);
                continue;
            }
            this.listFilesRecursive(classes, file, cld, pckgname);
        }
        if (classes.size() < 1) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package");
        }
        Class[] resolvedClasses = new Class[classes.size()];
        classes.toArray(resolvedClasses);
        return resolvedClasses;
    }

    protected String filenameToClassname(String entryName) {
        return entryName.substring(0, entryName.length() - 6).replace('/', '.');
    }

    protected void loadClass(List<Class> classes, ClassLoader cld, String className) {
        try {
            classes.add(cld.loadClass(className));
        }
        catch (NoClassDefFoundError e) {
            this.log().log(Level.WARNING, "error loading class " + className, e);
        }
        catch (ClassNotFoundException e) {
            this.log().log(Level.WARNING, "error loading class " + className, e);
        }
    }

    protected void listFilesRecursive(final List<Class> classes, File base, final ClassLoader cld, final String pckgname) {
        base.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    _PackageInfo.this.listFilesRecursive(classes, file, cld, pckgname + "." + file.getName());
                    return false;
                }
                if (!file.getName().toLowerCase().endsWith(".class")) {
                    return false;
                }
                String className = _PackageInfo.this.filenameToClassname(pckgname + "." + file.getName());
                _PackageInfo.this.loadClass(classes, cld, className);
                return false;
            }
        });
    }

    private Logger log() {
        if (this.log == null) {
            this.log = Logger.getLogger(_PackageInfo.class.getName());
        }
        return this.log;
    }
}

