/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;

public class FlashELResolver
extends ELResolver {
    private static final String FLASH = "flash".intern();
    private static final String KEEP = "keep".intern();
    private static final String NOW = "now".intern();
    private static final String KEEP_STATUS_KEY = "org.apache.myfaces.el.FlashELResolver.KEEP_STATUS";

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return;
        }
        String strProperty = this.castAndIntern(property);
        if (FLASH.equals(strProperty)) {
            throw new PropertyNotWritableException();
        }
        if (base instanceof Flash) {
            context.setPropertyResolved(true);
            try {
                ((Flash)base).put((Object)strProperty, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException((Throwable)e);
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return false;
        }
        String strProperty = this.castAndIntern(property);
        if (FLASH.equals(strProperty)) {
            context.setPropertyResolved(true);
            return true;
        }
        if (base instanceof Flash) {
            context.setPropertyResolved(true);
        }
        return false;
    }

    public Object getValue(ELContext elContext, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = this.castAndIntern(property);
        FacesContext facesContext = this.facesContext(elContext);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (base == null) {
            if (FLASH.equals(strProperty)) {
                elContext.setPropertyResolved(true);
                Flash flash = externalContext.getFlash();
                FlashELResolver.setDoKeepPromotion(false, facesContext);
                return flash;
            }
        } else if (base instanceof Flash) {
            Flash flash = (Flash)base;
            if (KEEP.equals(strProperty)) {
                FlashELResolver.setDoKeepPromotion(true, facesContext);
                elContext.setPropertyResolved(true);
                return base;
            }
            if (NOW.equals(strProperty)) {
                if (!FlashELResolver.isDoKeepPromotion(facesContext)) {
                    elContext.setPropertyResolved(true);
                    return externalContext.getRequestMap();
                }
            } else {
                if (FlashELResolver.isDoKeepPromotion(facesContext)) {
                    elContext.setPropertyResolved(true);
                    flash.keep(strProperty);
                    Object value = externalContext.getRequestMap().get(strProperty);
                    return value;
                }
                elContext.setPropertyResolved(true);
                return flash.get((Object)strProperty);
            }
        }
        return null;
    }

    private static boolean isDoKeepPromotion(FacesContext facesContext) {
        Boolean doKeepPromotion = (Boolean)facesContext.getAttributes().get(KEEP_STATUS_KEY);
        if (doKeepPromotion == null) {
            doKeepPromotion = false;
        }
        return doKeepPromotion;
    }

    private static void setDoKeepPromotion(boolean value, FacesContext facesContext) {
        facesContext.getAttributes().put(KEEP_STATUS_KEY, value);
    }

    protected FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    protected ExternalContext externalContext(ELContext context) {
        return this.facesContext(context).getExternalContext();
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = this.castAndIntern(property);
        if (FLASH.equals(strProperty)) {
            context.setPropertyResolved(true);
        } else if (base instanceof Flash) {
            context.setPropertyResolved(true);
            Object obj = ((Flash)base).get(property);
            return obj != null ? obj.getClass() : null;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        ArrayList<FeatureDescriptor> descriptors = new ArrayList<FeatureDescriptor>(1);
        descriptors.add(this.makeDescriptor(FLASH, "Represents the current flash scope", Object.class));
        if (base instanceof Flash) {
            for (Object key : ((Flash)base).keySet()) {
                FeatureDescriptor desc = this.makeDescriptor(key.toString(), key.toString(), key.getClass());
                descriptors.add(desc);
            }
        }
        return descriptors.iterator();
    }

    protected FeatureDescriptor makeDescriptor(String name, String description, Class<?> elResolverType) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setValue("resolvableAtDesignTime", Boolean.TRUE);
        fd.setValue("type", elResolverType);
        fd.setName(name);
        fd.setDisplayName(name);
        fd.setShortDescription(description);
        fd.setExpert(false);
        fd.setHidden(false);
        fd.setPreferred(true);
        return fd;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        if (base instanceof Flash) {
            return Object.class;
        }
        if (FLASH.equals(base.toString())) {
            return Object.class;
        }
        return null;
    }

    protected String castAndIntern(Object o) {
        String s = (String)o;
        return s.intern();
    }
}

