/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.Behavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;
import javax.faces.render.ClientBehaviorRenderer;

public class HtmlAjaxBehaviorRenderer
extends ClientBehaviorRenderer {
    private static final String QUOTE = "'";
    private static final String BLANK = " ";
    private static final String AJAX_KEY_ONERROR = "onerror";
    private static final String AJAX_KEY_ONEVENT = "onevent";
    private static final String AJAX_KEY_EXECUTE = "execute";
    private static final String AJAX_KEY_RENDER = "render";
    private static final String AJAX_VAL_THIS = "this";
    private static final String AJAX_VAL_EVENT = "event";
    private static final String JS_AJAX_REQUEST = "jsf.ajax.request";
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String COMMA = ",";
    private static final String ERR_NO_AJAX_BEHAVIOR = "The behavior must be an instance of AjaxBehavior";
    private static final String L_PAREN = "(";
    private static final String R_PAREN = ")";
    private static final String BEHAVIOR_EVENT = "javax.faces.behavior.event";
    private static final String IDENTIFYER_MARKER = "@";

    public void decode(FacesContext context, UIComponent component, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled() || !component.isRendered()) {
            return;
        }
        this.dispatchBehaviorEvent(component, ajaxBehavior);
    }

    public String getScript(ClientBehaviorContext behaviorContext, ClientBehavior behavior) {
        this.assertBehavior(behavior);
        AjaxBehavior ajaxBehavior = (AjaxBehavior)behavior;
        if (ajaxBehavior.isDisabled()) {
            return null;
        }
        return this.makeAjax(behaviorContext, ajaxBehavior).toString();
    }

    private final void dispatchBehaviorEvent(UIComponent component, AjaxBehavior ajaxBehavior) {
        AjaxBehaviorEvent event = new AjaxBehaviorEvent(component, (Behavior)ajaxBehavior);
        PhaseId phaseId = ajaxBehavior.isImmediate() || this.isComponentImmediate(component) ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.INVOKE_APPLICATION;
        event.setPhaseId(phaseId);
        component.queueEvent((FacesEvent)event);
    }

    private final boolean isComponentImmediate(UIComponent component) {
        Method immediate = null;
        try {
            immediate = component.getClass().getMethod("isImmediate", new Class[0]);
            if (Modifier.isPublic(immediate.getModifiers()) || immediate.getReturnType().equals(Boolean.TYPE) || immediate.getReturnType().equals(Boolean.class)) {
                return (Boolean)immediate.invoke((Object)component, new Object[0]);
            }
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            throw new FacesException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private final StringBuilder makeAjax(ClientBehaviorContext context, AjaxBehavior behavior) {
        StringBuilder retVal = new StringBuilder();
        StringBuilder executes = this.mapToString(context, AJAX_KEY_EXECUTE, behavior.getExecute());
        StringBuilder render = this.mapToString(context, AJAX_KEY_RENDER, behavior.getRender());
        String onError = behavior.getOnerror();
        onError = onError != null && !onError.trim().equals(EMPTY) ? "onerror:" + onError : null;
        String onEvent = behavior.getOnevent();
        onEvent = onEvent != null && !onEvent.trim().equals(EMPTY) ? "onevent:" + onEvent : null;
        String sourceId = context.getSourceId() == null ? AJAX_VAL_THIS : '\'' + context.getSourceId() + '\'';
        String event = context.getEventName();
        retVal.append(JS_AJAX_REQUEST);
        retVal.append(L_PAREN);
        retVal.append(sourceId);
        retVal.append(COMMA);
        retVal.append(AJAX_VAL_EVENT);
        retVal.append(COMMA);
        Collection params = context.getParameters();
        int paramSize = params != null ? params.size() : 0;
        ArrayList<String> parameterList = new ArrayList<String>(paramSize + 2);
        if (executes != null) {
            parameterList.add(executes.toString());
        }
        if (render != null) {
            parameterList.add(render.toString());
        }
        if (onError != null) {
            parameterList.add(onError);
        }
        if (onEvent != null) {
            parameterList.add(onEvent);
        }
        if (paramSize > 0) {
            for (ClientBehaviorContext.Parameter param : params) {
                StringBuilder paramVal = new StringBuilder();
                paramVal.append(QUOTE);
                paramVal.append(param.getName());
                paramVal.append(QUOTE);
                paramVal.append(COLON);
                paramVal.append(QUOTE);
                paramVal.append(param.getValue().toString());
                paramVal.append(QUOTE);
                parameterList.add(paramVal.toString());
            }
        }
        parameterList.add("'javax.faces.behavior.event':'" + event + QUOTE);
        retVal.append((CharSequence)this.buildOptions(parameterList));
        retVal.append(R_PAREN);
        return retVal;
    }

    private StringBuilder buildOptions(List<String> options) {
        StringBuilder retVal = new StringBuilder();
        retVal.append("{");
        boolean first = true;
        for (String option : options) {
            if (option == null || option.trim().equals(EMPTY)) continue;
            if (!first) {
                retVal.append(COMMA);
            } else {
                first = false;
            }
            retVal.append(option);
        }
        retVal.append("}");
        return retVal;
    }

    private final StringBuilder mapToString(ClientBehaviorContext context, String target, Collection<String> dataHolder) {
        int executeSize;
        StringBuilder retVal = new StringBuilder(20);
        if (dataHolder == null) {
            dataHolder = Collections.emptyList();
        }
        if ((executeSize = dataHolder.size()) > 0) {
            retVal.append(target);
            retVal.append(COLON);
            retVal.append(QUOTE);
            int cnt = 0;
            for (String strVal : dataHolder) {
                ++cnt;
                if ((strVal = strVal.trim()).equals(EMPTY)) continue;
                if (!strVal.startsWith(IDENTIFYER_MARKER)) {
                    retVal.append(this.getComponentId(context, strVal));
                } else {
                    retVal.append(strVal);
                }
                if (cnt >= dataHolder.size()) continue;
                retVal.append(BLANK);
            }
            retVal.append(QUOTE);
            return retVal;
        }
        return null;
    }

    private final String getComponentId(ClientBehaviorContext context, String id) {
        UIComponent contextComponent = context.getComponent();
        UIComponent target = contextComponent.findComponent(id);
        if (target == null) {
            target = contextComponent.findComponent(COLON + id);
        }
        if (target != null) {
            return target.getClientId();
        }
        throw new FacesException("Component with id:" + id + " not found");
    }

    private final void assertBehavior(ClientBehavior behavior) {
        if (!(behavior instanceof AjaxBehavior)) {
            throw new FacesException(ERR_NO_AJAX_BEHAVIOR);
        }
    }
}

